@extends('employee.layouts')
@section('title', 'Products')

@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/dataTables.bootstrap5.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/responsive.bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/datatable/buttons.dataTables.min.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
    <style>
        table td,
        table th {
            vertical-align: middle;
            white-space: normal !important;
        }
    </style>
@endsection

@section('content')

    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Products</h3>
                <div>
                    {{-- <a type="button" href="{{ route('add_product') }}" class="btn btn-primary feature-btn">
                        <i class="fa-solid fa-circle-plus me-2"></i>Add Product
                    </a> --}}
                    <!-- GST Toggle below the button -->
                    {{-- <div class="form-check form-switch mt-2">
                        <input class="form-check-input" type="checkbox" id="gstToggle"
                            {{ auth()->user()->is_gst ? 'checked' : '' }}>
                        <label class="form-check-label" for="gstToggle"> Enable GST for Admin</label>
                    </div> --}}

                </div>
            </div>
        </div>


        <div class="row mb-3">
            <div class="col-md-3">
                <select id="categoryFilter" class="form-select">
                    <option value="">All Categories</option>
                    @foreach ($products->pluck('category_name')->unique() as $category)
                        <option value="{{ $category }}">{{ $category }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <select id="subCategoryFilter" class="form-select">
                    <option value="">All Subcategories</option>
                    @foreach ($products->pluck('subcategory_name')->unique() as $subcategory)
                        <option value="{{ $subcategory }}">{{ $subcategory }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6 text-end">
                <button id="allProductsBtn" class="btn btn-primary me-2">
                    <i class="fa-solid fa-list me-1"></i>All Products
                </button>
                {{-- <button id="customExcelBtn" class="btn btn-success">
                    <i class="fa-solid fa-file-excel me-2"></i>Export as Excel
                </button> --}}
            </div>
        </div>


        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
<table id="data-table" class="table table-bordered table-striped align-middle table-responsive" style="width:100%">
    <thead>
        <tr>
            <th>S/N</th>
            <th>CATEGORY</th>
            <th class="d-none d-md-table-cell">SUB CATEGORY</th>
            <th class="d-none d-lg-table-cell">BRAND</th>
            <th>PRODUCT ID</th>
            <th class="d-none d-lg-table-cell">HSN CODE</th>
            <th style="max-width: 150px;">TITLE</th>
            {{-- <th>PURCHASE PRICE</th> --}}
            <th>SALES PRICE</th>
            <th>S-WALLET</th>
            <th class="d-none d-md-table-cell">STOCK</th>
            {{-- <th style="display: none;">BARCODE 1</th>
            <th style="display: none;">BARCODE 2</th> --}}
            {{-- <th>ACTION</th> --}}
        </tr>
    </thead>
    <tbody>
        @foreach ($products as $product)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $product->category_name ?? 'N/A' }}</td>
                <td class="d-none d-md-table-cell">{{ $product->subcategory_name ?? 'N/A' }}</td>
                <td class="d-none d-lg-table-cell">{{ $product->brand ?? 'N/A' }}</td>
                <td>{{ $product->product_id ?? 'N/A' }}</td>
                <td class="d-none d-lg-table-cell">{{ $product->hsn_code ?? 'N/A' }}</td>
                <td class="text-truncate" style="max-width: 150px;" title="{{ $product->title }}">
                    {{ $product->title ?? 'N/A' }}
                </td>
                {{-- <td>{{ number_format($product->purchase_price ?? 0, 2) }}</td> --}}
                <td>{{ number_format($product->sell_price ?? 0, 2) }}</td>
                <td>{{ $product->shop_wallet ?? 'N/A' }}</td>
                <td class="d-none d-md-table-cell">{{ $product->stock ?? '0' }}</td>

                {{-- <td style="display: none;">{{ $product->barcode1 ?? '' }}</td>
                <td style="display: none;">{{ $product->barcode2 ?? '' }}</td> --}}

                {{-- <td>
                    <a href="{{ route('employee.view_product', ['id' => $product->id]) }}"
                        class="btn btn-sm btn-outline-info p-1" title="View">
                        <i class="bi bi-eye"></i>
                    </a>


                    <button type="button" class="btn btn-sm btn-outline-success p-1 updateStockBtn"
                        data-id="{{ $product->id }}"
                        data-productid="{{ $product->product_id }}"
                        data-title="{{ $product->title }}"
                        data-stock="{{ $product->stock }}"
                        data-bs-toggle="modal"
                        data-bs-target="#updateStockModal"
                        title="Update Stock">
                        <i class="bi bi-pencil-square"></i>
                    </button>
                </td> --}}
            </tr>
        @endforeach
    </tbody>
</table>

                      

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->
        {{-- @foreach ($products as $product)
            <div class="modal fade zoom-in" id="DeleteModal-{{ $product->id }}" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="p-3">
                                        <div class="text-center">
                                            <img class="mb-3"
                                                src="{{ asset('/assets/images/icons/delete-icon.svg') }}">
                                            <p class="my-4 are-you-sure">Are You Sure?</p>
                                            <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete
                                                this product: <strong>{{ $product->title }}</strong>?</p>
                                        </div>
                                        <div class="d-flex align-items-center mt-5 mb-3">
                                            <button data-bs-dismiss="modal"
                                                class="btn btn-light cancel-btn me-3">Cancel</button>
                                            <a href="{{ route('delete_product', ['id' => $product->id]) }}"
                                                class="btn btn-primary yes-btn">
                                                <i class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach --}}

        <!-- Update Stock Modal -->
        <div class="modal fade" id="updateStockModal" tabindex="-1" aria-labelledby="updateStockModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <form method="POST" action="{{ route('employee.update_stock') }}">
                    @csrf
                    <input type="hidden" name="id" id="update-stock-id">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Update Stock</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p><strong>Product ID:</strong> <span id="modal-product-id"></span></p>
                            <p><strong>Title:</strong> <span id="modal-product-title"></span></p>

                            <div class="mb-3">
                                <label for="stock" class="form-label">New Stock</label>
                                <input type="number" name="stock" id="update-stock-value" class="form-control"
                                    required min="0">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update Stock</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


        <div class="modal fade" id="barcodeModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Barcode</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center" id="barcode-content-to-print">
                        <h5 class="modal-title mb-2" id="modalRole"></h5>
                        <svg id="barcodeModalSvg"></svg>
                        <div class="mt-3 text-center">
                            <p><strong>Item Code:</strong> <span id="modalItemCode"></span></p>
                            <p><strong>Title:</strong> <span id="modalTitle"></span></p>
                            <p><strong>SP:</strong> <span id="modalSellPrice"></span></p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="downloadBarcodeBtnModal" class="btn btn-sm btn-primary">Download as PDF</button>
                        <button id="printBarcodeBtnModal" class="btn btn-sm btn-success">Print Label</button>

                        <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

    </div>


@endsection

@section('footer')

    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>





    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const updateButtons = document.querySelectorAll('.updateStockBtn');

            updateButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    const productId = this.getAttribute('data-productid');
                    const title = this.getAttribute('data-title');
                    const stock = this.getAttribute('data-stock');

                    document.getElementById('update-stock-id').value = id;
                    document.getElementById('modal-product-id').innerText = productId;
                    document.getElementById('modal-product-title').innerText = title;
                    document.getElementById('update-stock-value').value = stock;
                });
            });
        });
    </script>
   


    <script src="https://cdn.jsdelivr.net/npm/jsprintmanager@7.0.0/JSPrintManager.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const userRole = '{{ Auth::user()->role ?? 'admin' }}';
            const companyName = '{{ Auth::user()->role ?? 'admin' }}';

            JSPM.JSPrintManager.auto_restart = true;
            JSPM.JSPrintManager.start();
            JSPM.JSPrintManager.onStatusChanged = () => {
                console.log("JSPM Status:", JSPM.JSPrintManager.websocket_status);
            };

            document.querySelectorAll('.viewBarcodeBtn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const itemCode = this.getAttribute('data-id');
                    const title = this.getAttribute('data-title');
                    const sellPrice = this.getAttribute('data-sellprice');

                    JsBarcode("#barcodeModalSvg", itemCode, {
                        format: "CODE128",
                        lineColor: "#000",
                        width: 2,
                        height: 50,
                        displayValue: true
                    });

                    document.getElementById('modalRole').innerText = companyName;
                    document.getElementById('modalItemCode').innerText = itemCode;
                    document.getElementById('modalTitle').innerText = title || '(No Title)';
                    document.getElementById('modalSellPrice').innerText = sellPrice || '(No Price)';

                    new bootstrap.Modal(document.getElementById('barcodeModal')).show();
                });
            });

         


            document.getElementById('printBarcodeBtnModal').addEventListener('click', function() {
                const itemCode = document.getElementById('modalItemCode').innerText;
                const title = document.getElementById('modalTitle').innerText;
                const sellPrice = document.getElementById('modalSellPrice').innerText;
                const barcodeSvg = document.getElementById('barcodeModalSvg').outerHTML;
                const companyName = document.getElementById('modalRole').innerText;

                const numberOfLabelsToPrint = 3; // Still aiming for 3x4 grid

                const labelHTML = `
<html style="width:400px; height:110px">
<head>
    <title>Print Barcode</title>
    <style>
        @page {
            size: 110mm 100mm; 
            margin: 0 !important; 
            padding: 0 !important; 
        }
        body {
            margin: 0 !important; 
            padding: 0 !important; 
            font-family: Arial, sans-serif;
            font-size: 6px; /* Base font size */
            width: 110mm !important; /* Force body width */
            overflow: hidden; /* Hide anything that spills out */
        }
        .label-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 equal columns */
            width: 110mm !important; /* Force container width to match @page width */
            height:25mm; /* Explicit height for the container to match page height */
            gap: 0 !important; /* No gaps between grid items */
            padding: 0 !important; /* No padding on the container itself */
            margin: 0 !important; /* No margins on the container */
        }
        .label {
            /* Precise width for each label: 110mm / 3 */
            width: 36.666mm !important; /* Use more precision and !important */
            height: 25mm !important; /* Force exact height */
            box-sizing: border-box; /* Padding and border are included in the width/height */
            padding: 0.2mm !important; /* Minimal internal padding */
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            text-align: center;
            overflow: hidden; /* Hide overflowing content */
            page-break-inside: avoid; /* Helps prevent labels from splitting across pages */
        }
        .label svg {
            width: 90% !important; /* Keep barcode wide */
            max-height: 10mm !important; /* Adjust max height if barcode looks too stretched or squashed */
            margin-top: 0.2mm !important; /* Reduced margin */
        }
        .company, .item-code, .title, .price {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 100%;
            line-height: 1 !important; /* Tight line spacing */
            margin-top: 0.2mm !important; /* Minimal top margin */
        }
        .company { font-weight: bold; font-size: 6.5px !important; }
        .item-code { font-size: 7px !important; font-weight: bold; }
        .title { font-size: 6px !important; }
        .price { font-size: 7px !important; font-weight: bold; }

        /* Ensure precise rendering for print */
        @media print {
            html, body {
                width: 110mm !important;
                height: 25mm !important; /* Match @page height */
                margin: 0 !important;
                padding: 0 !important;
                overflow: hidden !important;
            }
            .label-container {
                 width: 110mm !important;
                 height: 25mm !important;
                 overflow: hidden !important;
            }
            .label {
                 width: 36.666mm !important;
                 height: 25mm !important;
            }
            /* Critical: Forcing exact sizing on print */
            * {
                box-sizing: border-box !important;
            }
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    </style>
</head>
<body>
    <div class="label-container">
        ${[...Array(numberOfLabelsToPrint)].map(() => `
                        <div class="label">
                            <div class="company">${companyName.slice(0, 25)}</div>
                            ${barcodeSvg}
                            <div class="item-code">${itemCode}</div>
                            <div class="title">${title.slice(0, 25)}</div>
                            <div class="price">SP: ${sellPrice}</div>
                        </div>
                    `).join('')}
    </div>
</body>
</html>
`;

                const printWindow = window.open('', '_blank', 'width=800,height=600');
                printWindow.document.write(labelHTML);
                printWindow.document.close();
                printWindow.focus();
                printWindow.onload = function() {
                    printWindow.print();
                    setTimeout(() => printWindow.close(), 500);
                };
            });

            document.getElementById('downloadBarcodeBtnModal').addEventListener('click', function() {
                const {
                    jsPDF
                } = window.jspdf;
                const pdf = new jsPDF('l', 'mm', [110, 25]);
                const itemCode = document.getElementById('modalItemCode').innerText;
                const title = document.getElementById('modalTitle').innerText;
                const sellPrice = document.getElementById('modalSellPrice').innerText;

                const canvas = document.createElement('canvas');
                canvas.width = 400;
                canvas.height = 80;

                JsBarcode(canvas, itemCode, {
                    format: "CODE128",
                    width: 2,
                    height: 50,
                    displayValue: false
                });

                const imgData = canvas.toDataURL("image/png");
                const labelW = 110 / 3;

                function drawLabel(xOffset) {
                    const centerX = xOffset + labelW / 2;
                    let y = 2;
                    pdf.setFontSize(6.5);
                    pdf.text(companyName.slice(0, 25), centerX, y, {
                        align: 'center'
                    });
                    y += 1;
                    pdf.addImage(imgData, 'PNG', centerX - 15, y, 30, 10);
                    y += 11;
                    pdf.setFontSize(6);
                    pdf.text(itemCode, centerX, y, {
                        align: 'center'
                    });
                    y += 2.5;
                    pdf.text(title.slice(0, 25), centerX, y, {
                        align: 'center'
                    });
                    y += 2.5;
                    pdf.text(`SP: ${sellPrice}`, centerX, y, {
                        align: 'center'
                    });
                }

                drawLabel(0);
                drawLabel(labelW);
                drawLabel(labelW * 2);
                pdf.save(`barcode_${itemCode}.pdf`);
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            var table = $('#data-table').DataTable({
                responsive: true,
                dom: 'lfrtip',
                buttons: [{
                    extend: 'excelHtml5',
                    title: 'Products',
                    exportOptions: {
                        modifier: {
                            page: 'all',
                            search: 'applied',
                            order: 'applied'
                        }
                    }
                }],
                paging: true
            });

            // Excel export button
            $('#customExcelBtn').on('click', function() {
                table.button('.buttons-excel').trigger();
            });

            // Filter by category
            $('#categoryFilter').on('change', function() {
                table.column(1).search(this.value).draw();
            });

            // Filter by subcategory
            $('#subCategoryFilter').on('change', function() {
                table.column(2).search(this.value).draw();
            });

            // Show all products button
            $('#allProductsBtn').on('click', function() {
                $('#categoryFilter').val('');
                $('#subCategoryFilter').val('');
                table.column(1).search('').draw();
                table.column(2).search('').draw();
            });
        });
    </script>

    <script>
        $('#gstToggle').on('change', function() {
            const isGst = $(this).is(':checked');

            $.ajax({
                url: "{{ route('admin.update_gst') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    is_gst: isGst
                },
                success: function(response) {
                    if (response.success) {
                        alert('GST status updated successfully!');
                    } else {
                        alert('Failed to update GST status.');
                    }
                },
                error: function() {
                    alert('Something went wrong!');
                }
            });
        });
    </script>


    <script>
        $('#noteToggle').on('change', function() {
            const isNote = $(this).is(':checked');

            $.ajax({
                url: "{{ route('admin.update_note') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    is_note: isNote
                },
                success: function(response) {
                    if (response.success) {
                        alert('Note status updated successfully!');
                    } else {
                        alert('Failed to update note status.');
                    }
                },
                error: function() {
                    alert('Something went wrong!');
                }
            });
        });
    </script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.bootstrap5.min.js') }}"></script>
    {{-- <script type="text/javascript" src="{{asset('/assets/js/datatable/datatables.init.js')}}"></script> --}}
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.responsive.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jquery.dataTables.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/dataTables.buttons.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.html5.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/buttons.print.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/jszip.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/pdfmake.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/datatable/vfs_fonts.js') }}"></script>



@endsection
