<?php
use App\Http\Controllers\Profile\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\{
    AddressController,
    CategoryController,
    CheckoutController,
    ForgetPasswordController,
    LoginController,
    ProductController,
    RegisterController,
    UserController,
    WishlistController,
    CartController
};
use App\Http\Controllers\Bank\BankController;
use App\Http\Controllers\Profile\ShiprocketController;
use App\Http\Controllers\Subscription\SubscriptionController;
use App\Http\Controllers\Video\VideoController;
use App\Http\Controllers\Withdraw\WithdrawalController;
// ✅ First layer of protection: API key
Route::middleware('api.key')->group(function () {
    // ✅ Public Routes (API Key Only)
    Route::post('registration_post', [RegisterController::class, 'registration_post']);
    Route::post('login_post', [LoginController::class, 'login_post']);
    Route::post('forget_sendotp', [ForgetPasswordController::class, 'forget_sendotp']);
    Route::post('forget_verifyotp', [ForgetPasswordController::class, 'forget_verifyotp']);
    Route::post('reset_password_update', [ForgetPasswordController::class, 'reset_password_update']);
    Route::get('show_logo', [UserController::class, 'show_logo']);
    Route::get('banner', [UserController::class, 'banner']);
    Route::get('category', [UserController::class, 'category']);
    Route::get('single_product/{id}', [UserController::class, 'single_product']);
    Route::get('subcategory/{categoryId}', [UserController::class, 'subcategory']);
    Route::get('Products_by_subcategory/{subcategoryId}', [ProductController::class, 'Products_by_subcategory']);
    Route::get('Product_by_category/{categoryId}', [ProductController::class, 'Product_by_category']);
    Route::get('get_all_products', [ProductController::class, 'get_all_products']);
    Route::post('search_product', [WishlistController::class, 'search_product']);
      //companydeatils
         Route::get('company_details', [UserController::class, 'company_details']);
    Route::middleware('auth:sanctum')->group(function () {
        // Login/Referral
        Route::get('referral_link', [LoginController::class, 'referral_link']);
        Route::post('reset_password', [LoginController::class, 'reset_password']);
        Route::post('profile_update', [LoginController::class, 'profile_update']);
        Route::post('logout', [UserController::class, 'logout']);
        // Membership & Wallet
        Route::get('membership_list', [SubscriptionController::class, 'membership_list']);
        Route::post('add_subscription', [SubscriptionController::class, 'add_subscription']);
        Route::get('bank_details', [SubscriptionController::class, 'bank_details']);
        Route::get('income_wallet', [SubscriptionController::class, 'income_wallet']);
        // Video Tasks
        Route::get('daily_task', [VideoController::class, 'daily_task']);
        Route::get('daily_videos', [VideoController::class, 'daily_videos']);
        Route::get('single_video/{video_id}', [VideoController::class, 'single_video']);
        Route::post('video_form', [VideoController::class, 'video_form']);
        // Checkout & Orders
        Route::post('checkout', [CartController::class, 'checkout']);
        Route::get('getCheckoutDetails/{orderId}', [CartController::class, 'getCheckoutDetails']);
        Route::post('get_checkout_details', [CheckoutController::class, 'get_checkout_details']);
        Route::post('create_order', [CheckoutController::class, 'create_order']);
        Route::post('order_place', [CheckoutController::class, 'order_place']);
        Route::post('/init-razorpay-order', [CheckoutController::class, 'initRazorpayOrder']);
        Route::get('order_details/{user_id}', [CategoryController::class, 'order_details']);
        Route::get('orderdetails/{order_random_id}', [CheckoutController::class, 'orderdetails']);
        // Cart
        Route::post('cart_add', [CartController::class, 'cart_add']);
        Route::get('cart', [CartController::class, 'cart']);
        Route::post('cart_update', [CartController::class, 'cart_update']);
        Route::post('cart_delete', [CartController::class, 'cart_delete']);
        Route::post('buy_now', [CartController::class, 'buy_now']);
        // Address
        Route::post('address', [AddressController::class, 'address']);
        Route::post('address_update/{id}', [AddressController::class, 'address_update']);
        Route::get('addresses', [AddressController::class, 'addresses']);
        Route::get('addresses_delete/{id}', [AddressController::class, 'addresses_delete']);
        Route::get('show_address/{id}', [AddressController::class, 'show_address']);
        Route::post('address_current/{id}', [AddressController::class, 'address_current']);
        // Wishlist
        Route::post('wishlist', [WishlistController::class, 'wishlist']);
        Route::post('wishlist_update', [WishlistController::class, 'wishlist_update']);
        Route::get('wishlist_delete/{product_id}', [WishlistController::class, 'wishlist_delete']);
        Route::get('wishlist_display', [WishlistController::class, 'wishlist_display']);
        // User Info
        Route::get('user_details', [UserController::class, 'user_details']);
        Route::get('notification', [UserController::class, 'notification']);
        Route::get('referral_team/{membership_title?}', [UserController::class, 'referral_team']);
        // Bank
        Route::post('add_bank', [BankController::class, 'add_bank']);
        Route::get('get_all_banks', [BankController::class, 'get_all_banks']);
        Route::get('get_userbank_details', [BankController::class, 'get_userbank_details']);
        Route::get('get_activebank_details', [BankController::class, 'get_activebank_details']);
        Route::get('get_user_wallet', [BankController::class, 'get_user_wallet']);
        Route::get('get_cashwallet_history', [BankController::class, 'get_cashwallet_history']);
        Route::get('get_shoppingwallet_history', [BankController::class, 'get_shoppingwallet_history']);
        Route::get('get_wallet_histories', [BankController::class, 'get_wallet_histories']);
        Route::get('help_center', [BankController::class, 'help_center']);
        // Withdrawals
        Route::post('withdraw_request', [WithdrawalController::class, 'withdraw_request']);
        Route::get('withdraw_history', [WithdrawalController::class, 'withdraw_history']);
      //shiprocket
       Route::post('shiprocket_create_orders', [ShiprocketController::class, 'shiprocket_create_orders']);
    });
});
