<?php
use App\Http\Controllers\Admin\AdminController as AdminAdminController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ForgetPasswordController;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\OfflinesaleController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\PurchaseController;
use App\Http\Controllers\AdminNewPOSController;
use App\Http\Controllers\Employee\EmployeeForgetController;
use App\Http\Controllers\Profile\ProfileController;
use App\Http\Controllers\Withdraw\WithdrawalController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Bank\BankController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\API\CategoryController as APICategoryController;
use App\Http\Controllers\Subscription\SubscriptionController;
use App\Http\Controllers\Video\VideoController;
use Carbon\Carbon;
use App\Http\Controllers\Profile\ShiprocketController;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\BrevoMailController;
use App\Http\Controllers\Admin\PosController;
use App\Http\Controllers\Admin\EmployeeController;
use App\Http\Controllers\WEB\DashboardController as WEBDashboardController;
use App\Http\Controllers\Employee\EmployeeLoginController;
use App\Http\Controllers\Employee\EmployeePosController;
//backup
Route::get('/backup', [AdminController::class, 'runBackup']);
//mail
Route::get('/brevo_mail', [BrevoMailController::class, 'send']);
Route::get('/rename_log', [BrevoMailController::class, 'rename_log']);
Route::get('/test_mail', function () {
    Mail::raw('This is a test email using Brevo SMTP in Laravel.', function ($message) {
        $message->to('ansalnaans2002@gmail.com')
            ->subject('Test Email');
    });
    return 'Email sent!';
});
//shiprockect
Route::get('shiprocket_get_token', [ShiprocketController::class, 'shiprocket_get_token'])->name('shiprocket_get_token');
Route::get('shiprocket_create_orders', [ShiprocketController::class, 'shiprocket_create_orders'])->name('shiprocket_create_orders');
Route::get('getPickupLocations', [ShiprocketController::class, 'getPickupLocations'])->name('getPickupLocations');
Route::get('getOrders', [ShiprocketController::class, 'getOrders'])->name('getOrders');
Route::get('getSingleOrder/{id}', [ShiprocketController::class, 'getSingleOrder'])->name('getSingleOrder');
Route::get('cancelOrders', [ShiprocketController::class, 'cancelOrders'])->name('cancelOrders');
Route::get('getCourierPartners/{orderId}', [ShiprocketController::class, 'getCourierPartners'])->name('getCourierPartners');
Route::get('assignShip/{shipmentId}/{courierId?}', [ShiprocketController::class, 'assignShip'])->name('assignShip');
//
Route::get('about_us', [AdminController::class, 'about_us'])->name('about_us');
Route::get('privacy_policy', [AdminController::class, 'privacy_policy'])->name('privacy_policy');
Route::get('terms_condition', [AdminController::class, 'terms_condition'])->name('terms_condition');
Route::get('refund_policy', [AdminController::class, 'refund_policy'])->name('refund_policy');
Route::get('delete_user', [AdminController::class, 'delete_user'])->name('delete_user');
Route::post('user_delete_post', [AdminController::class, 'user_delete_post'])->name('user_delete_post');
Route::get('/check-time', function () {
    $now = Carbon::now();
    return response()->json([
        'current_time' => $now->format('d-m-Y h:i A'),
        'timezone' => config('app.timezone'),
    ]);
});
Route::get('/register/{user_id?}', [AdminController::class, 'register'])->name('admin.register');
Route::post('register_form', [AdminController::class, 'register_form'])->name('register_form');
//ans
// registration_success
Route::get('registration_success', [AdminController::class, 'registration_success'])->name('registration_success');
// Completed 
Route::prefix('admin')->group(function () {
    //login
    Route::get('/', [AdminController::class, 'login'])->name('admin.login');
    Route::post('login_sendotp', [LoginController::class, 'login_sendotp'])->name('login_sendotp');
    Route::post('login_verifyotp', [LoginController::class, 'login_verifyotp'])->name('login_verifyotp');
    //forgetpassword
    Route::get('forgot_password', [AdminController::class, 'forgot_password'])->name('forgot_password');
    Route::post('forgot_password', [ForgetPasswordController::class, 'handle'])->name('forgotpassword.handle');
    //admin
    Route::get('create_password/{email}', [AdminController::class, 'create_password'])->name('create_password');
    Route::post('reset_password_update', [ForgetPasswordController::class, 'reset_password_update'])->name('reset_password_update');
    //user
    Route::get('user_create_password/{email}/{id}', [AdminController::class, 'user_create_password'])->name('user_create_password');
    Route::post('forget_update', [ForgetPasswordController::class, 'forget_update'])->name('forget_update');
    Route::get('sucess_password', [AdminController::class, 'sucess_password'])->name('admin.sucess_password');
    //
    Route::get('employee_login', [EmployeeController::class, 'employee_login'])->name('employee_login');
    Route::post('employee_login_post', [EmployeeController::class, 'employee_login_post'])->name('employee_login_post');
    Route::middleware(['adminauth'])->group(function () {
        //dashboard
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        Route::get('employee_list', [EmployeeLoginController::class, 'employee_list'])->name('employee_list');
        Route::get('view_employee/{id}', [EmployeeLoginController::class, 'view_employee'])->name('view_employee');
        Route::post('employee_delete/{id}', [EmployeeLoginController::class, 'employee_delete'])->name('employee.delete');
        Route::get('edit_branch', [EmployeeLoginController::class, 'edit_branch'])->name('edit_branch');
        // Route::post('update_branch_admin', [EmployeeLoginController::class, 'update_branch_admin'])->name('update_branch_admin');
Route::post('/store', [EmployeeLoginController::class, 'store_branch_admin'])->name('branch-admin.store');
Route::post('/update/{id}', [EmployeeLoginController::class, 'update_branch_admin'])->name('branch-admin.update');
        Route::get('sakthi_dashboard', [AdminController::class, 'sakthi_dashboard'])->name('sakthi_dashboard');
        Route::get('smartworld_dashboard', [AdminController::class, 'smartworld_dashboard'])->name('smartworld_dashboard');
        Route::get('smartgift_dashboard', [AdminController::class, 'smartgift_dashboard'])->name('smartgift_dashboard');
        Route::get('yoganaturals_dashboard', [AdminController::class, 'yoganaturals_dashboard'])->name('yoganaturals_dashboard');
        //branch
        Route::get('add_branch', [AdminController::class, 'add_branch'])->name('add_branch');
        Route::post('branch_post', [ProfileController::class, 'branch_post'])->name('branch_post');
        Route::get('branch-delete/{id}', [ProfileController::class, 'branch_delete'])->name('branch_delete');
        //Video
        Route::get('add_video', [VideoController::class, 'add_video'])->name('add_video');
        Route::post('add_video_form', [VideoController::class, 'add_video_form'])->name('add_video_form');
        Route::post('video_delete', [VideoController::class, 'video_delete'])->name('video_delete');
        Route::get('add_bank', [AdminController::class, 'add_bank'])->name('add_bank');
        Route::get('bank_history', [AdminController::class, 'bank_history'])->name('bank_history');
        Route::post('add_bank_details', [BankController::class, 'add_bank_details'])->name('add_bank_details');
        Route::get('edit_bank/{id}', [AdminController::class, 'edit_bank'])->name('edit_bank');
        Route::post('update_bank/{id}', [BankController::class, 'update_bank'])->name('update_bank');
        Route::post('toggle_bank_status/{id}', [BankController::class, 'toggle_bank_status'])->name('toggle_bank_status');
        Route::delete('delete_bank/{id}', [BankController::class, 'delete_bank'])->name('delete_bank');
        //logout
        Route::post('logout', [LoginController::class, 'logout'])->name('logout');
        //reset_password
        Route::get('reset_password', [AdminController::class, 'reset_password'])->name('reset_password');
        Route::post('reset_password_handle', [LoginController::class, 'reset_password_handle'])->name('reset_password_handle');
        //notification
        Route::get('notification', [AdminController::class, 'notification'])->name('notification');
        Route::post('notification_post', [DashboardController::class, 'notification_post'])->name('notification_post');
        Route::post('popup_notification', [DashboardController::class, 'popup_notification'])->name('popup_notification');
        Route::get('notification_delete/{id}', [DashboardController::class, 'notification_delete'])->name('notification_delete');
        //banner
        Route::get('banner', [AdminController::class, 'banner'])->name('banner');
        Route::post('banner_post', [DashboardController::class, 'banner_post'])->name('banner_post');
        Route::get('banner_delete/{id}', [DashboardController::class, 'banner_delete'])->name('banner_delete');
        //deliver_fee
        Route::get('delivery_fee', [AdminController::class, 'delivery_fee'])->name('delivery_fee');
        Route::post('delivery_fee_post', [DashboardController::class, 'delivery_fee_post'])->name('delivery_fee_post');
        Route::get('delivery_fee_delete/{id}', [DashboardController::class, 'delivery_fee_delete'])->name('delivery_fee_delete');
        //category
        Route::get('category', [AdminController::class, 'category'])->name('category');
        Route::get('add_category', [AdminController::class, 'add_category'])->name('add_category');
        Route::post('add_category_post', [CategoryController::class, 'add_category_post'])->name('add_category_post');
        Route::get('category_delete/{id}', [CategoryController::class, 'category_delete'])->name('category_delete');
        Route::get('view_category/{id}', [AdminController::class, 'view_category'])->name('view_category');
        Route::post('categories_update/{id}', [CategoryController::class, 'categories_update'])->name('categories_update');
        //gst
        Route::post('/admin/update-gst-status', [AdminController::class, 'updateGstStatus'])->name('admin.update_gst');
        //user_management
        Route::get('user_management', [AdminController::class, 'user_management'])->name('user_management');
        //product
        Route::get('products', [AdminController::class, 'products'])->name('products');
        Route::get('add_product', [AdminController::class, 'add_product'])->name('add_product');
        Route::post('store_product', [CategoryController::class, 'store_product'])->name('store_product');
        Route::get('view_product/{id}', [AdminController::class, 'view_product'])->name('view_product');
        Route::post('update_product/{id}', [CategoryController::class, 'update_product'])->name('update_product');
        Route::get('delete_product/{id}', [CategoryController::class, 'delete_product'])->name('delete_product');
        Route::post('/product/toggle-note', [CategoryController::class, 'toggleNote'])->name('product.toggleNote');
        Route::post('/update-stock', [CategoryController::class, 'updateStock'])->name('update_stock');
        Route::post('/upload-temp-images', [CategoryController::class, 'uploadTempImages'])->name('upload.temp.images');
        Route::post('/remove-temp-image', [CategoryController::class, 'removeTempImage'])->name('remove.temp.image');
        //subcategories
        Route::get('getSubcategories', [CategoryController::class, 'getSubcategories'])->name('getSubcategories');
        //recent_orders
        Route::get('recent_orders', [AdminController::class, 'recent_orders'])->name('recent_orders');
        Route::post('accept_order', [OrderController::class, 'accept_order'])->name('accept_order');
        // Route::post('order_decline', [OrderController::class, 'declineOrder'])->name('decline_order');
        Route::post('update_imei_serial', [OrderController::class, 'updateImeiSerial'])->name('update_imei_serial');
        //accepted_orders
        Route::get('accept_orders', [AdminController::class, 'accept_orders'])->name('accept_orders');
        Route::get('rejected_orders', [AdminController::class, 'rejected_orders'])->name('rejected_orders');
        Route::get('shiprocket', [AdminController::class, 'shiprocket'])->name('shiprocket');
        Route::post('ship_order', [OrderController::class, 'ship_order'])->name('ship_order');
        //shippedorders
        Route::get('processing_orders', [AdminController::class, 'processing_orders'])->name('processing_orders');
        Route::post('confirm_delivery', [OrderController::class, 'confirm_delivery'])->name('confirm_delivery');
        //delivered_orders
        Route::get('delivered_orders', [AdminController::class, 'delivered_orders'])->name('delivered_orders');
        //profile
        Route::get('profile', [AdminController::class, 'profile'])->name('profile');
        Route::post('profile_update', [LoginController::class, 'profile_update'])->name('profile_update');
        //view_orders
        Route::get('view_orders/{id}', [AdminController::class, 'view_orders'])->name('view_orders');
        //delivery_post_pricefrom 
        Route::get('delivery_price_page', [DashboardController::class, 'delivery_price_page'])->name('delivery_price_page');
        Route::post('delivery_post', [DashboardController::class, 'delivery_post'])->name('delivery_post');
        //viewing_orders
        Route::get('view_recent_orders/{order_random_id}', [AdminController::class, 'view_recent_orders'])->name('view_recent_orders');
        Route::get('view_delivered_orders/{order_random_id}', [AdminController::class, 'view_delivered_orders'])->name('view_delivered_orders');
        Route::get('view_processing_orders/{order_random_id}', [AdminController::class, 'view_processing_orders'])->name('view_processing_orders');
        Route::get('view_accepted_orders/{order_random_id}', [AdminController::class, 'view_accepted_orders'])->name('view_accepted_orders');
        Route::post('decline_order', [OrderController::class, 'decline_order'])->name('decline_order');
        Route::get('cancelled_orders', [AdminController::class, 'cancelled_orders'])->name('cancelled_orders');
        Route::get('view_cancel_orders/{order_random_id}', [AdminController::class, 'view_cancel_orders'])->name('view_cancel_orders');
        //subscription
        Route::get('subscription_requests', [SubscriptionController::class, 'subscription_requests'])->name('subscription_requests');
        Route::post('accept_request', [SubscriptionController::class, 'accept_request'])->name('accept_request');
        Route::post('reject_request', [SubscriptionController::class, 'reject_request'])->name('reject_request');
        Route::get('subscription_history', [SubscriptionController::class, 'subscription_history'])->name('subscription_history');
        Route::get('reject_subscription', [SubscriptionController::class, 'reject_subscription'])->name('reject_subscription');
        //ans
        Route::post('users_store', [LoginController::class, 'users_store'])->name('users_store');
        Route::get('referral_link', [AdminController::class, 'referral_link'])->name('referral_link');
        Route::get('add_user', [AdminController::class, 'add_user'])->name('add_user');
        Route::get('edit_user/{id}', [AdminController::class, 'edit_user'])->name('edit_user');
        Route::post('edit_update/{id}', [ProfileController::class, 'edit_update'])->name('edit_update');
        Route::get('toggle_activation/{id}', [ProfileController::class, 'toggle_activation'])->name('toggle_activation');
        Route::get('edit_cashwallet/{id}', [AdminController::class, 'edit_cashwallet'])->name('edit_cashwallet');
        Route::get('edit_shoppingwallet/{id}', [AdminController::class, 'edit_shoppingwallet'])->name('edit_shoppingwallet');
        Route::post('cashwallet_update/{id}', [SubscriptionController::class, 'cashwallet_update'])->name('cashwallet_update');
        Route::post('shopwallet_update/{id}', [SubscriptionController::class, 'shopwallet_update'])->name('shopwallet_update');
        Route::get('daily_task_history', [AdminController::class, 'daily_task_history'])->name('daily_task_history');
        Route::get('edit_daily_task/{id}', [AdminController::class, 'edit_daily_task'])->name('edit_daily_task');
        Route::post('update_dailytask/{id}', [VideoController::class, 'update_dailytask'])->name('update_dailytask');
        Route::get('create_plan_form', [AdminController::class, 'create_plan_form'])->name('create_plan_form');
        Route::post('create_plan', [SubscriptionController::class, 'create_plan'])->name('create_plan');
        Route::get('edit_plan/{id}', [AdminController::class, 'edit_plan'])->name('edit_plan');
        Route::get('create_plan_history', [AdminController::class, 'create_plan_history'])->name('create_plan_history');
        Route::post('plan_delete', [SubscriptionController::class, 'plan_delete'])->name('plan_delete');
        Route::post('update_plan/{id}', [SubscriptionController::class, 'update_plan'])->name('update_plan');
        Route::get('shopping_wallet_transaction', [AdminController::class, 'shopping_wallet_transaction'])->name('shopping_wallet_transaction');
        Route::get('cash_wallet_transaction', [AdminController::class, 'cash_wallet_transaction'])->name('cash_wallet_transaction');
        Route::get('withdraw_request', [AdminController::class, 'withdraw_request'])->name('withdraw_request');
        Route::post('accept_withdraw', [WithdrawalController::class, 'accept_withdraw'])->name('accept_withdraw');
        Route::post('reject_withdraw', [WithdrawalController::class, 'reject_withdraw'])->name('reject_withdraw');
        Route::get('variant_destroy/{id}', [CategoryController::class, 'variant_destroy'])->name('variants_destroy');
        Route::get('orders_accept/{order_random_id}', [OrderController::class, 'orders_accept'])->name('orders_accept');
        Route::get('orders_reject/{order_random_id}', [AdminController::class, 'orders_reject'])->name('orders_reject');
        Route::get('invoice/{order_random_id}', [AdminController::class, 'invoice'])->name('invoice');
        Route::post('/product/remove-image', [CategoryController::class, 'removeImage'])->name('product_removeImage');
        Route::get('accepted_withdraw', [AdminController::class, 'accepted_withdraw'])->name('accepted_withdraw');
        Route::get('rejected_withdraw', [AdminController::class, 'rejected_withdraw'])->name('rejected_withdraw');
        Route::post('contact_submit', [VideoController::class, 'contact_submit'])->name('contact_submit');
        Route::get('contact_us', [AdminController::class, 'contact_us'])->name('contact_us');
        Route::post('contact_update', [VideoController::class, 'contact_update'])->name('contact_update');
        Route::post('contact_delete', [VideoController::class, 'contact_delete'])->name('contact_delete');
        Route::post('contact_toggle_status', [VideoController::class, 'contact_toggle_status'])->name('contact_toggle_status');
        Route::get('user_purchase_history/{user_id}', [AdminController::class, 'user_purchase_history'])->name('user_purchase_history');
        Route::get('daily_transaction_history', [AdminController::class, 'daily_transaction_history'])->name('daily_transaction_history');
        Route::get('add_logo', [AdminController::class, 'add_logo'])->name('add_logo');
        Route::post('add_logo_post', [VideoController::class, 'add_logo_post'])->name('add_logo_post');
        //sales
        Route::get('sales', [AdminController::class, 'sales'])->name('sales');
        Route::get('offline_sales_history', [AdminController::class, 'offline_sales_history'])->name('offline_sales_history');
        Route::get('/getUserDetailsAndWalletByPhone/{phoneNumber}', [OfflinesaleController::class, 'getUserDetailsAndWalletByPhone']);
        Route::get('/getUserDetailsAndWallet/{userId}', [OfflinesaleController::class, 'getUserDetailsAndWallet']);
        Route::post('/place_offlineorder', [OfflinesaleController::class, 'place_offlineorder'])->name('place_offlineorder');
        Route::get('/products/{productId}', [OfflinesaleController::class, 'getProductDetails']);
        Route::get('/generateInvoice/{orderId}', [OfflinesaleController::class, 'generateInvoice']);
        Route::get('/offline-sales/{orderId}/edit', [OfflinesaleController::class, 'editOfflineSale'])->name('offline_sales_edit');
        Route::put('/offline-sales/{orderId}', [OfflinesaleController::class, 'updateOfflineSale'])->name('offline_sales_update');
        Route::post('cancel_shiprocket_order', [OrderController::class, 'cancel_shiprocket_order'])->name('cancel_shiprocket_order');
        Route::get('get_nextitem_code', [CategoryController::class, 'get_nextitem_code'])->name('get_nextitem_code');
        Route::post('/admin/update-note', [AdminController::class, 'updateNote'])->name('admin.update_note');
        Route::get('pos_billing', [AdminController::class, 'pos_billing'])->name('pos_billing');
        Route::post('/search-customer', [AdminNewPOSController::class, 'searchCustomer'])->name('search-customer');
        Route::post('/search-products', [AdminNewPOSController::class, 'searchProducts'])->name('search-products');
        Route::post('save-bill', [AdminNewPOSController::class, 'saveBill'])->name('save-bill');
        Route::post('hold-bill', [AdminNewPOSController::class, 'holdBill'])->name('hold-bill');
        Route::get('held-bills', [AdminNewPOSController::class, 'getHeldBills'])->name('held-bills');
        Route::post('resume-bill/{orderId}', [AdminNewPOSController::class, 'resumeHeldBill'])->name('resume-bill');
        Route::delete('delete-held-bill/{orderId}', [AdminNewPOSController::class, 'deleteHeldBill'])->name('delete-held-bill');
        Route::get('invoice_a4/{orderId}', [AdminNewPOSController::class, 'printA4Invoice'])->name('invoice_a4');
        Route::get('invoice_thermal/{orderId}', [AdminNewPOSController::class, 'printThermalInvoice'])->name('invoice_thermal');
        Route::get('invoice_a4_purchase/{orderId}', [PurchaseController::class, 'invoice_a4_purchase'])->name('invoice_a4_purchase');
        Route::get('invoice_thermal_purchase/{orderId}', [PurchaseController::class, 'invoice_thermal_purchase'])->name('invoice_thermal_purchase');
        Route::get('fetchInvoiceForEdit/{order_id}', [AdminNewPOSController::class, 'fetchInvoiceForEdit'])->name('fetchInvoiceForEdit');
        Route::delete('admin/delete_invoice/{id}', [AdminNewPOSController::class, 'deleteInvoice'])->name('delete_invoice');
        Route::get('bill_wise_profit', [AdminController::class, 'billWiseProfit'])->name('bill_wise_profit');
        Route::get('bill_invoice_a4/{orderId}', [AdminNewPOSController::class, 'bill_invoice_a4'])->name('bill_invoice_a4');
        Route::get('gstr_1', [AdminController::class, 'gstr1'])->name('gstr_1');
        Route::get('gstr_2', [AdminController::class, 'gstr2'])->name('gstr_2');
        Route::get('purchase_invoices', [AdminController::class, 'purchase_invoices'])->name('purchase_invoices');
        Route::get('purchase_parties', [AdminController::class, 'purchase_parties'])->name('purchase_parties');
        Route::get('/generate-barcode/{item_code}', [CategoryController::class, 'generateBarcode'])->name('generate.barcode');
        Route::get('stock_summary', [AdminController::class, 'stock_summary'])->name('stock_summary');
        // Route::get('stock_details', [AdminController::class, 'stock_details'])->name('stock_details');
Route::get('stock-details/{id}', [AdminController::class, 'stock_details'])
    ->name('stock_details');
        Route::get('create_invoice', [PurchaseController::class, 'create_invoice'])->name('create_invoice');
        Route::post('purchase_store_post', [DashboardController::class, 'purchase_store_post'])->name('purchase_store_post');
        //   Route::post('purchase/update/{id}', [DashboardController::class, 'purchase_update'])->name('purchase_update');
        Route::put('/purchase/update/{id}', [DashboardController::class, 'purchase_update'])->name('purchase_update');
        Route::get('edit_purchase/{id}', [AdminController::class, 'edit_purchase'])->name('edit_purchase');
        Route::get('invoice_create', [AdminController::class, 'invoice_create'])->name('invoice_create');
        Route::get('/get-products', [PurchaseController::class, 'getAllProducts']);
        Route::get('purchase/create', [PurchaseController::class, 'create_invoice'])->name('admin.purchase.create');
        Route::post('purchase_store', [PurchaseController::class, 'purchase_store'])->name('purchase_store');
        // Route::get('purchase/print/{id}/{type}', [PurchaseController::class, 'printPurchaseInvoice'])->name('admin.purchase.print');
        Route::get('products_search', [PurchaseController::class, 'PurchasesearchProducts'])->name('products_search');
        Route::get('suppliers_search', [PurchaseController::class, 'searchSuppliers'])->name('suppliers_search');
        Route::post('suppliers_store', [PurchaseController::class, 'storeSupplier'])->name('suppliers_store');
        // Route for listing all purchases (renamed from purchase_parties for clarity)
        Route::get('purchases', [PurchaseController::class, 'purchase_parties'])->name('admin.purchases.index');
        Route::get('purchase/edit/{id}', [PurchaseController::class, 'editPurchase'])->name('purchase.edit');
        Route::post('purchase/update/{id}', [PurchaseController::class, 'updatePurchase'])->name('purchase.update');
        Route::get('add_employee', [AdminController::class, 'add_employee'])->name('add_employee');
        Route::post('employee_store', [EmployeeController::class, 'employee_store'])->name('employee_store');
        Route::post('/employee/{id}', [EmployeeController::class, 'employee_update'])->name('employee.update');
        Route::get('employee_delete/{id}', [EmployeeController::class, 'employee_delete'])->name('employee_delete');
        Route::get('edit_employee/{id}', [EmployeeController::class, 'edit_employee'])->name('edit_employee');
        //   Route::get('edit_invoice/{id}', [AdminNewPOSController::class, 'editInvoice'])->name('edit_invoice');
        Route::get('edit_invoice/{id}', [AdminNewPOSController::class, 'editInvoice'])->name('edit_invoice');
        Route::post('update_invoice/{id}', [AdminNewPOSController::class, 'updateInvoice'])->name('update_invoice');
        Route::delete('delete_invoice/{id}', [AdminNewPOSController::class, 'deleteInvoice'])->name('delete_invoice');
        Route::get('fetchInvoiceForEdit/{id}', [AdminNewPOSController::class, 'fetchInvoiceForEdit'])->name('fetchInvoiceForEdit');
        Route::post('register-new-customer', [AdminNewPOSController::class, 'registerNewCustomer'])->name('register-new-customer');
    });
});
Route::prefix('employee')->group(function () {
    // Route::get('/', [EmployeePosController::class, 'employee_login'])->name('employee.login');
    Route::get('/', [EmployeePosController::class, 'employee_login'])
        ->name('employee.login');
    //login
    Route::post('employee_login_post', [EmployeePosController::class, 'employee_login_post'])->name('employee_login_post');
    Route::post('employee_login_sendotp', [EmployeeLoginController::class, 'employee_login_sendotp'])->name('employee_login_sendotp');
    Route::post('employee_login_verifyotp', [EmployeeLoginController::class, 'employee_login_verifyotp'])->name('employee_login_verifyotp');
    //forgetpassword
    Route::get('forgot_password', [EmployeeForgetController::class, 'forgot_password'])->name('employee.forgot_password');
    Route::post('forgot_password', [EmployeeForgetController::class, 'handle'])->name('employee.forgotpassword.handle');
    //admin
    Route::get('create_password/{email}', [EmployeeForgetController::class, 'create_password'])->name('employee.create_password');
    Route::post('reset_password_update', [EmployeeForgetController::class, 'reset_password_update'])->name('employee.reset_password_update');
    //user
    Route::get('user_create_password/{email}/{id}', [EmployeeForgetController::class, 'user_create_password'])->name('user_create_password');
    // Route::post('forget_update', [EmployeeForgetController::class, 'forget_update'])->name('forget_update');
    Route::middleware(['auth:employee'])->group(function () {
        Route::get('/dashboard', [EmployeeLoginController::class, 'employeedashboard'])->name('employee.dashboard');
        Route::get('/offline_sales_history', [EmployeePosController::class, 'employeeoffline_sales_history'])->name('employee.offline_sales_history');
        Route::get('pos_billing', [EmployeePosController::class, 'employeepos_billing'])->name('employee.pos_billing');
        Route::post('search-customer', [EmployeePosController::class, 'employeesearchCustomer'])->name('employeesearch-customer');
        Route::post('search-products', [EmployeePosController::class, 'employeesearchProducts'])->name('employeesearch-products');
        Route::post('save-bill', [EmployeePosController::class, 'employeesaveBill'])->name('employeesave-bill');
        Route::post('hold-bill', [EmployeePosController::class, 'employeeholdBill'])->name('employeehold-bill');
        Route::get('held-bills', [EmployeePosController::class, 'employeegetHeldBills'])->name('employeeheld-bills');
        Route::post('resume-bill/{orderId}', [EmployeePosController::class, 'employeeresumeHeldBill'])->name('employeeresume-bill');
        Route::delete('delete-held-bill/{orderId}', [EmployeePosController::class, 'employeedeleteHeldBill'])->name('employeedelete-held-bill');
        Route::get('invoice_a4/{orderId}', [EmployeePosController::class, 'employeeprintA4Invoice'])->name('employeeinvoice_a4');
        Route::get('invoice_thermal/{orderId}', [EmployeePosController::class, 'employeeprintThermalInvoice'])->name('employeeinvoice_thermal');
        Route::get('invoice_a4_purchase/{orderId}', [EmployeePosController::class, 'employeeinvoice_a4_purchase'])->name('employeeinvoice_a4_purchase');
        Route::get('edit_invoice/{id}', [EmployeePosController::class, 'employeeeditInvoice'])->name('employeeedit_invoice');
        Route::post('update_invoice/{id}', [EmployeePosController::class, 'employeeupdateInvoice'])->name('employeeupdate_invoice');
        Route::delete('delete_invoice/{id}', [EmployeePosController::class, 'employeedeleteInvoice'])->name('employeedelete_invoice');
        //product
        Route::get('products', [EmployeePosController::class, 'products'])->name('employee.product');
        Route::get('view_product/{id}', [EmployeePosController::class, 'view_product'])->name('employee.view_product');
        Route::post('/update-stock', [EmployeePosController::class, 'updateStock'])->name('employee.update_stock');
          Route::post('register-new-customer', [EmployeePosController::class, 'registerNewCustomer'])->name('employee.register-new-customer');
        //logout
        Route::post('employee_logout', [EmployeeLoginController::class, 'employee_logout'])->name('employee_logout');
        Route::get('profile', [EmployeeLoginController::class, 'profile'])->name('employee.profile');
        Route::post('profile_update', [EmployeeLoginController::class, 'profile_update'])->name('employee.profile_update');
        Route::get('reset_password', [EmployeeLoginController::class, 'reset_password'])->name('employee.reset_password');
        Route::post('reset_password_handle', [EmployeeLoginController::class, 'reset_password_handle'])->name('employee.reset_password_handle');
    });
});