
<?php $__env->startSection('title', 'stock summary'); ?>
<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/dataTables.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/responsive.bootstrap.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/buttons.dataTables.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
    <style>
        table td,
        table th {
            vertical-align: middle;
            white-space: normal !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $totalPurchaseValue = 0;
        $totalSalesValue = 0;
        foreach ($products as $product) {
            $totalPurchaseValue += ($product->purchase_price ?? 0) * ($product->stock ?? 0);
            $totalSalesValue += ($product->sell_price ?? 0) * ($product->stock ?? 0);
        }
    ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="row mb-3">
            <div class="col-12">
                <h2 class="page-title">Stock Summary</h2>
            </div>
        </div>
        <div class="row mb-3" id="totalsRow">
            <div class="col-md-3">
                <div class="card bg-light">
                <div class="card-body p-2">
    <strong>Total Purchase Value: <span id="totalPurchaseValue"><?php echo e(number_format($totalPurchaseValue, 2)); ?></span></strong>
</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-light">
                 <div class="card-body p-2">
    <strong>Total Sales Value: <span id="totalSalesValue"><?php echo e(number_format($totalSalesValue, 2)); ?></span></strong>
</div>
                </div>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-3">
                <select id="categoryFilter" class="form-select">
                    <option value="">All Categories</option>
                    <?php $__currentLoopData = $products->pluck('category_name')->unique(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category); ?>"><?php echo e($category); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <select id="subcategoryFilter" class="form-select"> <!-- ✅ fixed ID -->
                    <option value="">All Subcategories</option>
                    <?php $__currentLoopData = $products->pluck('subcategory_name')->unique(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subcategory); ?>"><?php echo e($subcategory); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-6 text-end">
                <button id="customExcelBtn" class="btn btn-success">
                    <i class="fa-solid fa-file-excel me-2"></i>Export as Excel
                </button>
            </div>
        </div>
        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table table-bordered table-striped align-middle table-responsive"
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>CATEGORY</th>
                                    <th class="d-none d-md-table-cell">SUB CATEGORY</th>
                                    <th>PRODUCT ID</th>
                                    <th style="max-width: 150px;">TITLE</th>
                                     <th style="max-width: 150px;">AGENCY</th>
                                    <th>PURCHASE PRICE</th>
                                    <th>SALES PRICE</th>
                                    <th class="d-none d-md-table-cell">STOCK</th>
                                    <th class="d-none d-md-table-cell">STOCK VALUE</th>
                                    <th class="d-none d-md-table-cell">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $stockValue = ($product->sell_price ?? 0) * ($product->stock ?? 0);
                                    ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($product->category_name ?? 'N/A'); ?></td>
                                        <td class="d-none d-md-table-cell"><?php echo e($product->subcategory_name ?? 'N/A'); ?></td>
                                        <td><?php echo e($product->product_id ?? 'N/A'); ?></td>
                                        <td class="text-truncate" style="max-width: 150px;" title="<?php echo e($product->title); ?>">
                                            <?php echo e($product->title ?? 'N/A'); ?>

                                        </td>
                                        <td class="text-truncate" style="max-width: 150px;" title="<?php echo e($product->brand); ?>">
                                            <?php echo e($product->brand ?? 'N/A'); ?>

                                        </td>
                                        <td><?php echo e(number_format($product->purchase_price ?? 0, 2)); ?></td>
                                        <td><?php echo e(number_format($product->sell_price ?? 0, 2)); ?></td>
                                        <td class="d-none d-md-table-cell"><?php echo e($product->stock ?? '0'); ?></td>
                                        <td class="d-none d-md-table-cell"><?php echo e(number_format($stockValue, 2)); ?></td>
                                        <td><a href="<?php echo e(route('stock_details', $product->product_id)); ?>"
                                                class="btn btn-primary btn-sm">
                                                View
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.bootstrap5.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/buttons.html5.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/buttons.print.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/jszip.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/pdfmake.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/vfs_fonts.js')); ?>"></script>
    
    <script>
$(document).ready(function() {
    var table = $('#data-table').DataTable({
        responsive: true,
        dom: 'lfrtip',
        buttons: [{
            extend: 'excelHtml5',
            title: 'Products',
            exportOptions: {
                modifier: {
                    page: 'all',
                    search: 'applied',
                    order: 'applied'
                }
            }
        }],
        paging: true
    });
    // 🔹 Function to update totals dynamically (for ALL filtered rows, across ALL pages)
    function updateTotals(table) {
        var totalSales = 0;
        var totalPurchase = 0;
        // ✅ Use { search: 'applied' } + { page: 'all' } to include all pages
        table.rows({ search: 'applied', page: 'all' }).every(function() {
            var data = this.data();
            // Adjust indexes to your actual columns
            var purchasePrice = parseFloat(data[6].replace(/,/g, '')) || 0; // PURCHASE PRICE
            var salesPrice = parseFloat(data[7].replace(/,/g, '')) || 0;    // SALES PRICE
            var stock = parseFloat(data[8].replace(/,/g, '')) || 0;         // STOCK
            totalPurchase += purchasePrice * stock;
            totalSales += salesPrice * stock;
        });
        // Update the HTML values
        $('#totalPurchaseValue').text(totalPurchase.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
        $('#totalSalesValue').text(totalSales.toLocaleString(undefined, {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }));
    }
    // Initial load
    updateTotals(table);
    // 🔹 Recalculate on search, pagination, or filter change
    table.on('draw search', function() {
        updateTotals(table);
    });
    // 🔹 On Category filter
    $('#categoryFilter').on('change', function() {
        var val = this.value;
        table.column(1).search(val ? '^' + val + '$' : '', true, false).draw();
    });
    // 🔹 On Subcategory filter
    $('#subcategoryFilter').on('change', function() {
        var val = this.value;
        table.column(2).search(val ? '^' + val + '$' : '', true, false).draw();
    });
    // 🔹 On reset
    $('#allProductsBtn').on('click', function() {
        $('#categoryFilter').val('');
        $('#subcategoryFilter').val('');
        table.search('').columns().search('').draw();
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/stock_summary.blade.php ENDPATH**/ ?>