

<?php $__env->startSection('title', 'Add Product'); ?>

<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.css" integrity="sha512-..."

    crossorigin="anonymous" />

<head>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

</head>

<style>

    input#images[type="file"]::file-selector-button,

    input#video[type="file"]::file-selector-button {

        border: 2px solid #022859;

        padding: 10px;

        border-radius: 0.2em;

        background-color: #022859;

        transition: 1s;

        color: #fff;

        cursor: pointer;

    }

    input#images[type="file"]::file-selector-button:hover,

    input#video[type="file"]::file-selector-button:hover {

        background-color: #022859 !important;

        border: 2px solid #022859 !important;

    }

    .form-select {

        -webkit-appearance: none;

        -moz-appearance: none;

        appearance: none;

        background-image: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='black' class='bi bi-chevron-down' viewBox='0 0 16 16'><path fill-rule='evenodd' d='M1.646 5.646a.5.5 0 0 1 .708 0L8 11.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/></svg>");

        background-repeat: no-repeat;

        background-position: right 10px center;

        background-size: 16px;

        background: #022859

    }

    .variant-heading {

        margin-bottom: 9px !important;

        width: fit-content;

        padding: 7px 20px;

        background-color: #FBBB00 !important;

        color: #020A13;

        font-weight: 600;

        font-size: 14px;

        border-radius: 5px !important;

    }

    .drag-drop-area {

        border: 2px dashed #ccc;

        padding: 20px;

        text-align: center;

    }

    .drag-drop-area.drag-over {

        border-color: #007bff;

    }

    .remove-image-btn {

        margin-top: 10px;

        cursor: pointer;

        background-color: red;

        color: white;

        border: none;

        padding: 5px;

        border-radius: 3px;

    }

    .image-wrapper {

        margin: 10px;

        display: inline-block;

        position: relative;

    }

    .image-wrapper img {

        display: block;

    }

</style>

<?php $__env->startSection('header'); ?>

    <!-- Page CSS -->

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid page-wrapper">

        <div class="row">

            <div class="d-flex align-items-center">

                <h3 class="page-top-heading">view Product</h3>

            </div>

        </div>

        <div class="row d-flex justify-content-center mt-4">

            <div class="col-lg-12">

                <div class="card ILY-form-card">

                    <div class="card-header d-none">

                        <h5 class="card-title">View Product</h5>

                    </div>

                    <div class="card-body">

                        <form action="<?php echo e(route('update_product', $product->id)); ?>" method="POST" id="edit_product"

                            enctype="multipart/form-data">

                            <?php echo csrf_field(); ?>

                            <?php echo method_field('POST'); ?>

                            <div class="row">

                                <div class="d-flex justify-content-end mb-3 col-lg-12">

                                    <div class="form-check form-switch">

                                        <input type="checkbox" class="form-check-input m-2" id="noteToggle" name="is_note"

                                            value="1" <?php echo e(old('is_note', $product->is_note) ? 'checked' : ''); ?>>

                                        <label class="form-check-label" for="noteToggle">Publish App</label>

                                    </div>

                                </div>

                                <svg id="barcode" style="display: none;"></svg>

                                <!-- Generate Barcode Button -->

                                <div class="col-lg-12 mb-2 text-end">

                                    <button type="button" id="generateBarcodeBtn" class="btn btn-sm btn-outline-primary"

                                        style="font-size: 0.75rem; padding: 0.25rem 0.5rem;"

                                        data-title="<?php echo e($product->title ?? 'i PHONE 16 - 128GB - Black'); ?>">

                                        <i class="bi bi-upc-scan me-1"></i> Barcode

                                    </button>

                                </div>

                                <div class="col-lg-12">

                                    <div class="form-group">

                                        <label for="productImages">Product Images</label>

                                        <div class="drag-drop-area">

                                            <div id="imagePreview">

                                                <?php

                                                    $images = $product->product_image

                                                        ? json_decode($product->product_image, true)

                                                        : [];

                                                ?>

                                                <?php if(!empty($images) && is_array($images)): ?>

                                                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                        <div class="image-wrapper"

                                                            data-image="<?php echo e(basename($product_image)); ?>">

                                                            <img src="<?php echo e(asset($product_image)); ?>" alt="Product Image"

                                                                width="100">

                                                            <button type="button" class="remove-image-btn"

                                                                data-image="<?php echo e(basename($product_image)); ?>">Remove</button>

                                                        </div>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php endif; ?>

                                            </div>

                                            <div>

                                                <label for="fileInput"

                                                    class="drag-drop-label <?php echo e(!empty($images) ? 'd-none' : ''); ?>">

                                                    <span>click here to upload</span>

                                                </label>

                                            </div>

                                            <div class="mt-4">

                                                <input type="file" name="images[]" id="fileInput"

                                                    accept=".jpg,.jpeg,.png,.webp,.gif,.svg,.bmp"

                                                    class="<?php echo e(!empty($images) ? 'd-none' : ''); ?>" multiple>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                <!-- Category Select -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="category_select" class="form-label">Select Category <span

                                                style="color: red;">*</span></label>

                                        <select class="form-select" name="category_id" id="category_id"

                                            aria-label="Category Select">

                                            <option value="">Select</option>

                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($category->category_type == 1): ?>

                                                    <!-- Only show main categories -->

                                                    <option value="<?php echo e($category->id); ?>"

                                                        <?php echo e($category->id == $product->category_id ? 'selected' : ''); ?>>

                                                        <?php echo e($category->category_name); ?>


                                                    </option>

                                                <?php endif; ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>

                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                                            <small class="text-danger"><?php echo e($message); ?></small>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                </div>

                                <!-- Subcategory Select -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="subcategory_select" class="form-label">Select Sub Category <span

                                                style="color: red;">*</span></label>

                                        <select id="subcategory_select" name="subcategory_id" class="form-select"

                                            aria-label="Sub Category Select">

                                            <option value="">Select</option>

                                            <!-- Options will be loaded dynamically -->

                                        </select>

                                        <?php $__errorArgs = ['subcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                                            <small class="text-danger"><?php echo e($message); ?></small>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                </div>

                                <!-- Brand -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="brand" class="form-label">Agency<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="brand" class="form-control" id="brand"

                                            placeholder="Enter Brand Name"

                                            value="<?php echo e(old('brand', $product->brand ?? '')); ?>">

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="item_code" class="form-label">Item Code <span

                                                style="color: red;">*</span></label>

                                        <div class="input-group">

                                            <input type="text" name="item_code" class="form-control" id="item_code"

                                                placeholder="Auto-generated or enter manually"

                                                value="<?php echo e(old('item_code', $product->item_code ?? '')); ?>">

                                            <button class="btn btn-outline-secondary" type="button"

                                                id="copyItemCodeBtn">

                                                <i class="bi bi-clipboard"></i> Copy

                                            </button>

                                        </div>

                                        <?php $__errorArgs = ['item_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                                            <small class="text-danger"><?php echo e($message); ?></small>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                </div>

                                <!-- Product Title -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="title" class="form-label">Product Title<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="title" class="form-control" id="title"

                                            placeholder="Enter Product Title"

                                            value="<?php echo e(old('title', $product->title ?? '')); ?>">

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="hsn_code" class="form-label">HSN Code <span

                                                style="color: red;">*</span></label>

                                        <div class="input-group">

                                            <input type="text" name="hsn_code" id="hsn_code" class="form-control"

                                                value="<?php echo e(old('hsn_code', $product->hsn_code ?? '')); ?>"

                                                placeholder="e.g., 1001">

                                            <button class="btn btn-outline-secondary" type="button" id="copyHsnCodeBtn">

                                                <i class="bi bi-clipboard"></i> Copy

                                            </button>

                                        </div>

                                        <div id="copyHsnSuccessMsg" class="text-success mt-1" style="display: none;">

                                            Copied!</div>

                                        <?php $__errorArgs = ['hsn_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                                            <small class="text-danger"><?php echo e($message); ?></small>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                </div>

                                <!-- Youtube Video URL -->

 <div class="col-lg-3">

        <div class="form-group mb-3">

            <label for="barcode1" class="form-label">

                Barcode 1 <span style="color: red;">*</span>

            </label>

            <div class="input-group">

                <input type="text" name="barcode1" id="barcode1" class="form-control"

                   value="<?php echo e(old('barcode1', $product->barcode1 ?? '')); ?>" placeholder="e.g., BRC1001">

                <button class="btn btn-outline-secondary" type="button" id="copyBarcode1Btn">

                    <i class="bi bi-clipboard"></i> Copy

                </button>

            </div>

            <div id="copyBarcode1SuccessMsg" class="text-success mt-1" style="display: none;">

                Copied!

            </div>

            <?php $__errorArgs = ['barcode1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                <small class="text-danger"><?php echo e($message); ?></small>

            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        </div>

    </div>

    <!-- Barcode 2 -->

    <div class="col-lg-3">

        <div class="form-group mb-3">

            <label for="barcode2" class="form-label">

                Barcode 2 <span style="color: red;">*</span>

            </label>

            <div class="input-group">

                <input type="text" name="barcode2" id="barcode2" class="form-control"

                   value="<?php echo e(old('barcode2', $product->barcode2 ?? '')); ?>"  placeholder="e.g., BRC1002">

                <button class="btn btn-outline-secondary" type="button" id="copyBarcode2Btn">

                    <i class="bi bi-clipboard"></i> Copy

                </button>

            </div>

            <div id="copyBarcode2SuccessMsg" class="text-success mt-1" style="display: none;">

                Copied!

            </div>

            <?php $__errorArgs = ['barcode2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                <small class="text-danger"><?php echo e($message); ?></small>

            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        </div>

    </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-2">

                                        <label for="youtube_url" class="form-label">YouTube video URL</label>

                                        <textarea name="youtube_url" class="form-control" rows="1" placeholder="YouTube URL"><?php echo e(old('youtube_url', $product->youtube_url)); ?></textarea>

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="branch_id" class="form-label">

                                            Select Branch <span style="color: red;">*</span>

                                        </label>

                                        <select name="branch_id" id="branch_id" class="form-control" required>

                                            <option value="">-- Select Branch --</option>

                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <option value="<?php echo e($branch->id); ?>"

                                                    <?php echo e(old('branch_id', $product->branch_id) == $branch->id ? 'selected' : ''); ?>>

                                                    <?php echo e($branch->branch_name); ?>


                                                </option>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>

                                    </div>

                                </div>

                                <div class="col-lg-12">

                                    <div class="form-group mb-3">

                                        <label for="description" class="form-label">Product Description<span
                                                style="color: red;">*</span></label>

                                        <textarea name="description" class="form-control" id="editor1" rows="3"

                                            placeholder="Write the product description here"><?php echo e(old('description', $product->description)); ?></textarea>

                                    </div>

                                </div>

                                <!-- Unit -->

                               <div class="col-lg-3">

    <div class="form-group mb-3">

        <label for="unit" class="form-label">Unit</label>

        <select name="unit" id="unit" class="form-control">

            <option value="">Select Unit</option>

            <?php

                $units = [

                    'kg' => 'Kilogram (kg)',

                    'gram' => 'Gram (g)',

                    'pcs' => 'pcs',

                    'box' => 'Box',

                    'set' => 'Set',

                ];

                $selectedUnit = old('unit', $product->unit ?? '');

            ?>

            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <option value="<?php echo e($value); ?>" <?php echo e($selectedUnit == $value ? 'selected' : ''); ?>>

                    <?php echo e($label); ?>


                </option>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </select>

    </div>

</div>

                      

                                <!-- Stock -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="stock" class="form-label">Stock<span

                                                style="color: red;">*</span></label>

                                        <input type="number" name="stock" id="stock" class="form-control"

                                            placeholder="Enter stock" value="<?php echo e(old('stock', $product->stock ?? '')); ?>">

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="purchase_price" class="form-label">Purchase Price<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="purchase_price" id="purchase_price"

                                            class="form-control" placeholder="Enter purchase Price (₹)"

                                            value="<?php echo e(old('purchase_price', $product->purchase_price ?? '')); ?>">

                                    </div>

                                </div>

                                <!-- MRP & Selling Price -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="mrp" class="form-label">MRP<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="mrp" id="mrp" class="form-control"

                                            placeholder="Enter Maximum Retail Price (₹)"

                                            value="<?php echo e(old('mrp', $product->mrp ?? '')); ?>">

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="sell_price" class="form-label">Sales Price<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="sell_price" id="sell_price" class="form-control"

                                            placeholder="Enter Selling Price (₹)"

                                            value="<?php echo e(old('sell_price', $product->sell_price ?? '')); ?>">

                                    </div>

                                </div>

                                <!-- GST Tax -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="gst" class="form-label">GST Tax (%)<span

                                                style="color: red;">*</span></label>

                                        <select class="form-select form-select-sm" name="gst" id="gst">

                                            <option value="none"

                                                <?php echo e(old('gst', $product->gst ?? '') == 'none' ? 'selected' : ''); ?>>None

                                            </option>

                                            <option value="5"

                                                <?php echo e(old('gst', $product->gst ?? '') == '5' ? 'selected' : ''); ?>>5%

                                            </option>

                                            <option value="12"

                                                <?php echo e(old('gst', $product->gst ?? '') == '12' ? 'selected' : ''); ?>>12%

                                            </option>

                                            <option value="18"

                                                <?php echo e(old('gst', $product->gst ?? '') == '18' ? 'selected' : ''); ?>>18%

                                            </option>

                                        </select>

                                    </div>

                                </div>

                                <!-- Discount -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="discount" class="form-label">Discount (%)<span

                                                style="color: red;">*</span></label>

                                        <input type="number" name="discount" id="discount" class="form-control"

                                            placeholder="Enter Discount Percentage"

                                            value="<?php echo e(old('discount', $product->discount ?? '')); ?>" readonly>

                                    </div>

                                </div>

                                <div class="col-lg-12">

                                    <h5 class="mt-3">Specialization</h5>

                                </div>

                                <!-- Shopping Cash Wallet -->

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="shop_wallet" class="form-label">Shopping Cash Wallet

                                            (₹)<span style="color: red;">*</span></label>

                                        <input type="number" name="shop_wallet" id="shop_wallet" class="form-control"

                                            placeholder="Enter shop_wallet"

                                            value="<?php echo e(old('shop_wallet', $product->shop_wallet ?? '')); ?>">

                                    </div>

                                </div>

                                <div class="col-lg-3">

                                    <div class="form-group mb-3">

                                        <label for="payable_amount" class="form-label">payable amount<span

                                                style="color: red;">*</span></label>

                                        <input type="text" name="payable_amount" id="payable_amount"

                                            class="form-control" placeholder="payable_amount (₹)"

                                            value="<?php echo e(old('payable_amount', $product->payable_amount ?? 0)); ?>" readonly>

                                    </div>

                                </div>

                                <div class="variant-row-container mt-3">

                                    <?php $__currentLoopData = $product->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <input type="hidden" name="variant_id" id="variant_id"

                                            value="<?php echo e($variant->variant_id); ?>">

                                        <div class="row variant-row" id="variant-row-<?php echo e($variant->id); ?>"

                                            data-variant-id="<?php echo e($variant->id); ?>">

                                            <div class="col-lg-12">

                                                <p class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i>

                                                    Variant <?php echo e($index + 1); ?></p>

                                            </div>

                                            <div class="col-lg-3">

                                                <div class="form-group mb-3">

                                                    <label for="varient_name_<?php echo e($index); ?>"

                                                        class="form-label">Variant Name</label>

                                                    <input type="text" name="variants[<?php echo e($index); ?>][name]"

                                                        class="form-control" id="varient_name_<?php echo e($index); ?>"

                                                        placeholder="Enter SKU"

                                                        value="<?php echo e(old('variants.' . $index . '.varient_name', $variant->variant_name)); ?>">

                                                </div>

                                            </div>

                                            <div class="col-lg-6" style="display: none">

                                                <div class="form-group mb-3">

                                                    <label for="mrp_<?php echo e($index); ?>" class="form-label">mrp</label>

                                                    <input type="number" name="variants[<?php echo e($index); ?>][mrp]"

                                                        class="mrp form-control" id="mrp_<?php echo e($index); ?>"

                                                        placeholder="Enter mrp"

                                                        value="<?php echo e(old('variants.' . $index . '.mrp', $variant->mrp)); ?>">

                                                </div>

                                            </div>

                                            <div class="col-lg-3">

                                                <div class="form-group mb-3">

                                                    <label for="price_<?php echo e($index); ?>" class="form-label">Selling

                                                        Price</label>

                                                    <input type="number" name="variants[<?php echo e($index); ?>][price]"

                                                        class="price form-control" id="price_<?php echo e($index); ?>"

                                                        placeholder="Enter Price"

                                                        value="<?php echo e(old('variants.' . $index . '.price', $variant->sell_price)); ?>">

                                                </div>

                                            </div>

                                            <div class="col-lg-6" style="display: none">

                                                <div class="form-group mb-3">

                                                    <label for="discount_<?php echo e($index); ?>" class="form-label">Selling

                                                        discount</label>

                                                    <input type="number" name="variants[<?php echo e($index); ?>][discount]"

                                                        class="discount form-control" id="discount_<?php echo e($index); ?>"

                                                        placeholder="Enter discount"

                                                        value="<?php echo e(old('variants.' . $index . '.discount', $variant->discount)); ?>">

                                                </div>

                                            </div>

                                            <div class="col-lg-12 mb-3">

                                                <div class="button-container mt-4">

                                                    <button type="button" class="btn btn-danger remove-oldvariant-btn"

                                                        data-variant-id="<?php echo e($variant->id); ?>">

                                                        Remove Variant

                                                    </button>

                                                </div>

                                            </div>

                                        </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>

                                <input type="hidden" name="deleted_variants" id="deleted_variants" value="">

                                <div id="variant-section" class="col-lg-12">

                                </div>

                                <div class="col-lg-12 mb-3">

                                    <div class="button-container mt-4">

                                        <button type="button" class="btn btn-primary" id="add-variant-btn">Add

                                            Variant</button>

                                    </div>

                                </div>

                                <div class="button-container mt-5">

                                    <button type="submit" class="btn btn-primary submit-btn py-3" id="update-btn"><i

                                            class="fa-solid fa-rotate me-2" id="update-icon"></i>Update Product</button>

                                </div>

                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <!-- Confirmation Modal -->

    <div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteModalLabel"

        aria-hidden="true">

        <div class="modal-dialog modal-dialog-centered">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="confirmDeleteModalLabel">Confirm Deletion</h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                </div>

                <div class="modal-body text-center">

                    Are you sure you want to remove this variant?

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>

                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Yes, Remove</button>

                </div>

            </div>

        </div>

    </div>

    <!-- Barcode Modal -->

    <div class="modal fade" id="barcodeModal" tabindex="-1" aria-labelledby="barcodeModalLabel" aria-hidden="true">

        <div class="modal-dialog modal-dialog-centered">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="barcodeModalLabel">Product Barcode</h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                </div>

                <div class="modal-body text-center">

                    <h5 class="modal-title mb-2" id="modalRole"></h5>

                    <!-- Barcode Preview -->

                    <svg id="barcodeModalSvg"></svg>

                    <hr>

                    <p><strong>Item Code:</strong> <span id="modalItemCode"></span></p>

                    <p><strong>Title:</strong> <span id="modalTitle"></span></p>

                    <p><strong>SP:</strong> ₹<span id="modalSellPrice"></span></p>

                </div>

                <div class="modal-footer">

                    <button type="button" id="downloadBarcodeBtnModal" class="btn btn-sm btn-success">

                        <i class="bi bi-download"></i> Download Barcode

                    </button>

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>

            </div>

        </div>

    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Required JS Libraries -->

    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

    <script>

        const userRole = <?php echo json_encode(Auth::user()->role ?? 'admin', 15, 512) ?>;

        const companyName = <?php echo json_encode(Auth::user()->role ?? 'admin', 15, 512) ?>;

        document.getElementById('generateBarcodeBtn').addEventListener('click', function() {

            const itemCode = document.getElementById('item_code')?.value || '0000';

            const title = this.getAttribute('data-title') || '(No Title)';

            const sellPrice = document.getElementById('sell_price')?.value || '0.00';

            if (!itemCode) {

                alert('Item code is missing.');

                return;

            }

            const barcodeText = `${itemCode}`;

            // Render SVG for preview

            JsBarcode("#barcodeModalSvg", barcodeText, {

                format: "CODE128",

                lineColor: "#000",

                width: 2,

                height: 50,

                displayValue: true

            });

            document.getElementById('modalRole').innerText = userRole;

            document.getElementById('modalItemCode').innerText = itemCode;

            document.getElementById('modalTitle').innerText = title;

            document.getElementById('modalSellPrice').innerText = sellPrice;

            const modal = new bootstrap.Modal(document.getElementById('barcodeModal'));

            modal.show();

        });

        document.getElementById('downloadBarcodeBtnModal').addEventListener('click', function() {

            const {

                jsPDF

            } = window.jspdf;

            const pdf = new jsPDF('l', 'mm', [104, 27]);

            const itemCode = document.getElementById('modalItemCode').innerText;

            const title = document.getElementById('modalTitle').innerText;

            const sellPrice = document.getElementById('modalSellPrice').innerText;

            const labelWidth = 48;

            const labelHeight = 25;

            const spacing = 4;

            const startX = 2;

            const startY = 1;

            const scale = 4;

            const barcodeCanvas = document.createElement('canvas');

            barcodeCanvas.width = 300 * scale;

            barcodeCanvas.height = 60 * scale;

            const barcodeCtx = barcodeCanvas.getContext('2d');

            barcodeCtx.scale(scale, scale);

            JsBarcode(barcodeCanvas, itemCode, {

                format: "CODE128",

                lineColor: "#000",

                width: 2,

                height: 50,

                displayValue: false,

                margin: 0

            });

            const barcodeImgData = barcodeCanvas.toDataURL("image/png");

            const drawLabel = (x, y) => {

                pdf.setDrawColor(0);

                pdf.setFillColor(255, 255, 255);

                pdf.rect(x, y, labelWidth, labelHeight, 'F');

                let cursorY = y + 4;

                const centerX = x + labelWidth / 2;

                // Company Name

                pdf.setFontSize(6.5);

                pdf.text(companyName.slice(0, 25), centerX, cursorY, {

                    align: 'center'

                });

                // Barcode

                const barcodeDisplayWidth = 30;

                const barcodeDisplayHeight = 10;

                const barcodeY = cursorY + 1;

                pdf.addImage(barcodeImgData, 'PNG', centerX - barcodeDisplayWidth / 2, barcodeY,

                    barcodeDisplayWidth, barcodeDisplayHeight);

                // Item Code

                cursorY = barcodeY + barcodeDisplayHeight + 2;

                pdf.setFontSize(6);

                pdf.text(itemCode, centerX, cursorY, {

                    align: 'center'

                });

                // Title

                cursorY += 4;

                pdf.text(title.slice(0, 25), centerX, cursorY, {

                    align: 'center'

                });

                // Price

                cursorY += 4;

                pdf.text(`SP: ₹${sellPrice}`, centerX, cursorY, {

                    align: 'center'

                });

            };

            drawLabel(startX, startY);

            drawLabel(startX + labelWidth + spacing, startY);

            pdf.save(`barcode_${itemCode}.pdf`);

        });

    </script>

    <script>

        document.addEventListener('DOMContentLoaded', function() {

            const itemCodeField = document.getElementById('item_code');

            const copyItemCodeBtn = document.getElementById('copyItemCodeBtn');

            if (copyItemCodeBtn && itemCodeField) {

                copyItemCodeBtn.addEventListener('click', function() {

                    itemCodeField.select();

                    itemCodeField.setSelectionRange(0, 99999); // For mobile devices

                    try {

                        document.execCommand('copy');

                        const originalText = copyItemCodeBtn.innerHTML;

                        copyItemCodeBtn.innerHTML = '<i class="bi bi-check"></i> Copied!';

                        setTimeout(() => {

                            copyItemCodeBtn.innerHTML = originalText;

                        }, 2000);

                    } catch (err) {

                        console.error('Failed to copy text: ', err);

                        alert('Failed to copy. Please copy manually.');

                    }

                });

            }

        });

    </script>

<script>

    document.addEventListener('DOMContentLoaded', function() {

        function setupCopyButton(inputId, buttonId, successMsgId) {

            const inputField = document.getElementById(inputId);

            const button = document.getElementById(buttonId);

            const successMsg = document.getElementById(successMsgId);

            if (button && inputField) {

                button.addEventListener('click', async function() {

                    try {

                        await navigator.clipboard.writeText(inputField.value);

                        // Show temporary success message

                        successMsg.style.display = 'block';

                        // Change button text/icon temporarily

                        const originalHTML = button.innerHTML;

                        button.innerHTML = '<i class="bi bi-check"></i> Copied!';

                        setTimeout(() => {

                            button.innerHTML = originalHTML;

                            successMsg.style.display = 'none';

                        }, 2000);

                    } catch (err) {

                        console.error('Failed to copy: ', err);

                        alert('Failed to copy. Please copy manually.');

                    }

                });

            }

        }

        // Initialize both copy buttons

        setupCopyButton('barcode1', 'copyBarcode1Btn', 'copyBarcode1SuccessMsg');

        setupCopyButton('barcode2', 'copyBarcode2Btn', 'copyBarcode2SuccessMsg');

    });

</script>

    <script>

        document.addEventListener('DOMContentLoaded', function() {

            const MAX_IMAGES = 10;

            const updateUploadOption = () => {

                const imageCount = document.querySelectorAll('.image-wrapper').length;

                const uploadLabel = document.querySelector('.drag-drop-label');

                const fileInput = document.getElementById('fileInput');

                if (imageCount >= MAX_IMAGES) {

                    uploadLabel.classList.add('d-none');

                    fileInput.classList.add('d-none');

                } else {

                    uploadLabel.classList.remove('d-none');

                    fileInput.classList.remove('d-none');

                }

            };

            document.querySelectorAll('.remove-image-btn').forEach(button => {

                button.addEventListener('click', function() {

                    const imageName = this.dataset.image;

                    const wrapper = this.closest('.image-wrapper');

                    if (confirm('Are you sure you want to delete this image?')) {

                        fetch("<?php echo e(route('product_removeImage')); ?>", {

                                method: 'POST',

                                headers: {

                                    'X-CSRF-TOKEN': document.querySelector(

                                        'meta[name="csrf-token"]').getAttribute('content'),

                                    'Content-Type': 'application/json'

                                },

                                body: JSON.stringify({

                                    image: imageName,

                                    product_id: '<?php echo e($product->id); ?>'

                                })

                            })

                            .then(response => response.json())

                            .then(data => {

                                if (data.success) {

                                    wrapper.remove();

                                    updateUploadOption();

                                } else {

                                    alert('Error deleting image.');

                                }

                            })

                            .catch(error => {

                                console.error('Error:', error);

                                alert('Something went wrong while deleting the image.');

                            });

                    }

                });

            });

            updateUploadOption(); // Initial check

        });

    </script>

    <!-- jQuery Script -->

    <script>

        $(document).ready(function() {

            $.ajaxSetup({

                headers: {

                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                }

            });

            const selectedCategoryId = $('#category_id').val();

            const selectedSubcategoryId = '<?php echo e($product->subcategory_id); ?>';

            // Load subcategories on page load if category is selected

            if (selectedCategoryId) {

                loadSubcategories(selectedCategoryId, selectedSubcategoryId);

            }

            // Load subcategories when category changes

            $('#category_id').on('change', function() {

                const categoryId = $(this).val();

                $('#subcategory_select').html('<option value="">Select</option>');

                if (categoryId) {

                    loadSubcategories(categoryId);

                }

            });

            function loadSubcategories(categoryId, selectedSubcategoryId = null) {

                $.ajax({

                    url: '<?php echo e(route('getSubcategories')); ?>',

                    type: 'GET',

                    data: {

                        categoryId: categoryId

                    },

                    dataType: 'json',

                    success: function(data) {

                        $('#subcategory_select').html('<option value="">Select</option>');

                        $.each(data.subcategories, function(index, subcategory) {

                            const option = $('<option></option>')

                                .val(subcategory.id)

                                .text(subcategory.subcategory_name);

                            if (subcategory.id == selectedSubcategoryId) {

                                option.attr('selected', 'selected');

                            }

                            $('#subcategory_select').append(option);

                        });

                    },

                    error: function(xhr, status, error) {

                        console.error('Error fetching subcategories:', error);

                        console.error('Response:', xhr.responseText);

                    }

                });

            }

        });

    </script>

    <script>

        document.addEventListener('DOMContentLoaded', function() {

            const hsnCodeField = document.getElementById('hsn_code');

            const copyHsnCodeBtn = document.getElementById('copyHsnCodeBtn');

            const successMsg = document.getElementById('copyHsnSuccessMsg');

            if (copyHsnCodeBtn && hsnCodeField) {

                copyHsnCodeBtn.addEventListener('click', async function() {

                    try {

                        await navigator.clipboard.writeText(hsnCodeField.value);

                        // Show temporary success message

                        successMsg.style.display = 'block';

                        // Change button text/icon temporarily

                        const originalHTML = copyHsnCodeBtn.innerHTML;

                        copyHsnCodeBtn.innerHTML = '<i class="bi bi-check"></i> Copied!';

                        setTimeout(() => {

                            copyHsnCodeBtn.innerHTML = originalHTML;

                            successMsg.style.display = 'none';

                        }, 2000);

                    } catch (err) {

                        console.error('Failed to copy: ', err);

                        alert('Failed to copy. Please copy manually.');

                    }

                });

            }

        });

    </script>

    <script>

        $(document).ready(function() {

            let deletedVariantIds = [];

            $('.remove-oldvariant-btn').click(function() {

                var variantId = $(this).data('variant-id');

                $('#confirmDeleteBtn').data('variant-id', variantId);

                $('#confirmDeleteModal').modal('show');

            });

            $('#confirmDeleteBtn').click(function() {

                var variantId = $(this).data('variant-id');

                $.ajax({

                    url: '<?php echo e(route('variants_destroy', '')); ?>/' + variantId,

                    method: 'GET',

                    success: function(response) {

                        if (response.success) {

                            $('#confirmDeleteModal').modal('hide');

                            $('#variant-row-' + variantId).remove();

                            reindexVariants();

                            deletedVariantIds.push(variantId);

                            $('#deleted_variants').val(deletedVariantIds.join(','));

                        } else {

                            alert(response.message);

                        }

                    },

                    error: function(error) {

                        alert('An error occurred. Please try again.');

                    }

                });

            });

            // Add New Variant

            let variantIndex = $('.variant-row').length;

            $('#add-variant-btn').on('click', function() {

                const newVariantIndex = $('.variant-row').length;

                const mrpValue = $('#mrp').val() || ''; // Get the main MRP value

                const discountValue = $('#discount').val() || ''; // Get the main Discount value

                const variantHtml = `

                    <div class="row variant-row">

                        <div class="col-lg-12">

                            <p class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i> Variant ${newVariantIndex + 1}</p>

                        </div>

                        <!-- Variant Name -->

                        <div class="col-lg-6">

                            <div class="form-group mb-3">

                                <label for="varient_name_${newVariantIndex}" class="form-label">Varient Name</label>

                                <input type="text" name="variants[${newVariantIndex}][name]" class="form-control" id="varient_name_${newVariantIndex}" placeholder="Varient Name">

                            </div>

                        </div>

    

                        <!-- MRP (Readonly, gets main MRP) -->

                        <div class="col-lg-6" style="display:none;">

                            <div class="form-group mb-3">

                                <label class="form-label">MRP</label>

                                <input type="number" name="variants[${newVariantIndex}][mrp]" 

                                class="form-control variant-mrp" 

                                id="variant_mrp_${newVariantIndex}" 

                                data-index="${newVariantIndex}" 

                                value="${mrpValue}" readonly>

                            </div>

                        </div>

    

                        <!-- Selling Price -->

                        <div class="col-lg-6">

                            <div class="form-group mb-3">

                                <label for="selling_price_${newVariantIndex}" class="form-label">Selling Price</label>

                                <input type="number" name="variants[${newVariantIndex}][price]" 

                                class="form-control variant-price" 

                                id="selling_price_${newVariantIndex}" 

                                placeholder="Enter selling price">

                            </div>

                        </div>

    

                        <!-- Discount (Readonly, calculated dynamically) -->

                        <div class="col-lg-6" style="display:none;">

                            <div class="form-group mb-3">

                                <label class="form-label">Discount (%)</label>

                                <input type="number" name="variants[${newVariantIndex}][discount]" 

                                class="form-control variant-discount" 

                                id="variant_discount_${newVariantIndex}" 

                                data-index="${newVariantIndex}" 

                                value="${discountValue}" readonly>

                            </div>

                        </div>

    

                        <!-- Remove Variant Button -->

                        <div class="col-lg-12 mb-3">

                            <div class="button-container mt-4">

                                <button type="button" class="btn btn-danger remove-variant-btn">Remove Variant</button>

                            </div>

                        </div>

                    </div>

                `;

                $('#variant-section').append(variantHtml);

            });

            // Remove Variant from dynamically added rows

            $('#variant-section').on('click', '.remove-variant-btn', function() {

                $(this).closest('.variant-row').remove();

                reindexVariants();

            });

            // Reindex the variant fields

            function reindexVariants() {

                $('.variant-row').each(function(index, element) {

                    $(element).find('.variant-heading').html(

                        `<i class="fa-solid fa-arrow-down me-1"></i> Variant ${index + 1}`

                    );

                    $(element).find('input').each(function() {

                        const nameAttr = $(this).attr('name');

                        const idAttr = $(this).attr('id');

                        if (nameAttr) {

                            const updatedName = nameAttr.replace(/\[\d+\]/, `[${index}]`);

                            $(this).attr('name', updatedName);

                        }

                        if (idAttr) {

                            const updatedId = idAttr.replace(/_\d+/, `_${index}`);

                            $(this).attr('id', updatedId);

                        }

                    });

                    $(element).find('label').each(function() {

                        const forAttr = $(this).attr('for');

                        if (forAttr) {

                            const updatedFor = forAttr.replace(/_\d+/, `_${index}`);

                            $(this).attr('for', updatedFor);

                        }

                    });

                });

            }

            // Update Discount for All Variants

            function calculateDiscount(index) {

                let mrp = parseFloat($('#variant_mrp_' + index).val());

                let sellingPrice = parseFloat($('#selling_price_' + index).val());

                let discountField = $('#variant_discount_' + index);

                if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp > sellingPrice && mrp > 0) {

                    let discount = ((mrp - sellingPrice) / mrp) * 100;

                    discountField.val(discount.toFixed(2));

                } else {

                    discountField.val('');

                }

            }

            // Event listener for all variant price changes

            $('#variant-section').on('input', '.variant-price', function() {

                let index = $(this).attr('id').split('_').pop();

                calculateDiscount(index);

            });

            // Main MRP and Selling Price Calculation

            $('#mrp, #sell_price').on('input', function() {

                let mrp = parseFloat($('#mrp').val());

                let sellingPrice = parseFloat($('#sell_price').val());

                let discountField = $('#discount');

                if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp > sellingPrice && mrp > 0) {

                    let discount = ((mrp - sellingPrice) / mrp) * 100;

                    discountField.val(discount.toFixed(2));

                    // Update all variants' MRP and Discount dynamically

                    $('.variant-mrp').val(mrp);

                    $('.variant-price').each(function() {

                        let index = $(this).attr('id').split('_').pop();

                        calculateDiscount(index);

                    });

                } else {

                    discountField.val('');

                }

            });

        });

    </script>

    <script>

        document.addEventListener("DOMContentLoaded", function() {

            let sellPriceInput = document.getElementById("sell_price");

            let shopWalletInput = document.getElementById("shop_wallet");

            let payableAmountInput = document.getElementById("payable_amount");

            function calculatePayableAmount() {

                let sellPrice = parseFloat(sellPriceInput.value) || 0;

                let shopWallet = parseFloat(shopWalletInput.value) || 0;

                let payableAmount = sellPrice - shopWallet;

                if (payableAmount < 0) {

                    payableAmount = 0; // Prevent negative values

                }

                payableAmountInput.value = payableAmount.toFixed(2); // Format to 2 decimal places

            }

            // Call function on page load (for edit case)

            calculatePayableAmount();

            // Attach event listeners to input fields

            sellPriceInput.addEventListener("input", calculatePayableAmount);

            shopWalletInput.addEventListener("input", calculatePayableAmount);

        });

    </script>

    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>

    <script>

        ClassicEditor

            .create(document.querySelector('#editor1'))

            .catch(error => console.error(error));

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/view_product.blade.php ENDPATH**/ ?>