
<?php $__env->startSection('title', 'Add Category'); ?>
<?php $__env->startSection('header'); ?>
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Edit User</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Edit User</h5>
                    </div>
                    <div class="card-body">
                       

                        <form action="<?php echo e(route('edit_update', $user->id)); ?>" method="POST" autocomplete="off">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Name</label>
                                    <input type="text" class="form-control" name="name" value="<?php echo e(old('name', $user->name)); ?>" >
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" value="<?php echo e(old('email', $user->email)); ?>" >
                                </div>
                                 <div class="col-lg-6 mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="text" class="form-control" name="password"  value="<?php echo e(old('password', $user->password)); ?>" >
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Phone Number</label>
                                    <input type="text" class="form-control" name="phone" value="<?php echo e(old('phone_number', $user->phone_number)); ?>" >
                                </div>
                             
                                <div class="col-lg-6 mb-3">
    <label class="form-label">Payment Mode</label>
    <input type="text" class="form-control" name="payment_mode" placeholder="Enter Payment Mode"
        value="<?php echo e(old('payment_mode')); ?>">
</div>

                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Membership</label>
                                    <input type="text" class="form-control" id="plan_amount" value="<?php echo e(old('membership', $user->membership)); ?>" readonly>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label class="form-label">Plan Name</label>
                                    <input type="text" class="form-control" name="plan_name" id="plan_name"
                                        value="<?php echo e(old('plan_name', $membershipTitle)); ?>" readonly>
                                    
                                </div>
                              
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label class="form-label">Joining Date</label>
                                        <input type="text" class="form-control" name="joining_date"
                                            value="<?php echo e(old('created_at', $user->created_at)); ?>" readonly>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label class="form-label">Membership Plan (Optional)</label>
                                        <select class="form-control" name="membership_id">
                                            <option value="">Select Membership</option>
                                            <?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membership): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($membership->id); ?>" 
                                                    <?php echo e(old('membership_id', $user->membership) == $membership->id ? 'selected' : ''); ?>>
                                                    <?php echo e($membership->title); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 text-center">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                                           </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->
    </div>
    <!-- end container fluid -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('footer'); ?>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let selectedMembership = "<?php echo e(old('membership_id', $user->membership_id)); ?>";

            if (selectedMembership) {
                let membershipSelect = document.querySelector('select[name="membership_id"]');
                let options = membershipSelect.options;

                for (let i = 0; i < options.length; i++) {
                    if (options[i].value === selectedMembership) {
                        options[i].selected = true;
                        break;
                    }
                }
            }
        });
    </script>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/edit_user.blade.php ENDPATH**/ ?>