
<?php $__env->startSection('title', 'Add Product'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.css" integrity="sha512-..."
    crossorigin="anonymous" />
<style>
    /* Wrapper alignment */
    .cgst-sgst-checkbox {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    /* Custom styled checkbox */
    .custom-cgst-sgst {
        width: 20px;
        height: 20px;
        appearance: none;
        -webkit-appearance: none;
        background-color: #fff;
        border: 2px solid #0d6efd;
        border-radius: 4px;
        cursor: pointer;
        position: relative;
        transition: all 0.2s ease-in-out;
    }
    .custom-cgst-sgst:checked {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }
    .custom-cgst-sgst:checked::after {
        content: "";
        position: absolute;
        left: 5px;
        top: 1px;
        width: 5px;
        height: 10px;
        border: solid white;
        border-width: 0 2px 2px 0;
        transform: rotate(45deg);
    }
    /* Custom label styling */
    .custom-cgst-sgst-label {
        font-weight: 600;
        color: #333;
        cursor: pointer;
        margin: 0;
        user-select: none;
    }
</style>
<style>
    input#images[type="file"]::file-selector-button,
    input#video[type="file"]::file-selector-button {
        border: 2px solid #022859;
        padding: 10px;
        border-radius: 0.2em;
        background-color: #022859;
        transition: 1s;
        color: #fff;
        cursor: pointer;
    }
    input#images[type="file"]::file-selector-button:hover,
    input#video[type="file"]::file-selector-button:hover {
        background-color: #022859 !important;
        border: 2px solid #022859 !important;
    }
    .form-select {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        background-image: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='black' class='bi bi-chevron-down' viewBox='0 0 16 16'><path fill-rule='evenodd' d='M1.646 5.646a.5.5 0 0 1 .708 0L8 11.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/></svg>");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 16px;
        background: #022859
    }
    .variant-heading {
        margin-bottom: 9px !important;
        width: fit-content;
        padding: 7px 20px;
        background-color: #FBBB00 !important;
        color: #020A13;
        font-weight: 600;
        font-size: 14px;
        border-radius: 5px !important;
    }
    .drag-drop-area {
        border: 2px dashed #0077BF;
        border-radius: 15px;
        padding: 40px;
        text-align: center;
        background-color: #f0f8f4;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        position: relative;
    }
    .drag-drop-area.dragging {
        background-color: #e1f7e8;
        border-color: #0077BF;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    }
    /* Preview container for uploaded images */
    .preview-container {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        justify-content: center;
        margin-top: 30px;
    }
    .preview-wrapper {
        position: relative;
        width: 120px;
        height: 120px;
        border-radius: 15px;
        overflow: hidden;
        border: 2px solid #ddd;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }
    .preview-wrapper:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
    }
    .preview-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 15px;
    }
    .remove-image {
        position: absolute;
        top: 5px;
        right: 5px;
        background-color: rgba(255, 0, 0, 0.7);
        color: white;
        border: none;
        padding: 5px 8px;
        font-size: 14px;
        font-weight: bold;
        border-radius: 50%;
        cursor: pointer;
        transition: all 0.2s ease;
    }
    .remove-image:hover {
        background-color: rgba(255, 0, 0, 0.9);
        transform: scale(1.1);
    }
    /* Instructions area */
    #upload-instructions {
        font-size: 18px;
        font-weight: 600;
        color: #0077BF;
        transition: all 0.3s ease;
    }
    #upload-instructions i {
        font-size: 50px;
        margin-bottom: 15px;
        color: #0077BF;
        transition: all 0.3s ease;
    }
    #upload-instructions p {
        margin: 10px 0;
        font-size: 16px;
        color: #333;
    }
    #upload-instructions small {
        font-size: 14px;
        color: #888;
    }
    /* Hover effect on drag-drop area */
    .drag-drop-area:hover {
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        cursor: pointer;
    }
    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .preview-wrapper {
            width: 100px;
            height: 100px;
        }
        #upload-instructions {
            font-size: 16px;
        }
        .remove-image {
            top: 3px;
            right: 3px;
            padding: 4px;
            font-size: 12px;
        }
    }
    @media (max-width: 576px) {
        .drag-drop-area {
            padding: 20px;
        }
        .preview-wrapper {
            width: 80px;
            height: 80px;
        }
        #upload-instructions {
            font-size: 14px;
        }
        .remove-image {
            top: 2px;
            right: 2px;
            font-size: 10px;
            padding: 3px;
        }
        #editor1 {
            height: 250px;
        }
    }
</style>
<?php $__env->startSection('header'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Add Product</h3>
            </div>
        </div>
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-12">
                <div class="card ILY-form-card">
                    <div class="card-body">
                        <form action="<?php echo e(route('store_product')); ?>" method="POST" id="add_product"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="d-flex justify-content-end mb-3 col-lg-12">
                                    <div class="form-check form-switch">
                                        <input type="hidden" name="is_note" value="0">
                                        <input type="checkbox" class="form-check-input m-2" id="noteToggle" name="is_note"
                                            value="1" data-product-id="<?php echo e($nextProductId); ?>"
                                            <?php echo e(old('is_note', '1') == '1' ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="noteToggle">Publish App</label>
                                    </div>
                                    <!-- Barcode Preview (hidden initially) -->
                                    <svg id="barcode" style="display: none;"></svg>
                                    <!-- Smaller Generate Barcode button -->
                                    <button type="button" id="generateBarcodeBtn"
                                        class="btn btn-sm btn-outline-primary ms-2">
                                        <i class="bi bi-upc-scan"></i> Generate Barcode
                                    </button>
                                    <!-- Download button (hidden initially) -->
                                    <button type="button" id="downloadBarcodeBtn" class="btn btn-sm btn-success ms-2"
                                        style="display: none;">
                                        <i class="bi bi-download"></i> Download Barcode
                                    </button>
                                </div>
                                <div class="mb-3 col-lg-12">
                                    <label for="images" class="form-label">Upload Images</label>
                                    <div class="drag-drop-area" id="drop-area">
                                        <i class="bi bi-cloud-upload"></i>
                                        <p>Click or drag images to upload</p>
                                        <small class="text-muted">You can upload up to 10 images.</small>
                                        <input type="file" class="form-control d-none" id="images" name="images[]"
                                            multiple accept="image/*">
                                    </div>
                                    <div id="preview-container" class="preview-container">
                                        <div id="upload-instructions" style="width:100%;">
                                        </div>
                                        
                                        <?php if(session()->has('newtemp_images')): ?>
                                            <?php $__currentLoopData = session('newtemp_images'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="preview-wrapper">
                                                    <img src="<?php echo e(asset($img)); ?>" />
                                                    <button type="button" class="remove-image"
                                                        data-src="<?php echo e($img); ?>">x</button>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php $__errorArgs = ['images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <!-- Category Selection -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="category_id" class="form-label">Select Category <span
                                                style="color: red;">*</span></label>
                                        <select id="category_id" name="category_id" class="form-select"
                                            aria-label="Category Select">
                                            <option value="">Select</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($category->category_type == 1): ?>
                                                    <!-- Only show main categories -->
                                                    <option value="<?php echo e($category->id); ?>"
                                                        <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                                        <?php echo e($category->category_name); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <!-- Sub Category Selection -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="subcategory_select" class="form-label">Select Sub Category <span
                                                style="color: red;">*</span></label>
                                        <select id="subcategory_select" name="subcategory_id" class="form-select">
                                            <option value="<?php echo e(old('subcategory_id')); ?>">Select</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Brand -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="brand" class="form-label">Agency <span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="brand" class="form-control" id="brand"
                                            placeholder="Enter Brand Name" value="<?php echo e(old('brand')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="item_code" class="form-label">Item Code <span
                                                style="color: red;">*</span></label>
                                        <div class="input-group">
                                            <input type="text" name="item_code" id="item_code" class="form-control"
                                                value="<?php echo e(old('item_code', $nextProductId ?? '')); ?>"
                                                placeholder="e.g., 1001" required readonly>
                                            <button class="btn btn-outline-secondary" type="button"
                                                id="copyItemCodeBtn">
                                                <i class="bi bi-clipboard"></i> Copy
                                            </button>
                                        </div>
                                        <?php $__errorArgs = ['item_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <!-- Product Title -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="title" class="form-label">Product Title <span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="title" class="form-control" id="title"
                                            placeholder="Enter Product Title" value="<?php echo e(old('title')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="hsn_code" class="form-label">HSN Code <span
                                                style="color: red;">*</span></label>
                                        <div class="input-group">
                                            <input type="text" name="hsn_code" id="hsn_code" class="form-control"
                                                value="<?php echo e(old('hsn_code')); ?>" placeholder="e.g., 1001">
                                            <button class="btn btn-outline-secondary" type="button" id="copyHsnCodeBtn">
                                                <i class="bi bi-clipboard"></i> Copy
                                            </button>
                                        </div>
                                        <div id="copyHsnSuccessMsg" class="text-success mt-1" style="display: none;">
                                            Copied!</div>
                                        <?php $__errorArgs = ['hsn_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="barcode1" class="form-label">
                                            Barcode 1 <span style="color: red;">*</span>
                                        </label>
                                        <div class="input-group">
                                            <input type="text" name="barcode1" id="barcode1" class="form-control"
                                                value="<?php echo e(old('barcode1')); ?>" placeholder="e.g., BRC1001">
                                            <button class="btn btn-outline-secondary" type="button"
                                                id="copyBarcode1Btn">
                                                <i class="bi bi-clipboard"></i> Copy
                                            </button>
                                        </div>
                                        <div id="copyBarcode1SuccessMsg" class="text-success mt-1"
                                            style="display: none;">
                                            Copied!
                                        </div>
                                        <?php $__errorArgs = ['barcode1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <!-- Barcode 2 -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="barcode2" class="form-label">
                                            Barcode 2 <span style="color: red;">*</span>
                                        </label>
                                        <div class="input-group">
                                            <input type="text" name="barcode2" id="barcode2" class="form-control"
                                                value="<?php echo e(old('barcode2')); ?>" placeholder="e.g., BRC1002">
                                            <button class="btn btn-outline-secondary" type="button"
                                                id="copyBarcode2Btn">
                                                <i class="bi bi-clipboard"></i> Copy
                                            </button>
                                        </div>
                                        <div id="copyBarcode2SuccessMsg" class="text-success mt-1"
                                            style="display: none;">
                                            Copied!
                                        </div>
                                        <?php $__errorArgs = ['barcode2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <!-- vc_url -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-2 lg-6">
                                        <label for="youtube_url" class="form-label">Youtube video URL </label>
                                        <textarea name="youtube_url" class="form-control" rows="1" placeholder="youtube_url"
                                            value="<?php echo e(old('youtube_url')); ?>"></textarea>
                                    </div>
                                </div>
<div class="col-lg-3">
    <div class="form-group mb-3">
        <label for="branch_id" class="form-label">
            Select Branch <span style="color: red;">*</span>
        </label>
        <?php if(auth()->user()->role === 'admin'): ?>
            <select name="branch_id" id="branch_id" class="form-control" required>
                <option value="">-- Select Branch --</option>
                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($branch->id); ?>"
                        <?php echo e(old('branch_id', auth()->user()->branch_id ?? '') == $branch->id ? 'selected' : ''); ?>>
                        <?php echo e($branch->branch_name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php elseif(in_array(auth()->user()->role, ['sakthi', 'smart_world', 'chendur_traders', 'yoga_naturals'])): ?>
            <?php
                $roleToBranchName = [
                    'sakthi' => 'Sakthi Super Mart',
                    'smart_world' => 'SMARTWORLD',
                    'chendur_traders' => 'CHENDUR TRADERS',
                    'yoga_naturals' => 'Yogaa Naturals',
                ];
                $userRole = auth()->user()->role;
                $branchName = $roleToBranchName[$userRole] ?? null;
                $userBranch = $branches->firstWhere('branch_name', $branchName);
            ?>
            <input type="hidden" name="branch_id" value="<?php echo e($userBranch ? $userBranch->id : ''); ?>">
            <input type="text" class="form-control"
                   value="<?php echo e($branchName ?? 'Unknown Branch'); ?>"
                   readonly>
            <?php else: ?>
                <input type="text" class="form-control" value="Unknown Role or Branch" readonly>
        <?php endif; ?>
    </div>
</div>
                                <div class="col-lg-12">
                                    <div class="form-group mb-3">
                                        <label for="description" class="form-label">Product Description<span
                                                style="color: red;">*</span></label>
                                        <textarea name="description" class="form-control" id="editor1" rows="3"
                                            placeholder="Write the product description here"><?php echo e(old('description')); ?></textarea>
                                    </div>
                                </div>
                                
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="unit" class="form-label">Unit</label>
                                        <select name="unit" id="unit" class="form-control">
                                            <option value="">Select Unit</option>
                                            <option value="kg" <?php echo e(old('unit', $product->unit ?? 'pcs') == 'kg' ? 'selected' : ''); ?>>Kilogram (kg)</option>
                                            <option value="gram" <?php echo e(old('unit', $product->unit ?? 'pcs') == 'gram' ? 'selected' : ''); ?>>Gram (g)</option>
                                            <option value="pcs" <?php echo e(old('unit', $product->unit ?? 'pcs') == 'pcs' ? 'selected' : ''); ?>>pcs</option>
                                            <option value="box" <?php echo e(old('unit', $product->unit ?? 'pcs') == 'box' ? 'selected' : ''); ?>>Box</option>
                                            <option value="set" <?php echo e(old('unit', $product->unit ?? 'pcs') == 'set' ? 'selected' : ''); ?>>Set</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="stock" class="form-label">stock<span
                                                style="color: red;">*</span></label>
                                        <input type="number" name="stock" id="stock" class="form-control"
                                            placeholder="Enter stock" value="<?php echo e(old('stock')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="purchase_price" class="form-label">Purchase Price<span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="purchase_price" id="purchase_price"
                                            class="form-control" placeholder="Enter purchase Price (₹)"
                                            value="<?php echo e(old('purchase_price')); ?>">
                                    </div>
                                </div>
                                <!-- MRP & Selling Price -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="mrp" class="form-label">MRP<span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="mrp" id="mrp" class="form-control"
                                            placeholder="Enter Maximum Retail Price (₹)" value="<?php echo e(old('mrp')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="sell_price" class="form-label">Sales Price<span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="sell_price" id="sell_price" class="form-control "
                                            placeholder="Enter Selling Price (₹)" value="<?php echo e(old('sell_price')); ?>">
                                    </div>
                                </div>
                                <!-- Discount & Tax -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="gst" class="form-label">GST Tax (%)<span
                                                style="color: red;">*</span></label>
                                        <select class="form-select form-select-sm" name="gst" id="gst">
                                            <option value="none"
                                                <?php echo e(old('gst', $product->gst ?? 'none') == 'none' ? 'selected' : ''); ?>>None
                                            </option>
                                            <option value="5"
                                                <?php echo e(old('gst', $product->gst ?? '') == '5' ? 'selected' : ''); ?>>5%
                                            </option>
                                            <option value="12"
                                                <?php echo e(old('gst', $product->gst ?? '') == '12' ? 'selected' : ''); ?>>12%
                                            </option>
                                            <option value="18"
                                                <?php echo e(old('gst', $product->gst ?? '') == '18' ? 'selected' : ''); ?>>18%
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="discount" class="form-label">Discount (%)<span
                                                style="color: red;">*</span></label>
                                        <input type="number" name="discount" id="discount" class="form-control"
                                            placeholder="Enter Discount Percentage" readonly
                                            value="<?php echo e(old('discount')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <h5 class="mt-3">Specialization</h5>
                                </div>
                                <!-- Shopping Cash Wallet -->
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="shop_wallet" class="form-label">Shopping Cash Wallet
                                            (₹)<span style="color: red;">*</span></label>
                                        <input type="number" name="shop_wallet" id="shop_wallet" class="form-control"
                                            placeholder="Enter shop_wallet" value="<?php echo e(old('shop_wallet')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label for="payable_amount" class="form-label">payable amount<span
                                                style="color: red;">*</span></label>
                                        <input type="text" name="payable_amount" id="payable_amount"
                                            class="form-control " placeholder="payable_amount (₹)"
                                            value="<?php echo e(old('payable_amount')); ?>">
                                    </div>
                                </div>
                                <!-- Add Variant Button -->
                                <div class="col-lg-12 mb-3">
                                    <button type="button" class="btn btn-secondary p-2" id="add-variant-btn">Add
                                        Variant</button>
                                </div>
                                <!-- Product Variants Section -->
                                <div id="variant-section" class="col-lg-12">
                                    <?php
                                        $oldVariants = old('variants', []);
                                        $variantIndex = 1;
                                    ?>
                                    <?php $__currentLoopData = $oldVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="variant-section mb-4" data-variant-index="<?php echo e($variantIndex); ?>">
                                            <h5 class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i>
                                                Variant <?php echo e($variantIndex); ?></h5>
                                            <div class="row mt-3">
                                                <!-- Variant Name -->
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-3">
                                                        <label class="form-label">Variant Name</label>
                                                        <input type="text" name="variants[<?php echo e($variantIndex); ?>][name]"
                                                            class="form-control variant-name"
                                                            value="<?php echo e($variant['name'] ?? ''); ?>"
                                                            placeholder="Enter variant name">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6" style="display:none;">
                                                    <div class="form-group mb-3">
                                                        <label for="mrp" class="form-label">MRP</label>
                                                        <input type="text" name="variants[<?php echo e($variantIndex); ?>][mrp]"
                                                            id="mrp" class="form-control"
                                                            placeholder="Enter Maximum Retail Price (₹)"
                                                            value="<?php echo e($variant['mrp'] ?? ''); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6" style="display:none;">
                                                    <div class="form-group mb-3">
                                                        <label for="discount" class="form-label">Discount (%)</label>
                                                        <input type="number"
                                                            name="variants[<?php echo e($variantIndex); ?>][discount]" id="discount"
                                                            class="form-control" placeholder="Enter Discount Percentage"
                                                            readonly value="<?php echo e($variant['discount'] ?? ''); ?>">
                                                    </div>
                                                </div>
                                                <!-- Selling Price -->
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-3">
                                                        <label class="form-label">Selling Price</label>
                                                        <input type="number" name="variants[<?php echo e($variantIndex); ?>][price]"
                                                            class="form-control price"
                                                            value="<?php echo e($variant['price'] ?? ''); ?>"
                                                            placeholder="Enter price">
                                                    </div>
                                                </div>
                                                <!-- Delete Variant Button -->
                                                <div class="col-lg-12">
                                                    <button type="button"
                                                        class="btn btn-danger delete-variant-btn">Delete Variant</button>
                                                </div>
                                            </div>
                                        </div>
                                        <?php $variantIndex++; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <!-- Submit Button -->
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-primary px-4 py-3">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery CDN -->
    
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Get the admin role from Laravel securely
        const adminRole = <?php echo json_encode(Auth::user()->role ?? 'admin', 15, 512) ?>;
        // Generate Barcode
        document.getElementById('generateBarcodeBtn').addEventListener('click', function() {
            const itemCode = document.getElementById('item_code').value;
            if (!itemCode) {
                alert('Item code is missing.');
                return;
            }
            const barcodeText = `${adminRole}-${itemCode}`;
            // Render to SVG
            JsBarcode("#barcode", barcodeText, {
                format: "CODE128",
                lineColor: "#000",
                width: 2,
                height: 50,
                displayValue: true
            });
            // Show download button
            document.getElementById('downloadBarcodeBtn').style.display = 'inline-block';
        });
        // Download as PNG
        document.getElementById('downloadBarcodeBtn').addEventListener('click', function() {
            const svg = document.getElementById('barcode');
            const canvas = document.getElementById('barcodeCanvas');
            const svgData = new XMLSerializer().serializeToString(svg);
            const img = new Image();
            const svgBlob = new Blob([svgData], {
                type: "image/svg+xml;charset=utf-8"
            });
            const url = URL.createObjectURL(svgBlob);
            img.onload = function() {
                // Set canvas size same as image
                canvas.width = img.width;
                canvas.height = img.height;
                const ctx = canvas.getContext("2d");
                ctx.fillStyle = "#fff"; // white background
                ctx.fillRect(0, 0, canvas.width, canvas.height);
                ctx.drawImage(img, 0, 0);
                URL.revokeObjectURL(url);
                // Create PNG
                const imgURI = canvas.toDataURL("image/png").replace("image/png", "image/octet-stream");
                const link = document.createElement("a");
                link.href = imgURI;
                link.download = "barcode.png";
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            };
            img.src = url;
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#noteToggle').on('change', function() {
                var productId = $(this).data('product-id');
                var isNote = $(this).is(':checked') ? 1 : 0;
                $.ajax({
                    url: "<?php echo e(route('product.toggleNote')); ?>",
                    method: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        product_id: productId,
                        is_note: isNote
                    },
                    success: function(response) {
                        console.log('Success:', response);
                    },
                    error: function(xhr) {
                        console.log('Error:', xhr.responseText);
                    }
                });
            });
        });
    </script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor1'))
            .catch(error => console.error(error));
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const itemCodeField = document.getElementById('item_code');
            const copyItemCodeBtn = document.getElementById('copyItemCodeBtn');
            if (copyItemCodeBtn && itemCodeField) {
                copyItemCodeBtn.addEventListener('click', function() {
                    itemCodeField.select();
                    itemCodeField.setSelectionRange(0, 99999); // For mobile devices
                    try {
                        document.execCommand('copy');
                        const originalText = copyItemCodeBtn.innerHTML;
                        copyItemCodeBtn.innerHTML = '<i class="bi bi-check"></i> Copied!';
                        setTimeout(() => {
                            copyItemCodeBtn.innerHTML = originalText;
                        }, 2000);
                    } catch (err) {
                        console.error('Failed to copy text: ', err);
                        alert('Failed to copy. Please copy manually.');
                    }
                });
            }
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function setupCopyButton(inputId, buttonId, successMsgId) {
                const inputField = document.getElementById(inputId);
                const button = document.getElementById(buttonId);
                const successMsg = document.getElementById(successMsgId);
                if (button && inputField) {
                    button.addEventListener('click', async function() {
                        try {
                            await navigator.clipboard.writeText(inputField.value);
                            // Show temporary success message
                            successMsg.style.display = 'block';
                            // Change button text/icon temporarily
                            const originalHTML = button.innerHTML;
                            button.innerHTML = '<i class="bi bi-check"></i> Copied!';
                            setTimeout(() => {
                                button.innerHTML = originalHTML;
                                successMsg.style.display = 'none';
                            }, 2000);
                        } catch (err) {
                            console.error('Failed to copy: ', err);
                            alert('Failed to copy. Please copy manually.');
                        }
                    });
                }
            }
            // Initialize both copy buttons
            setupCopyButton('barcode1', 'copyBarcode1Btn', 'copyBarcode1SuccessMsg');
            setupCopyButton('barcode2', 'copyBarcode2Btn', 'copyBarcode2SuccessMsg');
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hsnCodeField = document.getElementById('hsn_code');
            const copyHsnCodeBtn = document.getElementById('copyHsnCodeBtn');
            const successMsg = document.getElementById('copyHsnSuccessMsg');
            if (copyHsnCodeBtn && hsnCodeField) {
                copyHsnCodeBtn.addEventListener('click', async function() {
                    try {
                        await navigator.clipboard.writeText(hsnCodeField.value);
                        // Show temporary success message
                        successMsg.style.display = 'block';
                        // Change button text/icon temporarily
                        const originalHTML = copyHsnCodeBtn.innerHTML;
                        copyHsnCodeBtn.innerHTML = '<i class="bi bi-check"></i> Copied!';
                        setTimeout(() => {
                            copyHsnCodeBtn.innerHTML = originalHTML;
                            successMsg.style.display = 'none';
                        }, 2000);
                    } catch (err) {
                        console.error('Failed to copy: ', err);
                        alert('Failed to copy. Please copy manually.');
                    }
                });
            }
        });
    </script>
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            const oldCategoryId = "<?php echo e(old('category_id')); ?>";
            const oldSubcategoryId = "<?php echo e(old('subcategory_id')); ?>";
            if (oldCategoryId) {
                fetchSubcategories(oldCategoryId, oldSubcategoryId);
            }
            $('#category_id').on('change', function() {
                const categoryId = $(this).val();
                fetchSubcategories(categoryId, null);
            });
            function fetchSubcategories(categoryId, selectedSubcategory) {
                if (categoryId) {
                    $.ajax({
                        url: 'getSubcategories',
                        type: 'GET',
                        data: {
                            categoryId: categoryId
                        },
                        dataType: 'json',
                        success: function(data) {
                            $('#subcategory_select').html('<option value="">Select</option>');
                            $.each(data.subcategories, function(index, subcategory) {
                                let isSelected = selectedSubcategory == subcategory.id ?
                                    'selected' : '';
                                $('#subcategory_select').append(
                                    `<option value="${subcategory.id}" ${isSelected}>${subcategory.subcategory_name}</option>`
                                );
                            });
                        },
                        error: function(xhr, status, error) {
                            console.error('Error fetching subcategories:', error);
                            console.error('Response:', xhr.responseText);
                        }
                    });
                } else {
                    $('#subcategory_select').html('<option value="">Select</option>');
                }
            }
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const dropArea = document.getElementById("drop-area");
            const fileInput = document.getElementById("images");
            const previewContainer = document.getElementById("preview-container");
            const uploadInstructions = document.getElementById("upload-instructions");
            const allowedTypes = ["image/jpeg", "image/png", "image/webp", "image/gif", "image/svg+xml",
                "image/bmp"
            ];
            const maxImages = 10;
            const updateInstructionsVisibility = () => {
                uploadInstructions.style.display = previewContainer.querySelectorAll(".preview-wrapper")
                    .length ? "none" : "block";
            };
            const createPreviewElement = (src) => {
                const wrapper = document.createElement("div");
                wrapper.className = "preview-wrapper";
                const img = document.createElement("img");
                img.src = `/${src}`; 
                wrapper.appendChild(img);
                const btn = document.createElement("button");
                btn.textContent = "x";
                btn.classList.add("remove-image");
                btn.type = "button";
                btn.onclick = () => {
                    removeImage(src, wrapper); 
                };
                wrapper.appendChild(btn);
                previewContainer.appendChild(wrapper);
            };
            const uploadFiles = (files) => {
                const currentImageCount = previewContainer.querySelectorAll(".preview-wrapper").length;
                const filesToUpload = Array.from(files).filter(file => allowedTypes.includes(file.type));
                if (currentImageCount + filesToUpload.length > maxImages) {
                    alert(
                        `You can only upload a maximum of ${maxImages} images. You have ${currentImageCount} images already.`
                    );
                    return;
                }
                if (filesToUpload.length === 0) return;
                const formData = new FormData();
                filesToUpload.forEach(file => {
                    formData.append("images[]", file);
                });
                fetch("<?php echo e(route('upload.temp.images')); ?>", {
                        method: "POST",
                        headers: {
                            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                        },
                        body: formData
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.status === 'success') {
                            data.images.forEach(src => {
                                createPreviewElement(src);
                            });
                            updateInstructionsVisibility();
                        } else {
                            alert(data.message || 'Error uploading images.');
                        }
                    })
                    .catch(error => {
                        console.error("Error uploading temporary images:", error);
                        alert("An error occurred during image upload.");
                    });
            };
            const removeImage = (src, elementToRemove) => {
                fetch("<?php echo e(route('remove.temp.image')); ?>", {
                        method: "POST",
                        headers: {
                            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            image_src: src
                        })
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.status === 'success') {
                            elementToRemove.remove();
                            updateInstructionsVisibility();
                        } else {
                            alert(data.message || 'Error removing image.');
                        }
                    })
                    .catch(error => {
                        console.error("Error removing temporary image:", error);
                        alert("An error occurred while removing the image.");
                    });
            };
            // Event Listeners
            dropArea.addEventListener("click", () => fileInput.click());
            dropArea.addEventListener("dragover", e => {
                e.preventDefault();
                dropArea.classList.add("dragging");
            });
            dropArea.addEventListener("dragleave", () => dropArea.classList.remove("dragging"));
            dropArea.addEventListener("drop", e => {
                e.preventDefault();
                dropArea.classList.remove("dragging");
                uploadFiles(e.dataTransfer.files);
            });
            fileInput.addEventListener("change", () => {
                uploadFiles(fileInput.files);
                fileInput.value =
                    '';
            });
            updateInstructionsVisibility();
            document.querySelectorAll('.remove-image').forEach(button => {
                button.onclick = () => {
                    removeImage(button.dataset.src, button.parentNode);
                };
            });
        });
    </script>
    <script>
        let variantIndex = 1;
        $('#add-variant-btn').on('click', function() {
            addVariant();
        });
        function addVariant() {
            const totalVariants = $('.variant-section').length;
            variantIndex = totalVariants + 1;
            let mrpValue = document.getElementById('mrp').value || 0;
            const variantHtml = `
            <div class="variant-section mb-4" data-variant-index="${variantIndex}">
                <h5 class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i> Variant ${variantIndex}</h5>
                <div class="row mt-3">
                    <div class="col-lg-6">
                        <div class="form-group mb-3">
                            <label class="form-label">Variant Name</label>
                            <input type="text" name="variants[${variantIndex}][name]" 
                            class="form-control variant-name" 
                            data-index="${variantIndex}" placeholder="Enter variant name">
                        </div>
                    </div>
                    <div class="col-lg-6" style="display:none;">
                        <div class="form-group mb-3">
                            <label class="form-label">MRP</label>
                            <input type="number" name="variants[${variantIndex}][mrp]" 
                            class="form-control variant-mrp" 
                            data-index="${variantIndex}" value="${mrpValue}" readonly>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group mb-3">
                            <label class="form-label">Selling Price</label>
                            <input type="number" name="variants[${variantIndex}][price]" 
                            class="form-control variant-price" 
                            data-index="${variantIndex}" placeholder="Enter price">
                        </div>
                    </div>
                    <div class="col-lg-6" style="display:none;">
                        <div class="form-group mb-3">
                            <label class="form-label">Discount (%)</label>
                            <input type="number" name="variants[${variantIndex}][discount]" 
                            class="form-control variant-discount" 
                            data-index="${variantIndex}" placeholder="Enter discount Percentage" readonly>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="button" class="btn btn-danger delete-variant-btn">Delete Variant</button>
                    </div>
                </div>
            </div>`;
            $('#variant-section').append(variantHtml);
        }
        $('#variant-section').on('click', '.delete-variant-btn', function() {
            $(this).closest('.variant-section').remove();
            updateVariantIndices();
        });
        function updateVariantIndices() {
            let newIndex = 1;
            $('.variant-section').each(function() {
                $(this).attr('data-variant-index', newIndex);
                $(this).find('.variant-heading').html(
                    `<i class="fa-solid fa-arrow-down me-1"></i> Variant ${newIndex}`
                );
                $(this).find('[name^="variants["]').each(function() {
                    const name = $(this).attr('name');
                    const newName = name.replace(/\[\d+\]/, `[${newIndex}]`);
                    $(this).attr('name', newName);
                });
                newIndex++;
            });
            variantIndex = newIndex;
        }
        document.getElementById('mrp').addEventListener('input', function() {
            let mrpValue = this.value;
            $('.variant-mrp').val(mrpValue);
            $('.variant-price').trigger('input');
        });
        document.getElementById('sell_price').addEventListener('input', calculateMainDiscount);
        document.getElementById('mrp').addEventListener('input', calculateMainDiscount);
        function calculateMainDiscount() {
            let mrp = parseFloat(document.getElementById('mrp').value);
            let sellingPrice = parseFloat(document.getElementById('sell_price').value);
            let discountField = document.getElementById('discount');
            if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp > sellingPrice && mrp > 0) {
                let discount = ((mrp - sellingPrice) / mrp) * 100;
                discountField.value = discount.toFixed(2);
            } else {
                discountField.value = '';
            }
        }
        // Calculate discount dynamically for each variant
        $('#variant-section').on('input', '.variant-price', function() {
            let index = $(this).data('index');
            let mrp = parseFloat($(`.variant-mrp[data-index="${index}"]`).val());
            let sellingPrice = parseFloat($(this).val());
            let discountField = $(`.variant-discount[data-index="${index}"]`);
            if (!isNaN(mrp) && !isNaN(sellingPrice) && mrp > sellingPrice && mrp > 0) {
                let discount = ((mrp - sellingPrice) / mrp) * 100;
                discountField.val(discount.toFixed(2));
            } else {
                discountField.val('');
            }
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let sellPriceInput = document.getElementById("sell_price");
            let shopWalletInput = document.getElementById("shop_wallet");
            let payableAmountInput = document.getElementById("payable_amount");
            function calculatePayableAmount() {
                let sellPrice = parseFloat(sellPriceInput.value) || 0;
                let shopWallet = parseFloat(shopWalletInput.value) || 0;
                let payableAmount = sellPrice - shopWallet;
                payableAmountInput.value = payableAmount.toFixed(2); // Show 2 decimal places
            }
            // Attach event listeners to input fields
            sellPriceInput.addEventListener("input", calculatePayableAmount);
            shopWalletInput.addEventListener("input", calculatePayableAmount);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/add_product.blade.php ENDPATH**/ ?>