<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #<?php echo e($offlineSale->order_id); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
            padding: 20px;
        }
        .invoice-container {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            margin: auto;
            padding: 40px;
        }
        .invoice-header {
            border-bottom: 3px solid #4CAF50;
            margin-bottom: 30px;
            padding-bottom: 20px;
        }
        .invoice-header h2 {
            color: #4CAF50;
        }
        .invoice-table th,
        .invoice-table td {
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
            font-size: 14px;
        }
        .invoice-table th {
            background-color: #f8f9fa;
            text-transform: uppercase;
            font-size: 13px;
        }
        .summary-section p {
            margin: 4px 0;
            font-size: 14px;
        }
        .summary-section h4 {
            color: #007b00;
            font-weight: bold;
        }
        .invoice-footer {
            font-size: 12px;
            color: #777;
            text-align: center;
            margin-top: 40px;
            border-top: 1px solid #e0e0e0;
            padding-top: 10px;
        }
        @media print {
            body {
                background: #fff !important;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            .invoice-container {
                box-shadow: none;
                margin: 0;
                padding: 0;
                border-radius: 0;
            }
            .no-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <!-- Header -->
        <div class="invoice-header d-flex justify-content-between align-items-start flex-wrap">
            <div>
                <h2><?php echo e($branchInfo['name'] ?? 'Branch Name'); ?></h2>
                <div class="company-info">
                    <?php echo e($branchInfo['address'] ?? ''); ?><br>
                    Phone: <?php echo e($branchInfo['phone'] ?? ''); ?><br>
                    Email: <?php echo e($branchInfo['email'] ?? ''); ?><br>
                </div>
            </div>
            <div class="text-end mt-3 mt-lg-0">
                <h4 class="text-uppercase">Tax Invoice</h4>
                <strong>Invoice No:</strong> <?php echo e($offlineSale->order_id); ?><br>
                <strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($offlineSale->created_at)->format('d-M-Y H:i')); ?>

            </div>
        </div>
        <!-- Customer Info -->
        <div class="row mb-4">
            <div class="col-md-6">
                <strong>Customer:</strong> <?php echo e($offlineSale->customer_details['name'] ?? 'Walk-in Customer'); ?><br>
                <?php if(!empty($offlineSale->customer_details['phone_number'])): ?>
                    <strong>Phone:</strong> <?php echo e($offlineSale->customer_details['phone_number']); ?><br>
                <?php endif; ?>
                <?php if(!empty($offlineSale->customer_details['address'])): ?>
                    <strong>Address:</strong> <?php echo e($offlineSale->customer_details['address']); ?>

                <?php endif; ?>
            </div>
        </div>
        <!-- Items Table -->
        <table class="invoice-table table table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Item</th>
                    <th>Item Code</th>
                    <th>Sales Price</th>
                    <th>Qty</th>
                    <th>Rate (Incl. GST)</th>
                    <th>GST %</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $offlineSale->sale_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($item['name']); ?></td>
                        <td><?php echo e($item['item_code']); ?></td>
                        <td>₹<?php echo e(number_format($item['sell_price'], 2)); ?></td>
                        <td><?php echo e($item['quantity']); ?></td>
                        <td>₹<?php echo e(number_format($item['sell_price'], 2)); ?></td>
                        <td><?php echo e(number_format($item['gst'] ?? 0, 2)); ?>%</td>
                        <td>₹<?php echo e(number_format($item['total'] ?? ($item['sell_price'] * $item['quantity']), 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <!-- Summary -->
        <div class="row mt-4">
            <div class="col-md-7">
                <p><strong>Thank you for your purchase!</strong></p>
            </div>
            <div class="col-md-5">
                <div class="summary-section">
                    <p><strong>Subtotal (Incl. GST):</strong> ₹<?php echo e(number_format($offlineSale->sub_total, 2)); ?></p>
                    <?php if($offlineSale->discount > 0): ?>
                        <p><strong>Discount:</strong> -₹<?php echo e(number_format($offlineSale->discount, 2)); ?></p>
                    <?php endif; ?>
                    <?php if($offlineSale->additional_charge > 0): ?>
                        <p><strong>Additional Charges:</strong> +₹<?php echo e(number_format($offlineSale->additional_charge, 2)); ?></p>
                    <?php endif; ?>
                    <?php if($offlineSale->cash_wallet_deduction > 0): ?>
                        <p><strong>Cash Wallet Deduction:</strong> -₹<?php echo e(number_format($offlineSale->cash_wallet_deduction, 2)); ?></p>
                    <?php endif; ?>
                    <?php if($offlineSale->shopping_wallet_deduction > 0): ?>
                        <p><strong>Shopping Wallet Deduction:</strong> -₹<?php echo e(number_format($offlineSale->shopping_wallet_deduction, 2)); ?></p>
                    <?php endif; ?>
                    <p><strong>Subtotal (Excl. Tax):</strong>
                        ₹<?php echo e(number_format(($offlineSale->amount_payable ?? 0) - ($offlineSale->cgst ?? 0) - ($offlineSale->sgst ?? 0), 2)); ?>

                    </p>
                    <p><strong>CGST:</strong> ₹<?php echo e(number_format($offlineSale->cgst, 2)); ?></p>
                    <p><strong>SGST:</strong> ₹<?php echo e(number_format($offlineSale->sgst, 2)); ?></p>
                    <hr>
                    <h4><strong>Total Payable:</strong> ₹<?php echo e(number_format($offlineSale->amount_payable, 2)); ?></h4>
                    <p><strong>Payment Mode:</strong> <?php echo e(ucfirst($offlineSale->payment_mode)); ?></p>
                </div>
            </div>
        </div>
        <!-- Footer -->
        <div class="invoice-footer">
            For any queries, please contact us at your support email/phone.
        </div>
    </div>
</body>
</html>
<?php /**PATH /var/www/adbazzar.com/resources/views/employee/invoice_a4.blade.php ENDPATH**/ ?>