
<?php $__env->startSection('title', 'Recent Orders'); ?>
<?php $__env->startSection('header'); ?>

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading"> Subscription Request</h3>
                <a href="<?php echo e(route('subscription_history')); ?>" class="btn btn-primary">
                    <i class="fa fa-history me-1"></i> History
                </a>
            </div>
        </div>

        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>DATE</th>
                                    <th>USER ID</th>
                                    <th>NAME</th>
                                    <th>MEMBERSHIP ID</th>
                                    <th>TITLE</th>
                                    <th>AMOUNT</th>
                                    <th>TRANSACTION ID</th>
                                    <th>PAYMENT IMAGE</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__currentLoopData = $datatables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>

                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d-m-Y')); ?></td>
                                        <td><?php echo e($data->user_id); ?></td>
                                        <td><?php echo e($data->name); ?></td>
                                        <td><?php echo e($data->membership_id); ?></td>
                                        <td><?php echo e($data->title); ?></td>
                                        <td><?php echo e($data->amount); ?></td>
                                        <td><?php echo e($data->transaction_id); ?></td>

                                        <td>
                                            <a href="<?php echo e(asset($data->payment_image)); ?>" target="_blank">
                                                <img src="<?php echo e(asset($data->payment_image)); ?>" alt="Proof Image"
                                                    style="width: 100px; height: auto;">
                                            </a>
                                        </td>

                                        <td>
                                            <button type="button" data-bs-toggle="modal" data-bs-target="#AcceptModal"
                                                class="btn transparent-btn text-success text-decoration-underline"
                                                data-user-id="<?php echo e($data->id); ?>"
                                                onclick="setAcceptId(this)">Accept</button>
                                            <button type="button" data-bs-toggle="modal" data-bs-target="#DeclineModal"
                                                class="btn transparent-btn text-danger text-decoration-underline"
                                                data-user-id="<?php echo e($data->id); ?>"
                                                onclick="setRejectId(this)">Decline</button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>


                        </table>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->

        <!-- Accept Modal -->
        <div class="modal fade zoom-in" id="AcceptModal" tabindex="-1" aria-labelledby="AcceptModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="text-center">
                            <img class="mb-3" style="height: 75px;" src="<?php echo e(asset('/assets/images/gif/accept.png')); ?>">
                            <p class="my-4 are-you-sure">Are You Sure</p>
                            <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to accept this order?</p>
                        </div>
                        <form action="<?php echo e(route('accept_request')); ?>" method="POST" id="AcceptForm">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="accept_id" name="accept_id">
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button type="button" data-bs-dismiss="modal"
                                    class="btn btn-light cancel-btn me-3">Cancel</button>

                                <button type="button" class="btn btn-primary yes-btn" id="submitButton"
                                onclick="AcceptButton(this)"><i
                                        class="fa-regular fa-circle-check me-2 "></i>Yes, Accept It!</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Decline Modal -->
        <div class="modal fade zoom-in" id="DeclineModal" tabindex="-1" aria-labelledby="DeclineModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="text-center">
                            <img class="mb-3" style="height:75px;" src="<?php echo e(asset('/assets/images/gif/reject.png')); ?>">
                            <p class="my-4 are-you-sure">Are You Sure</p>
                            <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to decline this order?</p>
                        </div>
                        <form action="<?php echo e(route('reject_request')); ?>" method="POST" id="RejectForm">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="reject_id" name="reject_id">
                            <div class="form-group mb-3">
                                <label for="banner_name" class="form-label">Remark</label>
                                <input type="text" name="remark" class="form-control" id="remark" required>
                            </div>
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button type="button" data-bs-dismiss="modal"
                                    class="btn btn-light cancel-btn me-3">Cancel</button>
                                <button type="button" class="btn btn-primary yes-btn" id="submitButton"
                                onclick="RejectButton(this)"><i
                                        class="fa-regular fa-circle-check me-2" ></i>Yes, Decline It!</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>



    </div>
    <!-- end container fluid -->




<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>



    <script>
        function setAcceptId(button) {
            var acceptId = button.getAttribute('data-user-id');
            document.getElementById('accept_id').value = acceptId;
        }
    </script>
    <script>
        function setRejectId(button) {
            var rejectId = button.getAttribute('data-user-id');
            document.getElementById('reject_id').value = rejectId;
        }
    </script>

    <script>
        function RejectButton(button) {
            button.disabled = true;
            button.innerText = 'Processing...';
            document.getElementById('RejectForm').submit();
        }
    </script>
    <script>
        function AcceptButton(button) {
            button.disabled = true;
            button.innerText = 'Processing...';
            document.getElementById('AcceptForm').submit();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/subscription_requests.blade.php ENDPATH**/ ?>