
<?php $__env->startSection('title', 'Recent Orders'); ?>
<?php $__env->startSection('header'); ?>

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Recent Orders</h3>
            </div>

            <div class="row mt-4">
                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="<?php echo e(route('recent_orders')); ?>" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <strong>
                                            <p class="mb-0 d-card-para-title">Recent Orders</p>
                                        </strong>
                                        <h2 class="mb-0 d-card-inner-head"><?php echo e($recentOrderCount); ?></h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="<?php echo e(asset('/assets/images/icons/envelope.svg')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="<?php echo e(route('accept_orders')); ?>" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <p class="mb-0 d-card-para-title">Accepted Orders</p>
                                        <h2 class="mb-0 d-card-inner-head"><?php echo e($acceptedOrderCount); ?></h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="<?php echo e(asset('/assets/images/icons/envelope.svg')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <div class="card border-0 dashboard-widget-card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="me-4 text-center">
                                    <p class="mb-0 d-card-para-title">Shipped Orders</p>
                                    <h2 class="mb-0 d-card-inner-head"><?php echo e($shippedOrderCount ?? '0'); ?></h2>
                                </div>
                                <div class="d-card-icon">
                                    <img class="dashboard-icon-img" src="<?php echo e(asset('/assets/images/icons/envelope.svg')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <div class="card border-0 dashboard-widget-card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="me-4 text-center">
                                    <p class="mb-0 d-card-para-title">Delivered Orders</p>
                                    <h2 class="mb-0 d-card-inner-head"><?php echo e($deliveredOrderCount ?? '0'); ?></h2>
                                </div>
                                <div class="d-card-icon">
                                    <img class="dashboard-icon-img" src="<?php echo e(asset('/assets/images/icons/envelope.svg')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-md-6 col-lg-4 col-xl-4">
                    <a href="<?php echo e(route('rejected_orders')); ?>" class="text-decoration-none">
                        <div class="card border-0 dashboard-widget-card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-4 text-center">
                                        <p class="mb-0 d-card-para-title">Cancelled Orders</p>
                                        <h2 class="mb-0 d-card-inner-head"><?php echo e($cancelledOrderCount ?? '0'); ?></h2>
                                    </div>
                                    <div class="d-card-icon">
                                        <img class="dashboard-icon-img"
                                            src="<?php echo e(asset('/assets/images/icons/envelope.svg')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>


        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label for="fromDate" class="form-label">From Date:</label>
                                <input type="date" class="form-control" id="fromDate">
                            </div>
                            <div class="col-md-3">
                                <label for="toDate" class="form-label">To Date:</label>
                                <input type="date" class="form-control" id="toDate">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="button" class="btn btn-primary me-2" id="filterBtn">Filter</button>
                                <button type="button" class="btn btn-secondary" id="resetBtn">Reset</button>
                            </div>
                        </div>
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER ID</th>
                                    <th>USER DETAILS</th>
                                    <th>MEMBERSHIP</th>
                                    <th>AMOUNT</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recent_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $recent_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($recent_order->order_date)->format('Y-m-d')); ?>

                                        </td>
                                        <td><?php echo e($recent_order->order_random_id); ?></td>
                                        <td>
                                            <div><?php echo e($recent_order->user_id ?? 'NA'); ?></div>
                                        </td>
                                        <td>
                                            <?php if($recent_order->user): ?>
                                                <div>Name: <?php echo e($recent_order->user->name); ?></div>
                                                <div>Email: <?php echo e($recent_order->user->email); ?></div>
                                                <div>Phone: <?php echo e($recent_order->user->phone_number); ?></div>
                                            <?php else: ?>
                                                <div>NA</div>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($recent_order->user->membership); ?></td>
                                        <td><span>₹<?php echo e($recent_order->amount); ?></span></td>
                                        <td>
                                            <a href="<?php echo e(route('view_recent_orders', ['order_random_id' => $recent_order->order_random_id])); ?>"
                                                class="btn btn-primary btn-sm">
                                                <i class="fa-regular fa-eye me-2"></i>View Order
                                            </a>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php $__currentLoopData = $recent_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="modal fade zoom-in" id="AcceptModal<?php echo e($recent_order->id); ?>" tabindex="-1"
                aria-labelledby="AcceptModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="text-center">
                                <img class="mb-3" style="height: 75px;"
                                    src="<?php echo e(asset('/assets/images/gif/accept.png')); ?>">
                                <p class="my-4 are-you-sure">Are You Sure</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to accept this order?
                                </p>
                            </div>
                            <form action="<?php echo e(route('accept_order')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="order_id" value="<?php echo e($recent_order->id); ?>">
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button type="button" data-bs-dismiss="modal"
                                        class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <button type="submit" class="btn btn-primary yes-btn"><i
                                            class="fa-regular fa-circle-check me-2"></i>Yes, Accept It!</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php $__currentLoopData = $recent_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="modal fade zoom-in" id="DeclineModal<?php echo e($recent_order->id); ?>" tabindex="-1"
                aria-labelledby="DeclineModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="text-center">
                                <img class="mb-3" style="height:75px;"
                                    src="<?php echo e(asset('/assets/images/gif/reject.png')); ?>">
                                <p class="my-4 are-you-sure">Are You Sure</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to decline this
                                    order?</p>
                            </div>
                            <form action="<?php echo e(route('decline_order')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="order_id" value="<?php echo e($recent_order->id); ?>">
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button type="button" data-bs-dismiss="modal"
                                        class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <button type="submit" class="btn btn-primary yes-btn"><i
                                            class="fa-regular fa-circle-check me-2"></i>Yes, Decline It!</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>




<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
    
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>

    <script>
        $(document).ready(function() {
            let table = $('#data-table').DataTable({
                responsive: true
            });

            $.fn.dataTable.ext.search.push(
                function(settings, data, dataIndex) {
                    let fromDate = $('#fromDate').val();
                    let toDate = $('#toDate').val();
                    let orderDate = data[1]; 

                    if (!fromDate && !toDate) {
                        return true;
                    }

                    let momentOrderDate = moment(orderDate, 'YYYY-MM-DD');
                    let fromMoment = fromDate ? moment(fromDate) : null;
                    let toMoment = toDate ? moment(toDate) : null;

                    if (fromDate && !toMoment && momentOrderDate.isSameOrAfter(fromMoment, 'day')) {
                        return true;
                    }

                    if (!fromMoment && toDate && momentOrderDate.isSameOrBefore(toMoment, 'day')) {
                        return true;
                    }

                    if (fromMoment && toMoment && momentOrderDate.isSameOrAfter(fromMoment, 'day') &&
                        momentOrderDate.isSameOrBefore(toMoment, 'day')) {
                        return true;
                    }

                    return false;
                }
            );

            $('#filterBtn').on('click', function() {
                table.draw();
            });

            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                table.draw();
            });
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/recent_orders.blade.php ENDPATH**/ ?>