<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #<?php echo e($offlineSale->order_id); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: 'Consolas', monospace;
            font-size: 14px;
            /* Increased base font size */
            /* width: 80mm;
            padding: 5mm; */
            margin: 0;
            color: #000;
        }
        .header,
        .footer {
            text-align: center;
        }
        .header h2 {
            margin: 0;
            font-size: 16px;
            /* Larger font for company name */
            font-weight: bold;
        }
        .line {
            border-bottom: 1px dashed #000;
            margin: 8px 0;
        }
        .details p {
            margin: 4px 0;
            font-size: 12px;
        }
        .details {
            margin: 8px 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 4px;
        }
        .item-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        .item-table th,
        .item-table td {
            padding: 4px 0;
            /* word-break: break-word; */
            text-align: left;
        }
        .item-table th {
            border-bottom: 1px dashed #000;
            font-weight: bold;
        }
        .item-table .sn {
            width: 10%;
            text-align: left;
        }
        .item-table .desc {
            width: 45%;
        }
        .item-table .qty,
        .item-table .rate,
        .item-table .amt {
            width: 15%;
            text-align: right;
        }
         .item-table .rate {
           font-size: 10px;
        }
        .item-table .amt {
            font-weight: 600;
        }
        .totals p {
            display: flex;
            justify-content: space-between;
            margin: 4px 0;
            font-size: 12px;
        }
        .total-row {
            font-weight: bold;
            font-size: 12px;
            /* Larger font for total */
        }
        .footer p {
            font-size: 12px;
            margin: 4px 0;
        }
        @media print {
            @page {
                margin: 0;
            }
            body {
                margin: 5px;
                padding: 6px;
            }
            .header,
            .footer,
            .details,
            .totals {
                margin-left: 5mm;
                margin-right: 5mm;
            }
            .item-table {
                padding: 0 5mm;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2><?php echo e($branchInfo['name']); ?></h2>
        <p><?php echo e($branchInfo['address'] ?? ''); ?></p>
        <p>Phone: <?php echo e($branchInfo['phone']); ?> | Email: <?php echo e($branchInfo['email']); ?></p>
        <div class="line"></div>
        <strong>SALES RECEIPT</strong>
    </div>
    <div class="details">
        <div class="info-row">
            <span>Bill No:</span>
            <span><?php echo e($offlineSale->order_id); ?></span>
        </div>
        <div class="info-row">
            <span>Date:</span>
            <span><?php echo e(\Carbon\Carbon::parse($offlineSale->created_at)->format('d/m/Y H:i')); ?></span>
        </div>
        <div class="info-row">
            <span>Customer:</span>
            <span><?php echo e($offlineSale->customer_details['name'] ?? 'Walk-in'); ?></span>
        </div>
        <?php if(isset($offlineSale->customer_details['phone_number'])): ?>
            <div class="info-row">
                <span>Phone:</span>
                <span><?php echo e($offlineSale->customer_details['phone_number']); ?></span>
            </div>
        <?php endif; ?>
    </div>
    <div class="line"></div>
    <table class="item-table">
        <thead>
            <tr>
                <th class="sn">SN</th>
                <th class="desc">ITEMS</th>
                <th class="qty">Qty</th>
                <th class="rate">Rate</th>
                <th class="amt">Amt</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $offlineSale->sale_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="sn"><?php echo e($index + 1); ?></td>
                    <td class="desc"><?php echo e($item['name']); ?></td>
                    <td class="qty"><?php echo e(number_format($item['quantity'])); ?></td>
                    <td class="rate"><?php echo e(number_format($item['sell_price'], 0)); ?></td>
                    <td class="amt">
                        <?php echo e(number_format($item['sell_price'] * $item['quantity'] - ($item['discount'] ?? 0), 0)); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="line"></div>
    <div class="totals">
        <p>
            <span>Sub Total:</span>
            <span>₹<?php echo e(number_format($offlineSale->sub_total, 2)); ?></span>
        </p>
        <?php if($offlineSale->discount > 0): ?>
            <p><span>Discount:</span> <span>-₹<?php echo e(number_format($offlineSale->discount, 2)); ?></span></p>
        <?php endif; ?>
        <?php if($offlineSale->additional_charge > 0): ?>
            <p><span>Additional Charge:</span> <span>+₹<?php echo e(number_format($offlineSale->additional_charge, 2)); ?></span>
            </p>
        <?php endif; ?>
        <?php if($offlineSale->cash_wallet_deduction > 0): ?>
            <p><span>Cash Wallet:</span> <span>-₹<?php echo e(number_format($offlineSale->cash_wallet_deduction, 2)); ?></span></p>
        <?php endif; ?>
        <?php if($offlineSale->shopping_wallet_deduction > 0): ?>
            <p><span>Shopping Wallet:</span>
                <span>-₹<?php echo e(number_format($offlineSale->shopping_wallet_deduction, 2)); ?></span></p>
        <?php endif; ?>
        <div class="line"></div>
        <p class="total-row"><span>TOTAL:</span> <span>₹<?php echo e(number_format($offlineSale->amount_payable, 2)); ?></span></p>
        <p><span>Paid By:</span> <span><?php echo e(ucfirst($offlineSale->payment_mode)); ?></span></p>
        <p><span>Received:</span>
            <span>₹<?php echo e(number_format($offlineSale->receivedAmount ?? $offlineSale->amount_payable, 2)); ?></span></p>
    </div>
    <div class="line"></div>
    <div class="footer">
        <p>Thank you for shopping with us!</p>
        <p>Visit again!</p>
    </div>
<script>
    window.addEventListener('load', function () {
        window.print();
        // Get the URL parameter ?from=pos
        const urlParams = new URLSearchParams(window.location.search);
        const from = urlParams.get('from');
        const posBillingUrl = "<?php echo e(route('employee.pos_billing')); ?>";
        const dashboardUrl = "<?php echo e(route('employee.dashboard')); ?>";
        window.addEventListener('afterprint', redirectAfterPrint);
        setTimeout(redirectAfterPrint, 3000);
        function redirectAfterPrint() {
            if (from === 'pos') {
                window.location.href = posBillingUrl;
            } else {
                window.location.href = dashboardUrl;
            }
        }
    });
</script>
</body>
</html>
<?php /**PATH /var/www/adbazzar.com/resources/views/employee/invoice_thermal.blade.php ENDPATH**/ ?>