
<?php $__env->startSection('title', 'Employee'); ?>
<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-oBqDVmMz4fnFO9t5a6P6A6O6A0p3U7v38wzA1N39N7Jt6jvNIi2B2i+1DkF1Vr" crossorigin="anonymous"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Employee</h3>
            </div>
        </div>
        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <h5 class="card-title">Add Employee</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('employee_store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        
                                        <div class="form-group mb-3">
    
      <label class="form-label">Branch</label>
        <input type="text" 
               class="form-control" 
               value="<?php echo e(strtoupper(auth()->user()->name)); ?>" 
               disabled>
    
    <?php if(auth()->user()->role === 'admin'): ?>
        <!-- Visible only for Admin -->
        <select name="branch_id" id="branch_id" class="form-control" required>
            <option value="">-- Select Branch --</option>
            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($branch->id); ?>"
                    <?php echo e(old('branch_id', auth()->user()->branch_id ?? '') == $branch->id ? 'selected' : ''); ?>>
                    <?php echo e($branch->branch_name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

    <?php else: ?>
        <!-- Other roles hidden completely (no input, no readonly) -->
        <input type="hidden" name="branch_id" value="<?php echo e(auth()->user()->branch_id); ?>">
    <?php endif; ?>
</div>

                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" id="name">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="designation" class="form-label">Email</label>
                                        <input type="text" name="email" class="form-control" id="designation">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="name" class="form-label">Password</label>
                                        <input type="text" name="password" class="form-control" id="name">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="designation" class="form-label">Designation</label>
                                        <input type="text" name="designation" class="form-control" id="designation">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="phone" class="form-label">Phone Number</label>
                                        <input type="text" name="phone" class="form-control" id="phone">
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="address" class="form-label">Address</label>
                                        <input type="text" name="address" class="form-control" id="address">
                                    </div>
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="mb-3">
                    <h6 class="table-heading">Employee List</h6>
                </div>
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Date</th>
                                    <th>Branch</th>
                                    <th>Designation</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($employee->created_at)->format('d-M-Y')); ?></td>
                                        <td><?php echo e($employee->branch); ?></td>
                                        <td><?php echo e($employee->designation); ?></td>
                                        <td><?php echo e($employee->name); ?></td>
                                        <td><?php echo e($employee->phone); ?></td>
                                        <td><?php echo e($employee->address); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('edit_employee', $employee->id)); ?>"
                                                class="btn btn-sm btn-primary">
                                                Edit
                                            </a>
                                            <button type="button" data-bs-toggle="modal"
                                                data-bs-target="#DeleteModal-<?php echo e($employee->id); ?>"
                                                class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center">No employees found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeeItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="modal fade zoom-in" id="DeleteModal-<?php echo e($employeeItem->id); ?>" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="p-3">
                                        <div class="text-center">
                                            <img class="mb-3"
                                                src="<?php echo e(asset('/assets/images/icons/delete-icon.svg')); ?>">
                                            <p class="my-4 are-you-sure">Are You Sure?</p>
                                            <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete
                                                this employee?</p>
                                        </div>
                                        <div class="d-flex align-items-center mt-5 mb-3">
                                            <button data-bs-dismiss="modal"
                                                class="btn btn-light cancel-btn me-3">Cancel</button>
                                            <a href="<?php echo e(route('employee_delete', $employeeItem->id)); ?>"
                                                class="btn btn-primary yes-btn"><i
                                                    class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const deleteButtons = document.querySelectorAll('.deleteBtn');
            const deleteForm = document.getElementById('deleteEmployeeForm');
            deleteButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const employeeId = this.getAttribute('data-id');
                    deleteForm.setAttribute('action', '/employee/delete/' + employeeId);
                });
            });
        });
    </script>
    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/add_employee.blade.php ENDPATH**/ ?>