<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy – AdBazzar</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.7;
            color: #343a40;
            background-color: #f8f9fa;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            color: #138FA6 !important;
        }
        .container {
            flex: 1;
            background-color: #ffffff;
            border-radius: 0.75rem;
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.08);
            padding: 2.5rem;
            margin-top: 3rem;
            margin-bottom: 3rem;
        }
        .header-title {
            font-size: clamp(2rem, 4vw, 3rem);
            font-weight: 700;
            margin-bottom: 2.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #e9ecef;
        }
        .section-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }
        .section-title i {
            margin-right: 0.75rem;
            font-size: 1.6em;
            color: #138FA6;
        }
        p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }
        ul {
            list-style-type: none;
            padding-left: 0;
        }
        ul li {
            margin-bottom: 0.6rem;
            font-size: 1.05rem;
            position: relative;
            padding-left: 1.8rem;
        }
        ul li::before {
            content: "\f24c"; /* Bootstrap icon for info-circle-fill */
            font-family: "bootstrap-icons";
            color: #138FA6;
            font-weight: bold;
            display: inline-block;
            position: absolute;
            left: 0;
            top: 0.1em;
            font-size: 1.1em;
        }
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.05);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            margin-bottom: 1.5rem;
        }
        .card:hover {
            transform: translateY(-0.25rem);
            box-shadow: 0 0.5rem 1.25rem rgba(0, 0, 0, 0.09);
        }
        a {
            color: #138FA6;
            text-decoration: none;
            font-weight: 500;
        }
        a:hover {
            text-decoration: underline;
        }
        .footer {
            margin-top: 3rem;
            padding: 1.5rem;
            text-align: center;
            color: #6c757d;
            font-size: 0.875rem;
            background-color: #e9ecef;
            border-top: 1px solid #dee2e6;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .container {
                margin-top: 1.5rem;
                margin-bottom: 1.5rem;
                padding: 1.5rem;
                border-radius: 0;
                box-shadow: none;
            }
            .header-title {
                font-size: 1.8rem;
                text-align: center;
                margin-bottom: 2rem;
            }
            .section-title {
                font-size: 1.5rem;
                justify-content: center;
                text-align: center;
            }
            ul li {
                padding-left: 1.5rem;
            }
            ul li::before {
                font-size: 1em;
                left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="header-title text-center">Privacy Policy – AdBazzar</h1>
        <div class="card p-4 mb-4 animate__animated animate__fadeIn">
            <p>At AdBazzar, we value your privacy and are committed to protecting your personal information. This policy outlines how we collect, use, and protect your data to ensure a safe and trustworthy shopping experience.</p>
        </div>

        <div class="card p-4 mb-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-collection"></i>Information We Collect:</h2>
            <p>We collect the following information <strong>for order processing only</strong>:</p>
            <ul class="list-unstyled">
                <li><strong>Name:</strong>To address your orders correctly.</li>
                <li><strong>Mobile number:</strong>For delivery communication and order updates.</li>
                <li><strong>Delivery address:</strong>To ensure your products reach you safely and accurately.</li>
            </ul>
            <p class="text-muted small mt-3">This data is essential to deliver your ordered products safely and accurately to your location. We prioritize your privacy and data security.</p>
        </div>

        <div class="card p-4 mb-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-database-fill"></i>Data Usage:</h2>
            <p>Your collected data is used <strong>strictly for order fulfillment</strong>. It is <strong>never shared</strong> with third parties for marketing or any other purposes.</p>
        </div>

        <div class="card p-4 mb-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-credit-card-fill"></i>Third-party Integrations:</h2>
            <p><strong>Razorpay</strong> (our payment gateway partner) securely processes all payments. <strong>We do not store any of your payment details</strong> (like card numbers, bank account info, or UPI IDs) on our servers, ensuring your financial data remains confidential.</p>
        </div>

        <div class="card p-4 mb-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-envelope-fill"></i>Contact Us:</h2>
            <p>For any privacy-related concerns, questions about your data, or general inquiries, please feel free to reach out:</p>
            <p class="text-center">Email: <a href="mailto:adbazzarindia@gmail.com" class="fw-bold">adbazzarindia@gmail.com</a><br>or use our convenient in-app support feature.</p>
        </div>

        <div class="card p-4 animate__animated animate__fadeInUp">
            <h2 class="section-title text-center text-md-start"><i class="bi bi-calendar-check-fill"></i>Effective Date:</h2>
            <p>This Privacy Policy is effective from the date the AdBazzar app is installed by the user, and it applies to all subsequent uses.</p>
        </div>
    </div>

    <footer class="footer">
        &copy; 2025 AdBazzar. All rights reserved. Your privacy matters to us.
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html><?php /**PATH /var/www/adbazzar.com/resources/views/admin/privacy_policy.blade.php ENDPATH**/ ?>