<!DOCTYPE html>
<html lang="en" x-data="posBillingEdit(<?php echo e($offlineSale); ?>)" @keydown.window="handleGlobalKeys($event)">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Edit Invoice #<?php echo e($offlineSale->order_id); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3/dist/cdn.min.js"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
   <style>
        .pos-search-results {
            max-height: 200px;
 overflow-y: auto;
            z-index: 1000;
            position: absolute;
            width: calc(100% - 2rem);
            background-color: white;
            border: 1px solid #dee2e6;
            border-top: none;
            left: 1rem;
 right: 1rem;
        }
        .table-scroll-container {
            max-height: calc(100vh - 450px);
 overflow-y: auto;
        }
        .table thead th {
            position: sticky;
 top: 0;
            background-color: #f8f9fa;
            z-index: 10;
        }
        .customer-details-compact p {
            margin-bottom: 0;
 line-height: 1.2;
        }
    </style>
</head>
<body>
    <div class="position-fixed top-0 end-0 p-3" style="z-index: 1100">
    <div id="stockToast" class="toast align-items-center text-white bg-danger border-0" role="alert">
        <div class="d-flex">
            <div class="toast-body" id="stockToastMessage"></div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    </div>
</div>
    <div class="container-fluid bg-light border-bottom py-2 px-3 d-flex justify-content-between align-items-center">
        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> <strong>Back</strong> [ESC]
        </a>
        <h6 class="m-0">Editing Invoice #<span x-text="bill.order_id"></span></h6>
        <div class="d-flex gap-2">
            <button class="btn btn-outline-secondary btn-sm" @click="openSettings()">
             <strong>Settings</strong> [CTRL+S]
            </button>
        </div>
    </div>
    <div class="container-fluid p-3">
        <div class="d-flex flex-wrap align-items-center gap-3 px-2 py-2 bg-light border rounded">
            <div class="card-header bg-primary text-white py-2 px-3 rounded-top">
                <h6 class="mb-0">Customer Details</h6>
       </div>
            <div class="flex-grow-1">
                <input type="text" class="form-control" x-model.debounce.500ms="bill.customerIdentifier"
                    @input.debounce.500ms="fetchCustomerDetails" placeholder="Type customer phone or name to search...">
            </div>
            <template x-if="bill.customerDetails">
           <div class="d-flex flex-wrap align-items-center gap-3">
                    <div>
                        <strong x-text="bill.customerDetails.name"></strong>
                        <small class="text-muted">(ID: <span x-text="bill.customerDetails.user_id"></span>)</small>
                   </div>
                    <div>
                        <span class="badge bg-success">
                            ₹<span x-text="bill.customerDetails.cash_wallet_balance.toFixed(2)"></span> Cash
                       </span>
                        <span class="badge bg-info text-dark">
                            ₹<span x-text="bill.customerDetails.shopping_wallet_balance.toFixed(2)"></span> Shopping
                        </span>
                  </div>
                    <div class="text-muted small">
                        <i class="bi bi-telephone"></i>
                        <span x-text="bill.customerDetails.phone_number"></span>
                    </div>
     <div class="text-muted small">
                        <i class="bi bi-geo-alt"></i>
                        <span x-text="bill.customerDetails.address"></span>
                    </div>
            </div>
            </template>
            <div class="text-muted small fst-italic"
                x-show="bill.customerIdentifier && !bill.customerDetails && !bill.customerDetailsLoading">
                No customer found. <a href="#" @click.prevent="openNewCustomerModal">Register new customer?</a>
            </div>
            <div class="text-info small fst-italic" x-show="bill.customerDetailsLoading">
                Searching...
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-8 border-end position-relative">
             <div class="d-flex gap-2 mb-3">
                    <button class="btn btn-outline-secondary btn-sm" @click="openPriceChangeModal">Change Price
                        [CTRL+P]</button>
                    <button class="btn btn-outline-secondary btn-sm" @click="openQuantityChangeModal">Change QTY
                 [CTRL+Q]</button>
                    <button class="btn btn-outline-secondary btn-sm" @click="deleteSelectedItem()">Delete Item
                        [DEL]</button>
                </div>
                <div class="input-group mb-3">
              <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input x-ref="searchInput" class="form-control" type="text" placeholder="Search item/code"
                        x-model.debounce.300ms="bill.searchQuery" @input.debounce.300ms="searchProducts"
                        @keydown.enter.prevent="handleSearchEnter" @keydown.arrow-down.prevent="selectNextResult"
                          @keydown.arrow-up.prevent="selectPrevResult" @keydown.escape.stop="clearSearchResults"
                        @focus="bill.searchQuery = ''">
                    <span class="input-group-text">[F1]</span>
                </div>
                <ul class="list-group pos-search-results" x-show="bill.searchResults.length">
                   <template x-for="(prod, idx) in bill.searchResults" :key="prod.item_identifier">
                        <li class="list-group-item list-group-item-action"
                            :class="{ 'active': idx === bill.selectedSearchResultIndex }"
                     @click="addItemToBill(prod)" @mouseover="bill.selectedSearchResultIndex = idx">
                            <span x-text="prod.name"></span> - <small x-text="prod.item_code"></small> (₹ <span
                                x-text="Number(prod.sell_price || 0).toFixed(2)"></span>)
                        </li>
                    </template>
                </ul>
                <div class="table">
                    <table class="table table-bordered table-striped text-center">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Item</th>
                                <th>Code</th>
                                <th>MRP</th>
                                <th>SP</th>
                                <th>QTY</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-if="!bill.billItems.length">
                                <tr>
                                    <td colspan="7" class="py-5 text-muted">
                                        <i class="bi bi-box-seam fs-1"></i>
                                        <p>Add items...</p>
                                    </td>
                                </tr>
                            </template>
                            <template x-for="(item, idx) in bill.billItems" :key="item.item_identifier + idx">
                                 <tr :class="{ 'table-primary': bill.selectedItemIndex === idx }"
                                    @click="selectItem(idx)">
                                    <td x-text="idx + 1"></td>
                                    <td x-text="item.name"></td>
                                    <td x-text="item.item_code"></td>
                                    <td x-text="(Number(item.mrp) || 0).toFixed(2)"></td>
                                    <td x-text="(Number(item.sell_price) || 0).toFixed(2)"></td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm text-center"
                                            style="width:80px;margin:auto;" x-model.number="item.quantity"
                                             @change="updateItemQuantity(idx)" min="1">
                                    </td>
                                    <td x-text="((Number(item.sell_price) || 0) * item.quantity).toFixed(2)"></td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-4">
                <div class="d-flex gap-2 mb-2">
                    <button class="btn btn-outline-secondary btn-sm flex-fill" @click="openDiscountModal">Add Discount
                         [F2]</button>
                    <button class="btn btn-outline-secondary btn-sm flex-fill" @click="openAdditionalChargeModal">Add
                        Charge [F3]</button>
                </div>
                <div class="card p-3 mb-2">
                   <h6>Bill Details</h6>
                    <div class="d-flex justify-content-between">
                        <span>Sub Total (exclude tax)</span>
                        <span>₹ <span x-text="bill.subTotal.toFixed(2)-bill.gstTotal.toFixed(2)"></span></span>
                    </div>
                     <div class="d-flex justify-content-between">
                        <span>GST</span>
                        <span>₹ <span x-text="bill.gstTotal.toFixed(2)"></span></span>
                    </div>
                    <template x-if="bill.discountAmount > 0">
                        <div class="d-flex justify-content-between">
                            <span>Discount</span>
                            <span>- ₹ <span x-text="bill.discountAmount.toFixed(2)"></span></span>
                         </div>
                    </template>
                    <template x-if="bill.additionalCharge > 0">
                        <div class="d-flex justify-content-between">
                             <span>Charge</span>
                            <span>+ ₹ <span x-text="bill.additionalCharge.toFixed(2)"></span></span>
                        </div>
                    </template>
                    <hr>
                    <div class="d-flex justify-content-between fw-bold text-success">
                        <span>Total</span>
                        <span>₹ <span x-text="bill.totalAmount.toFixed(2)"></span></span>
                      </div>
                </div>
<div class="card p-3 mb-2">
    <h6>Wallet Use</h6>
    <div class="form-check mb-2">
        <input class="form-check-input" type="checkbox" id="use_cash_wallet" x-model="bill.useCashWallet"
            @change="calculateAmountPayable"
            :disabled="!bill.customerDetails || bill.customerDetails.cash_wallet_balance <= 0">
        <label class="form-check-label">
            Use Cash Wallet (Bal ₹<span x-text="bill.customerDetails?.cash_wallet_balance.toFixed(2) || '0.00'"></span>)
        </label>
        <small x-show="bill.cashWalletDeduction > 0" class="text-muted">
            Applied ₹<span x-text="bill.cashWalletDeduction.toFixed(2)"></span>
        </small>
    </div>
    <div class="form-check mb-2">
        <input class="form-check-input" type="checkbox" id="use_shopping_wallet"
            x-model="bill.useShoppingWallet" @change="calculateAmountPayable"
            :disabled="!bill.customerDetails || (bill.customerDetails.shopping_wallet_balance <= 0 && bill.totalApplicableShoppingWalletFromItems <= 0)">
        <label class="form-check-label">
            Use Shopping Wallet (Bal ₹<span x-text="bill.customerDetails?.shopping_wallet_balance.toFixed(2) || '0.00'"></span>)
        </label>
        <small x-show="bill.shoppingWalletDeduction > 0" class="text-muted">
            Applied ₹<span x-text="bill.shoppingWalletDeduction.toFixed(2)"></span>
        </small>
        <small x-show="bill.shoppingWalletDeduction === 0 && bill.totalApplicableShoppingWalletFromItems > 0 && !bill.useShoppingWallet" class="text-muted">
            (Applicable ₹<span x-text="bill.totalApplicableShoppingWalletFromItems.toFixed(2)"></span>)
        </small>
    </div>
    <div class="mb-3">
        <label for="payment_mode" class="form-label fw-bold">Select Payment Mode</label>
        <select id="payment_mode" class="form-select" x-model="bill.paymentMode">
            <option value="">--Select--</option>
            <option value="upi">UPI</option>
            <option value="cash">Cash</option>
            <option value="card">Card</option>
        </select>
    </div>
    <div class="d-flex justify-content-between fw-bold">
        <span>Payable</span>
        <span>₹ <span x-text="bill.amountPayable.toFixed(2)"></span></span>
    </div>
</div>
                <div class="d-grid gap-2">
     <button class="btn btn-primary btn-lg" @click="updateAndPrintBill" :disabled="!bill.billItems.length">Update & Print [F6]</button>
    <button class="btn btn-secondary btn-lg" @click="updateBill" :disabled="!bill.billItems.length">Save Changes</button>
</div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="priceChangeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                      <h5>Change Price</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body"><input type="number" class="form-control" x-model.number="tempPrice"></div>
                <div class="modal-footer"><button class="btn btn-primary" @click="confirmChangePrice">Apply</button><button
                        class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button></div>
             </div>
        </div>
    </div>
    <div class="modal fade" id="qtyChangeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Change Quantity</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                  </div>
                <div class="modal-body"><input type="number" class="form-control" x-model.number="tempQty" min="1"></div>
                <div class="modal-footer"><button class="btn btn-primary" @click="confirmChangeQty">Apply</button><button
                        class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button></div>
            </div>
        </div>
    </div>
     <div class="modal fade" id="discountModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Discount</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
              <div class="modal-body"><input type="number" class="form-control mb-2" x-model.number="tempDiscount"
                        placeholder="Amount"><input class="form-control" x-model="tempDiscountNote"
                        placeholder="Reason (opt)"></div>
                <div class="modal-footer"><button class="btn btn-primary" @click="confirmDiscount">Apply</button><button
                      class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button></div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="chargeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Charge</h5><button  class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body"><input type="number" class="form-control mb-2" x-model.number="tempCharge"
                        placeholder="Amount"><input class="form-control" x-model="tempChargeNote"
                        placeholder="Reason (opt)"></div>
               <div class="modal-footer"><button class="btn btn-primary" @click="confirmCharge">Apply</button><button
                        class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button></div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="settingsModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                    <h5>Select Print Type</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                   <div class="form-check">
                        <input class="form-check-input" type="radio" x-model="printType" value="a4"
                            id="print_a4">
                        <label class="form-check-label" for="print_a4">A4 Invoice</label>
                      </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" x-model="printType" value="thermal"
                            id="print_thermal">
                       <label class="form-check-label" for="print_thermal">Thermal (3 inch)</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" @click="saveSettings">Save</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="newCustomerModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Register New Customer</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div  class="mb-3">
                        <label for="new_customer_phone" class="form-label">Phone Number</label>
                        <input type="text" class="form-control" id="new_customer_phone"
                            x-model="newCustomer.phone_number" disabled>
                     </div>
                    <div class="mb-3">
                        <label for="new_customer_name" class="form-label">Name <span
                                class="text-danger">*</span></label>
                       <input type="text" class="form-control" id="new_customer_name" x-model="newCustomer.name">
                    </div>
                    <div class="mb-3">
                        <label for="new_customer_email" class="form-label">Email (Optional)</label>
                          <input type="email" class="form-control" id="new_customer_email"
                            x-model="newCustomer.email">
                    </div>
                </div>
                <div class="modal-footer">
                   <button class="btn btn-primary" @click="confirmNewCustomer">Register</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function posBillingEdit(invoiceData) {
    return {
        // Initial State from Server
        invoice: invoiceData,
        isInitializing: true,
        // **** CHANGED: Store the original deduction amounts separately ****
        originalCashWalletDeduction: Number(invoiceData.cash_wallet_deduction) || 0,
        originalShoppingWalletDeduction: Number(invoiceData.shopping_wallet_deduction) || 0,
        bill: {
            order_id: invoiceData.order_id,
            billItems: invoiceData.sale_items.map(item => ({
                ...item,
                sell_price: Number(item.sell_price || 0),
                purchase_price: Number(item.purchase_price || 0),
                quantity: Number(item.quantity || 1),
                mrp: Number(item.mrp || 0),
                gst: Number(item.gst || 0),
                cgst: Number(item.cgst || 0),
                sgst: Number(item.sgst || 0),
                shopping_wallet_price: Number(item.shopping_wallet_price || 0)
            })),
            customerDetails: invoiceData.customer_details,
            customerIdentifier: invoiceData.customer_details?.phone_number || '',
            customerDetailsLoading: false,
            // Bill Calculation properties
            subTotal: 0,
            gstTotal: 0,
            totalAmount: 0,
            amountPayable: 0,
            cashWalletDeduction: Number(invoiceData.cash_wallet_deduction) || 0,
            shoppingWalletDeduction: Number(invoiceData.shopping_wallet_deduction) || 0,
            totalApplicableShoppingWalletFromItems: 0,
            // User input properties
            discountAmount: Number(invoiceData.discount || 0),
            additionalCharge: Number(invoiceData.additional_charge || 0),
            paymentMode: invoiceData.payment_mode || '',
            useCashWallet: (Number(invoiceData.cash_wallet_deduction) || 0) > 0,
            useShoppingWallet: (Number(invoiceData.shopping_wallet_deduction) || 0) > 0,
            // UI State
            searchQuery: '',
            searchResults: [],
            selectedSearchResultIndex: -1,
            selectedItemIndex: -1,
        },
        // Modal & Settings State
        tempPrice: 0,
        tempQty: 1,
        tempDiscount: 0,
        tempDiscountNote: '',
        tempCharge: 0,
        tempChargeNote: '',
        printType: localStorage.getItem('posPrintType') || 'thermal',
        newCustomer: {
            phone_number: '',
            name: '',
            email: ''
        },
        // Runs when the component is initialized
        init() {
            this.calculateTotals();
            if (this.bill.customerIdentifier) {
                this.fetchCustomerDetails().finally(() => {
                    this.isInitializing = false;
                });
            } else {
                this.isInitializing = false;
            }
        },
        // Recalculates all bill totals from the items list.
        calculateTotals() {
            const bill = this.bill;
            bill.subTotal = bill.billItems.reduce((sum, item) => sum + (item.sell_price * item.quantity), 0);
            bill.gstTotal = bill.billItems.reduce((sum, item) => sum + ((item.cgst + item.sgst) * item.quantity), 0);
            bill.totalAmount = bill.subTotal- bill.discountAmount + bill.additionalCharge;
            bill.totalAmount = Math.max(0, bill.totalAmount);
            this.calculateAmountPayable();
        },
        // Calculates the final payable amount after applying wallet logic.
        calculateAmountPayable() {
            let payable = this.bill.totalAmount;
            this.bill.totalApplicableShoppingWalletFromItems = this.bill.billItems.reduce((sum, item) => {
                return sum + (item.shopping_wallet_price * item.quantity);
            }, 0);
            if (!this.isInitializing) {
                // --- Cash Wallet Recalculation ---
                if (this.bill.useCashWallet && this.bill.customerDetails) {
                    const effectiveCashBalance = Math.max(
                        this.bill.customerDetails.cash_wallet_balance,
                        this.originalCashWalletDeduction
                    );
                    this.bill.cashWalletDeduction = Math.min(payable, effectiveCashBalance);
                } else {
                    this.bill.cashWalletDeduction = 0;
                }
                // --- Shopping Wallet Recalculation ---
                if (this.bill.useShoppingWallet && this.bill.customerDetails) {
                    // **** CHANGED: Use the HIGHER of the current balance or the original deduction ****
                    const effectiveShoppingBalance = Math.max(
                        this.bill.customerDetails.shopping_wallet_balance,
                        this.originalShoppingWalletDeduction
                    );
                    const deduction = Math.min(
                        payable - this.bill.cashWalletDeduction,
                        effectiveShoppingBalance,
                        this.bill.totalApplicableShoppingWalletFromItems
                    );
                    this.bill.shoppingWalletDeduction = deduction;
                } else {
                    this.bill.shoppingWalletDeduction = 0;
                }
            }
            payable = payable - this.bill.cashWalletDeduction - this.bill.shoppingWalletDeduction;
            this.bill.amountPayable = Math.max(0, payable);
        },
        // Toggles wallet usage and recalculates totals
        toggleWalletUsage(walletType) {
            if (walletType === 'cash') {
                this.bill.useCashWallet = !this.bill.useCashWallet;
            } else if (walletType === 'shopping') {
                this.bill.useShoppingWallet = !this.bill.useShoppingWallet;
            }
            this.calculateTotals();
        },
        // ... (The rest of the functions from the previous correct answer remain unchanged) ...
        // ... (selectItem, deleteSelectedItem, fetchCustomerDetails, etc.) ...
        // Selects an item in the bill table
        selectItem(index) {
            this.bill.selectedItemIndex = index;
        },
        // Deletes the currently selected item
        deleteSelectedItem() {
            if (this.bill.selectedItemIndex > -1) {
                this.bill.billItems.splice(this.bill.selectedItemIndex, 1);
                this.bill.selectedItemIndex = -1; // Deselect
                this.calculateTotals();
            }
        },
        async fetchCustomerDetails() {
            if (this.bill.customerIdentifier.length < 3) {
                return;
            }
            this.bill.customerDetailsLoading = true;
            try {
                const response = await fetch('<?php echo e(route("search-customer")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        identifier: this.bill.customerIdentifier
                    })
                });
                if (!response.ok) {
                    const errorText = await response.text();
                    throw new Error(`Server returned status ${response.status}: ${errorText}`);
                }
                const data = await response.json();
                this.bill.customerDetails = data ?? this.bill.customerDetails;
            } catch (error) {
                console.error('Error fetching customer:', error);
                this.bill.customerDetails = this.invoice.customer_details;
            } finally {
                this.bill.customerDetailsLoading = false;
            }
        },
        async searchProducts() {
            const q = this.bill.searchQuery.trim();
            if (!q) {
                this.bill.searchResults = [];
                return;
            }
            try {
                const res = await fetch(`<?php echo e(route('search-products')); ?>`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ query: q })
                });
                const results = await res.json();
                this.bill.searchResults = results;
                this.bill.selectedSearchResultIndex = 0;
                const exactMatch = results.find(prod => prod.item_code.toLowerCase() === q.toLowerCase());
                if (exactMatch) {
                    this.addItemToBill(exactMatch);
                    this.clearSearchResults();
                }
            } catch (e) {
                console.error("Error searching products:", e);
                this.bill.searchResults = [];
            }
        },
        addItemToBill(prod) {
            if (Number(prod.stock || 0) <= 0) {
                this.showToast(`"${prod.name}" is out of stock and cannot be added to the bill.`);
                return;
            }
            const existingItem = this.bill.billItems.find(
                item => item.item_identifier === prod.item_identifier && item.type === prod.type
            );
            if (existingItem) {
                existingItem.quantity++;
            } else {
                this.bill.billItems.unshift({
                    ...prod,
                    quantity: 1,
                    sell_price: Number(prod.sell_price || 0),
                    purchase_price: Number(prod.purchase_price || 0),
                    gst: Number(prod.gst || 0),
                    shopping_wallet_price: Number(prod.shopping_wallet_price || 0)
                });
            }
            this.clearSearchResults?.();
            this.calculateTotals?.();
        },
        showToast(message) {
            const toastMessage = document.getElementById('stockToastMessage');
            const toastElement = document.getElementById('stockToast');
            if (toastMessage && toastElement) {
                toastMessage.innerText = message;
                const toast = new bootstrap.Toast(toastElement, {
                    delay: 3000,
                    autohide: true
                });
                toast.show();
            }
        },
        clearSearchResults() {
            this.bill.searchQuery = '';
            this.bill.searchResults = [];
            this.bill.selectedSearchResultIndex = 0;
        },
        openPriceChangeModal() {
            if (this.bill.selectedItemIndex === -1) return;
            this.tempPrice = this.bill.billItems[this.bill.selectedItemIndex].sell_price;
            new bootstrap.Modal(document.getElementById('priceChangeModal')).show();
        },
        confirmChangePrice() {
            if (this.bill.selectedItemIndex !== -1 && this.tempPrice > 0) {
                const item = this.bill.billItems[this.bill.selectedItemIndex];
                item.sell_price = Number(this.tempPrice);
                this.calculateTotals();
            }
            bootstrap.Modal.getInstance(document.getElementById('priceChangeModal')).hide();
        },
        openQuantityChangeModal() {
            if (this.bill.selectedItemIndex === -1) return;
            this.tempQty = this.bill.billItems[this.bill.selectedItemIndex].quantity;
            new bootstrap.Modal(document.getElementById('qtyChangeModal')).show();
        },
        confirmChangeQty() {
            if (this.bill.selectedItemIndex !== -1 && this.tempQty > 0) {
                this.bill.billItems[this.bill.selectedItemIndex].quantity = Number(this.tempQty);
                this.calculateTotals();
            }
            bootstrap.Modal.getInstance(document.getElementById('qtyChangeModal')).hide();
        },
        openDiscountModal() {
            this.tempDiscount = this.bill.discountAmount;
            this.tempDiscountNote = this.bill.discountNote || '';
            new bootstrap.Modal(document.getElementById('discountModal')).show();
        },
        confirmDiscount() {
            this.bill.discountAmount = Number(this.tempDiscount);
            this.bill.discountNote = this.tempDiscountNote;
            this.calculateTotals();
            bootstrap.Modal.getInstance(document.getElementById('discountModal')).hide();
        },
        openAdditionalChargeModal() {
            this.tempCharge = this.bill.additionalCharge;
            this.tempChargeNote = this.bill.additionalChargeNote || '';
            new bootstrap.Modal(document.getElementById('chargeModal')).show();
        },
        confirmCharge() {
            this.bill.additionalCharge = Number(this.tempCharge);
            this.bill.additionalChargeNote = this.tempChargeNote;
            this.calculateTotals();
            bootstrap.Modal.getInstance(document.getElementById('chargeModal')).hide();
        },
        openSettings() { new bootstrap.Modal(document.getElementById('settingsModal')).show(); },
        saveSettings() {
            localStorage.setItem('posPrintType', this.printType);
            bootstrap.Modal.getInstance(document.getElementById('settingsModal')).hide();
        },
        handleGlobalKeys(event) {
            const activeEl = document.activeElement;
            if (['INPUT', 'TEXTAREA', 'SELECT'].includes(activeEl.tagName)) {
                if (activeEl === this.$refs.searchInput) {
                    // Handle search input specific keys if needed
                } else {
                    return;
                }
            }
            if (event.ctrlKey) {
                if (event.key.toLowerCase() === 's') { event.preventDefault(); this.openSettings(); }
                if (event.key.toLowerCase() === 'p') { event.preventDefault(); this.openPriceChangeModal(); }
                if (event.key.toLowerCase() === 'q') { event.preventDefault(); this.openQuantityChangeModal(); }
            } else {
                switch (event.key) {
                    case 'F1': event.preventDefault(); this.$refs.searchInput.focus(); break;
                    case 'F2': event.preventDefault(); this.openDiscountModal(); break;
                    case 'F3': event.preventDefault(); this.openAdditionalChargeModal(); break;
                    case 'F6': event.preventDefault(); this.updateAndPrintBill(); break;
                    case 'Delete': event.preventDefault(); this.deleteSelectedItem(); break;
                    case 'Escape': event.preventDefault(); window.history.back(); break;
                }
            }
        },
        handleSearchEnter() {
            if (this.bill.searchResults.length > 0 && this.bill.selectedSearchResultIndex > -1) {
                const product = this.bill.searchResults[this.bill.selectedSearchResultIndex];
                this.addItemToBill(product);
            }
        },
        selectNextResult() {
            const max = this.bill.searchResults.length - 1;
            if (max > -1) {
                this.bill.selectedSearchResultIndex = Math.min(this.bill.selectedSearchResultIndex + 1, max);
            }
        },
        selectPrevResult() {
            if (this.bill.searchResults.length > 0) {
                this.bill.selectedSearchResultIndex = Math.max(this.bill.selectedSearchResultIndex - 1, 0);
            }
        },
        updateItemQuantity(idx) {
            if (this.bill.billItems[idx].quantity < 1) {
                this.bill.billItems[idx].quantity = 1;
            }
            this.calculateTotals();
        },
        updateAndPrintBill() {
            this.updateBill(true);
        },
        async updateBill(print = false) {
            this.calculateTotals();
            const b = this.bill;
            if (b.billItems.length === 0) {
                this.showMessage('Cannot update an empty invoice. Please add items.', 'warning');
                return;
            }
            if (!b.paymentMode) {
                this.showMessage('Please select a payment mode.', 'warning');
                return;
            }
            const customerDetailsToSend = b.customerDetails ? {
                name: b.customerDetails.name,
                user_id: b.customerDetails.user_id,
                phone_number: b.customerDetails.phone_number,
                email: b.customerDetails.email || null,
                address: b.customerDetails.address || 'N/A',
                cash_wallet_balance: b.customerDetails.cash_wallet_balance, 
                shopping_wallet_balance: b.customerDetails.shopping_wallet_balance,
            } : null;
            const payload = {
                order_id: b.order_id || null,
                user_id: b.customerDetails?.user_id || null,
                customer_details: customerDetailsToSend,
                bill_items: b.billItems.map(item => ({
                    item_identifier: item.item_identifier,
                    product_id_main: item.product_id_main || null,
                    type: item.type,
                    name: item.name,
                    item_code: item.item_code,
                    mrp: item.mrp,
                    sell_price: item.sell_price,
                    purchase_price: item.purchase_price,
                    quantity: item.quantity,
                    gst: item.gst,
                    cgst: item.cgst,
                    sgst: item.sgst,
                    gst_price: item.gst_price,
                    shopping_wallet_price: item.shopping_wallet_price || 0,
                })),
                sub_total: b.subTotal,
                gst_total: b.gstTotal,
                discount_amount: b.discountAmount,
                additional_charge: b.additionalCharge,
                total_amount: b.totalAmount,
                use_cash_wallet: b.useCashWallet,
                use_shopping_wallet: b.useShoppingWallet,
                cash_wallet_deduction: b.cashWalletDeduction,
                shopping_wallet_deduction: b.shoppingWalletDeduction,
                amount_payable: b.amountPayable,
                payment_mode: b.paymentMode,
                payment_received: b.paymentReceived ?? 0,
                change_amount: b.changeAmount ?? 0,
                sold_by: b.soldBy,
                description: (b.discountAmount > 0 || b.additionalCharge > 0) ? (b.tempDiscountNote || b.tempChargeNote || 'N/A') : null
            };
            try {
                const response = await fetch(`/admin/update_invoice/${b.order_id}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    },
                    body: JSON.stringify(payload),
                });
                if (!response.ok) {
                    let errorText = 'Failed to update invoice.';
                    const contentType = response.headers.get("content-type");
                    if (contentType && contentType.indexOf("application/json") !== -1) {
                        const error = await response.json();
                        errorText = error.message || errorText;
                    } else {
                        errorText = `Server error: ${response.status} ${response.statusText}. Please check the server logs.`;
                    }
                    throw new Error(errorText);
                }
                const result = await response.json();
                const updatedOrderId = result.order_id;
                if (print) {
                    const printRoute = this.printType === 'a4'
                        ? '<?php echo e(route("invoice_a4", ["orderId" => ":orderId"])); ?>'
                        : '<?php echo e(route("invoice_thermal", ["orderId" => ":orderId"])); ?>';
                    window.location.href = printRoute.replace(':orderId', updatedOrderId);
                } else {
                    this.showMessage('Invoice updated successfully!', 'success');
                }
            } catch (error) {
                console.error('Update failed:', error);
                this.showMessage(error.message || 'An unexpected error occurred. Please try again.', 'danger');
            }
        },
deleteSelectedItem() {
    if (this.bill.selectedItemIndex > -1) {
        this.bill.billItems.splice(this.bill.selectedItemIndex, 1);
        this.bill.selectedItemIndex = -1;
        if (this.bill.billItems.length === 0) {
            this.deleteEmptyInvoice();
        } else {
            this.calculateTotals();
        }
    }
},
async deleteEmptyInvoice() {
    if (!this.bill.order_id) {
        this.showMessage('No invoice to delete.', 'warning');
        return;
    }
    try {
        const response = await fetch(`/admin/delete_invoice/${this.bill.order_id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        });
        if (!response.ok) {
            throw new Error('Failed to delete the invoice on the server.');
        }
        // --- Use your showToast function here ---
        this.showToast('Invoice deleted successfully.');
        // Redirect after showing the toast. You might want to add a short delay here.
        setTimeout(() => {
            window.location.href = 'https://adbazzar.com/admin/offline_sales_history';
        }, 1000); // 1-second delay to let the user see the toast.
    } catch (error) {
        console.error('Invoice deletion failed:', error);
        // showMessage is still useful for handling errors
        this.showMessage(error.message || 'An error occurred while deleting the invoice.', 'danger');
    }
},
        showMessage(message, type = 'info') {
            console.log(`[${type.toUpperCase()}]: ${message}`);
            // You can replace this with a more user-friendly notification system
            alert(`[${type.toUpperCase()}] ${message}`);
        }
    };
}
</script>

<?php /**PATH /var/www/adbazzar.com/resources/views/admin/edit_invoice.blade.php ENDPATH**/ ?>