<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Register | Adbazzar</title>
    <link rel="icon" href="<?php echo e(asset('/assets')); ?>/images/adbazzar-logo.png.svg" type="image/x-icon">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/bootstrap/5.3.2/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets')); ?>/css/icons/fontawesome/css/fontawesome.css">
    <link rel="stylesheet" href="<?php echo e(asset('/assets')); ?>/css/icons/fontawesome/css/brands.css">
    <link rel="stylesheet" href="<?php echo e(asset('/assets')); ?>/css/icons/fontawesome/css/regular.css">
    <link rel="stylesheet" href="<?php echo e(asset('/assets')); ?>/css/icons/fontawesome/css/solid.css">

    <!-- Page CSS -->
    
    <link rel = "stylesheet" type = "text/css" href = "<?php echo e(asset('/assets')); ?>/css/authentication.css">

    <!-- SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* html,
        body {
            overflow-x: hidden;
            height: 100%;
        } */

        .form-container {
            overflow-y: auto;
            max-height: 100vh;
            -webkit-overflow-scrolling: touch;
        }
        ::-webkit-scrollbar {
    display: none;
}

        input,
        select,
        textarea {
            font-size: 16px;
            /* Prevent zoom-in on iOS */
        }

        button {
            position: relative;
            z-index: 10;
        }

        .logo-widget {
            background: #D4EFFF;
            background-size: cover !important;
        }

        #otp-actions {
            display: none;
            opacity: 0;
            position: relative;
            bottom: -20px;
            transition: opacity 0.5s ease-in-out, bottom 0.5s ease-in-out;
        }

        #otp-actions.show {
            opacity: 1;
            bottom: 0;
        }

        #otp-success-message {
            color: black;
            /* Default text color */
            font-weight: bold;
            /* Make text bold */
            margin-top: 10px;
            /* Space above the message */
        }

        #otp-error-message {
            color: black;
            /* Default text color */
            font-weight: bold;
            /* Make text bold */
            margin-top: 10px;
            /* Space above the message */
        }

        #otp-success-message.success {
            color: green;
            /* Success message color */
        }

        #otp-success-message.error {
            color: red;
            /* Error message color */
        }
    </style>

</head>

<body>
    <div class="page-content login-container">
        <div class="row g-0">
            <div class="col-xl-5 col-lg-5 col-md-6 col-sm-12 rightside-widget-col">
                <div class="p-lg-5 p-4 h-100 logo-widget">
                    <div class="d-flex justify-content-center align-items-center h-100">
                        <div class="">
                            <img src="<?php echo e(asset('/assets')); ?>/images/login-frame.svg" style="height:400px;"
                                class="inframe-logo" alt="logo frame">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-7 col-lg-7 col-md-6 col-sm-12 d-flex justify-content-center align-items-center">
                <div class="py-3 px-lg-5 px-md-4 px-sm-4 px-4 form-container row">
                    <div class="d-flex justify-content-center mb-1">
                        <img src="<?php echo e(asset('/assets')); ?>/images/logo-horizontal.svg" class=" d-none widget-logo"
                            alt="logo-horizontal">
                    </div>
                    <div class="text-start">
                        <h3 class="login-heading">Register</h3>
                        <p class="py-2 login-slogan">Please fill your information below</p>
                    </div>

                    <form action="<?php echo e(route('register_form')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <!-- Name Input -->
                        <label for="referral_id" class="form-label">Referral ID</label>

                        <div class="input-group mb-4">
                            <input type="text" name="referral_id" id="referral_id" class="form-control"
                                value="<?php echo e($referralId); ?>" readonly>
                        </div>



                        <!-- Name Input -->
                        <label for="name" class="form-label">Full Name</label>
                        <div class="input-group mb-4">
                            <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                        </div>

                        <!-- Phone Number Input -->
                        <label for="phone_number" class="form-label">Phone Number</label>
                        <div class="input-group mb-4">
                            <input type="number" name="phone_number" class="form-control"
                                placeholder="Enter Phone Number" required>
                        </div>

                        <!-- Email Input -->
                        <label for="email" class="form-label">Email</label>
                        <div class="input-group mb-4">
                            <input type="email" name="email" class="form-control" value=""
                                placeholder="E-mail" required>
                        </div>

                        <!-- Password Input -->
                        <label for="password" class="form-label">Password</label>
                        <div class="input-group mb-3 position-relative">
                            <span class="input-group-text">
                                <img src="<?php echo e(asset('/assets')); ?>/images/icons/lock.svg" alt="Lock Icon">
                            </span>
                            <input type="password" name="password" id="password" class="form-control"
                                placeholder="Password" required>
                            <span class="toggle-password position-absolute"
                                style="right: 20px; top: 50%; transform: translateY(-50%); cursor: pointer;">
                                <i class="fa-solid fa-eye-slash" id="togglepassword"
                                    onclick="togglePassword('password', 'togglepassword')"></i>
                            </span>
                        </div>

                        <!-- Confirm Password Input -->
                        <label for="confirm_password" class="form-label">Confirm Password</label>
                        <div class="input-group mb-3 position-relative">
                            <span class="input-group-text">
                                <img src="<?php echo e(asset('/assets')); ?>/images/icons/lock.svg" alt="Lock Icon">
                            </span>
                            <input type="password" name="confirm_password" id="con_password" class="form-control"
                                placeholder="Confirm Password" required>
                            <span class="toggle-password position-absolute"
                                style="right: 20px; top: 50%; transform: translateY(-50%); cursor: pointer;">
                                <i class="fa-solid fa-eye-slash" id="toggleConfirmPassword"
                                    onclick="togglePassword('con_password', 'toggleConfirmPassword')"></i>
                            </span>
                        </div>

                        <!-- Submit Button -->
                        <div class="login-btn-container mt-2">
                            <button type="submit" class="btn btn-success login-btn w-100">Register</button>
                        </div>
                    </form>

                    <!-- Form Ends -->
                </div>
            </div>
        </div>
    </div>

    
    <!-- Success Toast -->
    <?php if(session('successmessage')): ?>
        <div id="success-toast" class="toast bg-success align-items-center border-0 show" role="alert"
            aria-live="assertive" aria-atomic="true"
            style="position: fixed; top: 150px; right: 20px; z-index: 1050; border-radius: 8px;">
            <div class="toast-body d-flex text-white align-items-center">
                <i class="fa-regular fa-circle-check" style="font-size: 20px; margin-right: 10px;"></i>
                <div>
                    <?php echo e(session('successmessage')); ?>

                </div>
                <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast"
                    aria-label="Close"></button>
            </div>
        </div>
    <?php endif; ?>


    <?php if(session('success')): ?>
        <div id="success-toast" class="toast bg-success align-items-center border-0 show" role="alert"
            aria-live="assertive" aria-atomic="true"
            style="position: fixed; top: 150px; right: 20px; z-index: 1050; border-radius: 8px;">
            <div class="toast-body d-flex text-white align-items-center">
                <i class="fa-regular fa-circle-check" style="font-size: 20px; margin-right: 10px;"></i>
                <div>
                    <?php echo e(session('success')); ?>

                </div>
                <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast"
                    aria-label="Close"></button>
            </div>
        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div id="error-toast" class="toast bg-danger align-items-center border-0 show" role="alert"
            aria-live="assertive" aria-atomic="true"
            style="position: fixed; top: 80px; right: 20px; z-index: 1050; border-radius: 8px;">
            <div class="toast-body d-flex text-white align-items-center">
                <i class="fa-solid fa-circle-exclamation" style="font-size: 20px; margin-right: 10px;"></i>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast"
                    aria-label="Close"></button>
            </div>
        </div>
    <?php endif; ?>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var successToastEl = document.getElementById("success-toast");
            var errorToastEl = document.getElementById("error-toast");

            if (successToastEl) {
                var successToast = new bootstrap.Toast(successToastEl);
                successToast.show();
            }

            if (errorToastEl) {
                var errorToast = new bootstrap.Toast(errorToastEl);
                errorToast.show();
            }
        });
    </script>





    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/authentication.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/bootstrap/5.3.2/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            // Function to toggle password visibility
            function togglePassword(passwordFieldId, toggleIconId) {
                const passwordField = document.getElementById(passwordFieldId);
                const toggleIcon = document.getElementById(toggleIconId);

                if (passwordField.type === "password") {
                    passwordField.type = "text"; // Show password
                    toggleIcon.classList.remove("fa-eye-slash");
                    toggleIcon.classList.add("fa-eye");
                } else {
                    passwordField.type = "password"; // Hide password
                    toggleIcon.classList.remove("fa-eye");
                    toggleIcon.classList.add("fa-eye-slash");
                }
            }

            // Attach the togglePassword function to the click event of the toggle icon
            document.getElementById('togglepassword').addEventListener('click', function() {
                togglePassword('password', 'togglepassword');
            });
        });
    </script>
</body>

</html>
<?php /**PATH /var/www/adbazzar.com/resources/views/admin/register.blade.php ENDPATH**/ ?>