
<?php $__env->startSection('title', 'User Profile'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="col-md-12">
                <h3 class="page-top-heading">User Profile</h3>
                   <td>
    <a href="<?php echo e(route('user_purchase_history', ['user_id' => $user->user_id])); ?>" class="btn btn-sm btn-primary">
        Purchase History
    </a>
</td>
            </div>
        </div>
        <div class="row mt-4">
            <!-- Personal Information -->
            <div class="col-lg-8">
                <div class="card p-3">
                    <div class="card-body">
                        <?php
                        $currentAddress = \App\Models\Address::getCurrentAddress($user->id);
                    ?>
                        <h4>Personal Information</h4>
                        <p><strong>Name:</strong> <?php echo e($user->name); ?></p>
                        <p><strong>Email:</strong> <?php echo e($user->email); ?></p>
                        <p><strong>Phone Number:</strong> <?php echo e($user->phone_number); ?></p>
                        <p><strong>User ID:</strong> <?php echo e($user->user_id); ?></p>
                        <p><strong>Address:</strong>
                                <?php if($currentAddress && ($currentAddress->building_name || $currentAddress->road_name || $currentAddress->landmark || $currentAddress->district || $currentAddress->state || $currentAddress->pin)): ?>
                                    <?php echo e($currentAddress->building_name ?? ''); ?>

                                    <?php if($currentAddress->road_name): ?>
                                        , <?php echo e($currentAddress->road_name); ?>

                                    <?php endif; ?>
                                    <?php if($currentAddress->landmark): ?>
                                        , <?php echo e($currentAddress->landmark); ?>

                                    <?php endif; ?>
                                    <?php if($currentAddress->district): ?>
                                        , <?php echo e($currentAddress->district); ?>

                                    <?php endif; ?>
                                    <?php if($currentAddress->state): ?>
                                        , <?php echo e($currentAddress->state); ?>

                                    <?php endif; ?>
                                    <?php if($currentAddress->pin): ?>
                                        - <?php echo e($currentAddress->pin); ?>

                                    <?php endif; ?>
                                <?php else: ?>
                                    Address not available
                                <?php endif; ?>
                        </p>
                        <p><strong>Joining Date:</strong><?php echo e($user->created_at); ?></p>
                        <a href="<?php echo e(route('toggle_activation', $user->id)); ?>"
                            class="btn <?php echo e($user->is_active ? 'btn-danger' : 'btn-success'); ?>">
                            <i class="fa <?php echo e($user->is_active ? 'fa-user-times' : 'fa-user-check'); ?>"></i>
                            <?php echo e($user->is_active ? 'Deactivate Account' : 'Activate Account'); ?>

                        </a>
                        <a href="<?php echo e(route('edit_user', ['id' => $user->id])); ?>" class="btn btn-warning">
                            <i class="fa fa-key"></i> Edit Account
                        </a>
                    </div>
                </div>
                <!-- Wallet Information -->
                <div class="card p-4 mt-3">
                    <div class="card-body">
                        <h4>Wallet Information</h4>
                        <p>
                            <strong>Cash Wallet Balance:</strong> ₹<?php echo e($incomeWallet->cash_wallet ?? '0.00'); ?>

                            <a href="<?php echo e(route('edit_cashwallet', ['id' => $user->id])); ?>" class="text-primary">
                                ✏️
                            </a>
                        </p>
                        <p>
                            <strong>Shopping Wallet Balance:</strong> ₹<?php echo e($incomeWallet->shopping_wallet ?? '0.00'); ?>

                            <a href="<?php echo e(route('edit_shoppingwallet', ['id' => $user->id])); ?>" class="text-primary">
                                ✏️
                            </a>
                        </p>
                    </div>
                </div>
            </div>
            <?php if($user->is_subscribed): ?>
            
                <div class="col-lg-4">
                    <div class="card p-3">
                        <div class="card-body">
                            <h4>Membership Details</h4>
                            
                            <div class="Membership-details d-flex flex-column align-items-center justify-content-center">
                                <img src="<?php echo e(asset('/assets')); ?>/images/member.svg" width="150" height="150" alt="member">
                                <p><strong>Plan Name:</strong> <?php echo e($membership->title ?? 'not subscribed'); ?></p>
                                <p><strong>User ID:</strong> <?php echo e($user->user_id); ?></p>
                                <p><strong>Membership ID:</strong> <?php echo e($user->membership); ?></p>
                            <p><strong>Under User ID:</strong> <?php echo e($user->referral_id ?? 'AdBazzar'); ?></p>
                            <p><strong>Status:</strong>
                                <span class="badge <?php echo e($user->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </p>
                            

                            <p><strong>Expiry Date:</strong>
    <?php echo e($expiryDate->format('d/m/Y')); ?>

</p>

<p><strong>Remaining Days:</strong>
    <?php echo e($remainingDays > 0 ? $remainingDays . ' Days' : 'Expired'); ?>

</p>
                        </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
<!-- Subscription History -->
<?php if(!$subscriptions->isEmpty()): ?>
    <div class="card p-3 mt-3">
        <div class="card-body">
            <h4>Subscription History</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Plan Name</th>
                        <th>Status</th>
                        <th>Subscribed On</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($subscription->title ?? 'N/A'); ?></td>
                            <td>
                                <span class="badge <?php echo e($subscription->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e($subscription->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($subscription->created_at)->format('d-m-Y')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php else: ?>
    <p class="text-center mt-3">No subscriptions found.</p>
<?php endif; ?>
            <div class="container mt-4">
                <h2 class="text-center">Team</h2>
                <div class="d-flex justify-content-between mb-3">
                    <div>
                        <label>Show
                            <select id="entries" class="form-select d-inline-block w-auto">
                                <option value="10">10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                            </select>
                            Entries
                        </label>
                    </div>
                    <input type="text" id="search" class="form-control w-25" placeholder="Search">
                </div>
                <div>
                    <table class="table table-bordered table-striped" id="teamTable">
                        <thead class="table">
                            <tr>
                                <th>S/N</th>
                                <th>User ID</th>
                                <th>Name</th>
                                <th>Membership</th>
                                <th>Phone No</th>
                                <th>Created At</th>
                                <th>Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $referredUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($user->user_id); ?></td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td>  <?php echo e($user->membershipRelation ? $user->membershipRelation->title : '-'); ?></td>
                                    <td><?php echo e($user->phone_number); ?></td>
                                   <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d-m-Y')); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($user->subscription_end_date)->format('d-m-Y')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/view_orders.blade.php ENDPATH**/ ?>