<?php $__env->startSection('title', 'Category'); ?>
<?php $__env->startSection('header'); ?>

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Category</h3>
            <a type="button" href="<?php echo e(route('add_category')); ?>" class="btn btn-primary feature-btn"><i class="fa-solid fa-circle-plus me-2"></i>Add Category</a>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card datatable-card">
                <div class="card-body">
                   
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>SN</th>
                                
                                <th>NAME</th>
                                <th>IMAGE PREVIEW</th>
                                <th>TYPE</th>
                                <th>ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                
                                <td>
                                    <?php if($category->category_type == 1): ?>
                                        <?php echo e($category->category_name); ?>

                                    <?php elseif($category->category_type == 2): ?>
                                        <?php echo e($category->subcategory_name); ?>

                                        (Linked to: <?php echo e(optional($category->parentCategory)->category_name ?? 'N/A'); ?>)
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($category->category_img): ?>
                                        <img src="<?php echo e(asset($category->category_img)); ?>" class="preview-td-img" alt="preview image" style="width: 100px; height: auto;">
                                    <?php else: ?>
                                        No Image
                                    <?php endif; ?>
                                </td>
                               
                                <td><?php echo e($category->category_type == 1 ? 'Category' : 'SubCategory'); ?></td>
                                <td>
                                    <a href="<?php echo e(route('view_category', ['id' => $category->id])); ?>" class="btn transparent-btn text-info text-decoration-underline">Edit</a>
                                   
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModal-<?php echo e($category->id); ?>" class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- Table Row Ends -->
</div>
<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade zoom-in" id="DeleteModal-<?php echo e($category->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="p-3">
                            <div class="text-center">
                                <img class="mb-3" src="<?php echo e(asset('/assets')); ?>/images/icons/delete-icon.svg">
                                <p class="my-4 are-you-sure">Are You Sure?</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete this <?php echo e($category->name); ?>?</p>
                            </div>
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                                <a href="<?php echo e(route('category_delete', $category->id)); ?>" class="btn btn-primary yes-btn">
                                    <i class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


<!-- Datatable JS -->
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>



<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/category.blade.php ENDPATH**/ ?>