<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #<?php echo e($myPurchase->invoice_number); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" media="all">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 20px;
        }
        .invoice-container {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            margin: auto;
            padding: 40px;
        }
        .invoice-header {
            border-bottom: 3px solid #4CAF50;
            margin-bottom: 30px;
            padding-bottom: 20px;
        }
        .invoice-header h2 {
            color: #4CAF50;
            margin-bottom: 10px;
        }
        .company-info {
            font-size: 14px;
            color: #333;
        }
        .invoice-meta {
            font-size: 14px;
            line-height: 1.8;
        }
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .invoice-table th,
        .invoice-table td {
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
        }
        .invoice-table th {
            background-color: #f8f9fa;
            text-transform: uppercase;
            font-size: 13px;
        }
        .summary-section p {
            margin: 5px 0;
            font-size: 14px;
        }
        .summary-section h4 {
            color: #007b00;
            font-weight: bold;
        }
        .invoice-footer {
            font-size: 12px;
            color: #777;
            text-align: center;
            margin-top: 40px;
            border-top: 1px solid #e0e0e0;
            padding-top: 10px;
        }
        @media print {
            body {
                background: #fff !important;
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            .invoice-container {
                box-shadow: none;
                margin: 0;
                padding: 0;
                border-radius: 0;
            }
            .no-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-header d-flex justify-content-between align-items-start flex-wrap">
            <div>
                <h2>
                    <?php if(!empty($branchInfo['logo'])): ?>
                        <img src="<?php echo e($branchInfo['logo']); ?>" alt="Logo" width="100">
                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                    <?php echo e($branchInfo['name']); ?>

                </h2>
                <div class="company-info">
                    <?php echo e($branchInfo['address']); ?><br>
                    Phone: <?php echo e($branchInfo['phone']); ?><br>
                    Email: <?php echo e($branchInfo['email']); ?>

                </div>
            </div>
            <div class="text-end mt-3 mt-lg-0">
                <h4 class="text-uppercase">Purchase Invoice</h4>
                <strong>Invoice No:</strong> <?php echo e($myPurchase->invoice_number); ?><br>
                <strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($myPurchase->purchase_date)->format('d-M-Y')); ?>

            </div>
        </div>
        <div class="row mb-4">
            <div class="col-md-6 invoice-meta">
                <strong>Supplier:</strong> <?php echo e($myPurchase->purchaseParty->customer_name ?? 'N/A'); ?><br>
                <?php if($myPurchase->purchaseParty->phone_number ?? false): ?>
                    <strong>Phone:</strong> <?php echo e($myPurchase->purchaseParty->phone_number); ?><br>
                <?php endif; ?>
                <?php if($myPurchase->purchaseParty->address ?? false): ?>
                    <strong>Address:</strong> <?php echo e($myPurchase->purchaseParty->address); ?>

                <?php endif; ?>
            </div>
        </div>
        <table class="invoice-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Item</th>
                    <th>Item Code</th>
                    <th>HSN Code</th>
                    <th>Purchase Price</th>
                    <th>S.P</th>
                    <th>Qty</th>
                    <th>GST (%)</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $myPurchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($item->product->title ?? 'N/A'); ?></td>
                        <td><?php echo e($item->product->item_code ?? '-'); ?></td>
                        <td><?php echo e($item->product->hsn_code ?? '-'); ?></td>
                        <td>₹<?php echo e(number_format($item->purchase_price, 2)); ?></td>
                        <td>₹<?php echo e(number_format($item->sell_price, 2)); ?></td>
                        <td><?php echo e($item->quantity); ?></td>
                        <td><?php echo e(number_format($item->gst_percentage ?? 0, 2)); ?></td>
                        <td>₹<?php echo e(number_format($item->quantity * $item->purchase_price, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="row">
            <div class="col-md-7">
                <p><strong>Thank you for purchasing from us!</strong></p>
            </div>
            <div class="col-md-5">
                <div class="summary-section">
                    <p><strong>Sub Total (Excl. GST):</strong>
                        ₹<?php echo e(number_format($myPurchase->sub_total_excluding_gst, 2)); ?></p>
                    <?php if(auth()->user()->role == 'admin' && $is_gst == 1): ?>
                        <p><strong>Tax:</strong> ₹<?php echo e(number_format($myPurchase->gst_total, 2)); ?></p>
                    <?php else: ?>
                        <p><strong>CGST:</strong> ₹<?php echo e(number_format($myPurchase->gst_total / 2, 2)); ?></p>
                        <p><strong>SGST:</strong> ₹<?php echo e(number_format($myPurchase->gst_total / 2, 2)); ?></p>
                    <?php endif; ?>
                    <?php if($myPurchase->discount_amount > 0): ?>
                        <p><strong>Discount:</strong> -₹<?php echo e(number_format($myPurchase->discount_amount, 2)); ?></p>
                        <?php if($myPurchase->discount_note): ?>
                            <p><em><?php echo e($myPurchase->discount_note); ?></em></p>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if($myPurchase->additional_charge > 0): ?>
                        <p><strong>Additional Charge:</strong> +₹<?php echo e(number_format($myPurchase->additional_charge, 2)); ?>

                        </p>
                        <?php if($myPurchase->additional_charge_note): ?>
                            <p><em><?php echo e($myPurchase->additional_charge_note); ?></em></p>
                        <?php endif; ?>
                    <?php endif; ?>
                    <hr>
                    <h4><strong>Total Payable:</strong> ₹<?php echo e(number_format($myPurchase->total_amount, 2)); ?></h4>
                </div>
            </div>
        </div>
        <div class="invoice-footer">
            For any queries, please contact our purchase department.
        </div>
    </div>
</body>
</html>
<?php /**PATH /var/www/adbazzar.com/resources/views/admin/invoice_a4_purchase.blade.php ENDPATH**/ ?>