
<?php $__env->startSection('title', 'Profile'); ?>

<?php $__env->startSection('header'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid page-wrapper">

    <h3 class="page-top-heading mb-4">Profile</h3>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card ILY-form-card">
                <div class="card-body">

                    <form action="<?php echo e(route('profile_update')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <!-- Profile Image -->
                        <div class="text-center mt-2 mb-3">
                            <div class="profile-img-wrapper"
                                style="width:140px;height:140px;border-radius:50%;overflow:hidden;margin:auto;">
                                <img src="<?php echo e($user->logo ? asset($user->logo) : asset('/assets/images/avatar/profile.png')); ?>"
                                     id="profile-img-view" style="width:100%;height:100%;object-fit:cover;">
                            </div>
                        </div>

                        <!-- Upload Input -->
                        <div class="col-lg-12 mb-4 text-center">
                            <input type="file" name="logo" id="profile-img-input"
                                class="form-control w-50 mx-auto">
                            <small class="text-muted d-block mt-1">Upload New Image</small>
                        </div>

                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Admin ID</label>
                                <input type="text" class="form-control" value="<?php echo e($user->user_id); ?>" readonly>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" class="form-control"
                                       value="<?php echo e(old('name',$user->name)); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control"
                                       value="<?php echo e(old('email',$user->email)); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" name="phone_number" class="form-control"
                                       value="<?php echo e(old('phone_number',$user->phone_number)); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label">Address</label>
                                <input type="text" name="building_name" class="form-control"
                                       value="<?php echo e(old('building_name',$user->building_name)); ?>">
                            </div>

                            <div class="col-lg-6 mb-4">
                                <label class="form-label">GST Number</label>
                                <input type="text" name="gst_number" class="form-control"
                                       value="<?php echo e(old('gst_number',$user->gst_number)); ?>">
                            </div>

                            <div class="text-center">
                                <button class="btn btn-primary px-4">
                                    <i class="fa-regular fa-circle-check me-2"></i> Update Profile
                                </button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('profile-img-input').onchange = function(e){
    document.getElementById('profile-img-view').src = URL.createObjectURL(e.target.files[0]);
};
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/profile.blade.php ENDPATH**/ ?>