
<?php $__env->startSection('title', 'Notification'); ?>

<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/dataTables.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/responsive.bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/buttons.dataTables.min.css')); ?>">

    <!-- Page CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="d-flex align-items-center justify-content-between">
            <h3 class="page-top-heading">Contact Us</h3>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <h5 class="card-title">Add Contact</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('contact_submit')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <label for="phone_number" class="form-label">Phone Number <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="phone_number" id="phone_number" required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="wtsapp_number" class="form-label">WhatsApp Number <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="wtsapp_number" id="wtsapp_number" required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" id="email" required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="company_address" class="form-label">Company Address <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="company_address" id="company_address"
                                    required>
                            </div>
                            <div class="mt-3 text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-paper-plane me-2"></i>Submit
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact List Table -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="mb-3">
                    <h6 class="table-heading">History</h6>
                </div>
                <div class="card datatable-card">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>Phone</th>
                                    <th>WhatsApp</th>
                                    <th>Email</th>
                                    <th>Company Address</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($contact->phone_number); ?></td>
                                        <td><?php echo e($contact->wtsapp_number); ?></td>
                                        <td><?php echo e($contact->email); ?></td>
                                       <td style="max-width:150px; word-wrap: break-word; white-space: normal;"><?php echo e($contact->company_address); ?></td>
                                      <td>
                                        <div class="d-flex justify-content-between">
                                        <button class="btn btn-primary btn-sm toggle-status-btn"
                                            data-id="<?php echo e($contact->id); ?>" aria-label="Toggle Status">
                                            <i class="fa <?php echo e($contact->is_active ? 'fa-eye' : 'fa-eye-slash'); ?>"></i>
                                        </button>

                                        <button class="btn btn-primary btn-sm edit-btn2"
                                            data-id="<?php echo e($contact->id); ?>" data-phone="<?php echo e($contact->phone_number); ?>"
                                            data-wtsapp="<?php echo e($contact->wtsapp_number); ?>"
                                            data-email="<?php echo e($contact->email); ?>"
                                            data-address="<?php echo e($contact->company_address); ?>" data-bs-toggle="modal"
                                            data-bs-target="#editModal" aria-label="Edit Contact">
                                            <i class="fa fa-edit"></i>
                                        </button>

                                        <button class="btn btn-danger btn-sm delete-btn"
                                            data-id="<?php echo e($contact->id); ?>" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal" aria-label="Delete Contact">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                        </div>
                                    </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo e(route('contact_update')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>Edit Contact</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group mb-2">
                            <label>Phone</label>
                            <input type="text" name="phone_number" id="edit_phone" class="form-control" required>
                        </div>
                        <div class="form-group mb-2">
                            <label>WhatsApp</label>
                            <input type="text" name="wtsapp_number" id="edit_wtsapp" class="form-control" required>
                        </div>
                        <div class="form-group mb-2">
                            <label>Email</label>
                            <input type="email" name="email" id="edit_email" class="form-control" required>
                        </div>
                        <div class="form-group mb-2">
                            <label>Address</label>
                            <input type="text" name="company_address" id="edit_address" class="form-control"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo e(route('contact_delete')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" id="delete_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>Confirm Delete</h5>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete this contact?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger">Yes, Delete</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="toggleStatusModal" tabindex="-1" aria-labelledby="toggleStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('contact_toggle_status')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="toggle_status_id">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="toggleStatusModalLabel">Confirm Status Change</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to change the status of this contact?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="confirmToggleStatusBtn">Yes, Change Status</button>
                </div>
            </div>
        </form>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <!-- JS dependencies -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/datatables.init.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/buttons.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/vfs_fonts.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    // Populate Edit Modal
    $('.edit-btn2').on('click', function() {
        $('#edit_id').val($(this).data('id'));
        $('#edit_phone').val($(this).data('phone'));
        $('#edit_wtsapp').val($(this).data('wtsapp'));
        $('#edit_email').val($(this).data('email'));
        $('#edit_address').val($(this).data('address'));
    });

    // Delete Modal
    $('.delete-btn').on('click', function() {
        $('#delete_id').val($(this).data('id'));
    });

    // Populate Toggle Status Modal and handle submission
    $('.toggle-status-btn').on('click', function() {
        const contactId = $(this).data('id');
        $('#toggle_status_id').val(contactId);
        // Show the confirmation modal
        const toggleStatusModal = new bootstrap.Modal(document.getElementById('toggleStatusModal'));
        toggleStatusModal.show();
    });

   
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/contact_us.blade.php ENDPATH**/ ?>