<?php $__env->startSection('title', 'Add Category'); ?>
<?php $__env->startSection('header'); ?>
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Add Category</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Add Category</h5>
                    </div>
                    <div class="card-body">
                      
                        <form action="<?php echo e(route('add_category_post')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <!-- Image Upload -->
                                    <div class="form-group mb-3">
                                        <label for="category_img" class="form-label">Choose Image</label>
                                        <input class="form-control" name="category_img" type="file" id="category_img" accept="image/*">
                                        <?php $__errorArgs = ['category_img'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                        
                                    <!-- Category Type Selection -->
                                    <div class="form-group mb-3">
                                        <label for="category_type" class="form-label">Select Category Type</label>
                                        <select class="form-select" name="category_type" id="category_type" aria-label="Category Type Select">
                                            <option value="">Select</option>
                                            <option value="1" <?php echo e(old('category_type') == '1' ? 'selected' : ''); ?>>Category</option>
                                            <option value="2" <?php echo e(old('category_type') == '2' ? 'selected' : ''); ?>>SubCategory</option>
                                        </select>
                                        <?php $__errorArgs = ['category_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                        
                                    <!-- Category Name -->
                                    <div class="form-group mb-3" id="category_name_group">
                                        <label for="category_name" class="form-label">Category Name</label>
                                        <input type="text" name="category_name" class="form-control" id="category_name" placeholder="Enter Name" value="<?php echo e(old('category_name')); ?>">
                                        <?php $__errorArgs = ['category_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                        
                                    <!-- Subcategory Name -->
                                    <div class="form-group mb-3" id="subcategory_name_group">
                                        <label for="subcategory_name" class="form-label">Subcategory Name</label>
                                        <input type="text" name="subcategory_name" class="form-control" id="subcategory_name" placeholder="Enter Name" value="<?php echo e(old('subcategory_name')); ?>">
                                        <?php $__errorArgs = ['subcategory_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                        
                                    <!-- Link To Category -->
                                    <div class="form-group mb-3" id="link_to_category" style="display: none;">
                                        <label for="link_to" class="form-label">If Type Sub Category Then Link To</label>
                                        <select class="form-select" name="link_to" id="link_to" aria-label="Link To Select">
                                            <option value="">Select Category to Link</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e(old('link_to') == $category->id ? 'selected' : ''); ?>>
                                                    <?php echo e($category->category_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['link_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                        
                                    <!-- Submit Button -->
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->
    </div>
    <!-- end container fluid -->
<?php $__env->stopSection(); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const categoryTypeSelect = document.getElementById('category_type');
        const linkToCategoryDiv = document.getElementById('link_to_category');
        const categoryNameGroup = document.getElementById('category_name_group');
        const subcategoryNameGroup = document.getElementById('subcategory_name_group');
    
        function handleCategoryTypeChange() {
            const selectedType = categoryTypeSelect.value;
    
            if (selectedType === '2') {
                // Show subcategory fields and link-to selection
                linkToCategoryDiv.style.display = 'block';
                categoryNameGroup.style.display = 'none';
                subcategoryNameGroup.style.display = 'block';
            } else {
                // Show category fields and hide subcategory and link-to selection
                linkToCategoryDiv.style.display = 'none';
                categoryNameGroup.style.display = 'block';
                subcategoryNameGroup.style.display = 'none';
            }
        }
    
        categoryTypeSelect.addEventListener('change', handleCategoryTypeChange);
    
        // Initialize form fields based on the current selected value
        handleCategoryTypeChange();
    });
    </script>
    
<?php $__env->startSection('footer'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/add_category.blade.php ENDPATH**/ ?>