
<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">
    <style>
        #totalAmountDisplay {
            font-size: 20px !important;
            font-weight: 600 !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Store Sales History</h3>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-md-12 d-flex justify-content-end">
            <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
        </div>
        <div class="row mt-3">
            <div class="col-md-3">
                <label for="fromDate">From Date:</label>
                <input type="date" class="form-control" id="fromDate">
            </div>
            <div class="col-md-3">
                <label for="toDate">To Date:</label>
                <input type="date" class="form-control" id="toDate">
            </div>
            <div class="col-md-3">
                <label for="phoneSearch">Search Phone No:</label>
                <input type="text" id="phoneSearch" class="form-control" placeholder="Enter phone number">
            </div>
            <div class="col-md-12 d-flex justify-content-end mt-3">
                <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                <button class="btn btn-secondary" id="resetBtn">Reset</button>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12">
                <div id="totalAmountDisplay" class="total-amount-display"></div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>ORDER ID</th>
                                    <th>NAME</th>
                                    <th>USER ID</th>
                                    <th>PHONE No</th>
                                    <th>DATE</th>
                                    <th>MEMBERSHIP</th>
                                    <th>PAYMENT MODE</th>
                                    <th>REMARK</th>
                                    <th>AMOUNT</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($offlineSales->isEmpty()): ?>
                                    <tr>
                                        <td colspan="11" class="text-center">No offline sales records found.</td>
                                    </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $offlineSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($sale->order_id); ?></td>
                                            <td><?php echo e($sale->user->name ?? 'N/A'); ?></td>
                                            <td><?php echo e($sale->user_id); ?></td>
                                            <td>
                                                <?php
                                                    $phone = preg_replace('/\D/', '', $sale->user->phone_number ?? '');
                                                ?>
                                                <?php echo e($phone); ?>

                                            </td>
                                            <td><?php echo e($sale->created_at->format('Y-m-d')); ?></td>
                                            <td><?php echo e($sale->user->membership ?? 'N/A'); ?></td>
                                            <td><?php echo e($sale->payment_mode); ?></td>
                                            <td><?php echo e($sale->status); ?></td>
                                            <td><?php echo e($sale->amount_payable); ?></td>
                                            <td>
                                                <a href="<?php echo e(url('admin/invoice_a4/' . $sale->order_id)); ?>" target="_blank"
                                                    class="btn btn-info btn-sm">View Invoice</a>
                                                <a href="<?php echo e(route('edit_invoice', ['id' => $sale->order_id])); ?>"
                                                    class="btn btn-warning btn-sm">Edit</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>
<!-- DataTables JS -->
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>
<!-- Moment JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
<script>
$(document).ready(function () {
    let table = $('#data-table').DataTable({
        dom: 'Bfrtip',
        buttons: [{
            extend: 'excelHtml5',
            className: 'buttons-excel d-none',
            filename: 'store_sales_history',
            exportOptions: { columns: ':visible:not(:last-child)' }
        }],
        order: [[5, 'desc']],
        responsive: true
    });
    // ✅ Export to Excel
    $('.excel-btn').on('click', function () {
        table.button('.buttons-excel').trigger();
    });
    // ✅ Filter → reloads backend data
    $('#filterBtn').on('click', function () {
        const fromDate = $('#fromDate').val();
        const toDate = $('#toDate').val();
        const phone = $('#phoneSearch').val();
        if (!fromDate || !toDate) {
            alert('Please select both From Date and To Date.');
            return;
        }
        let url = "<?php echo e(route('offline_sales_history')); ?>" +
                  '?from_date=' + fromDate +
                  '&to_date=' + toDate +
                  '&phone=' + phone;
        window.location.href = url;
    });
    // ✅ Reset → go back to current month data
    $('#resetBtn').on('click', function () {
        window.location.href = "<?php echo e(route('offline_sales_history')); ?>";
    });
    // ✅ Detect page refresh and reset to default (current month data)
    if (performance.navigation.type === performance.navigation.TYPE_RELOAD) {
        window.location.href = "<?php echo e(route('offline_sales_history')); ?>";
    }
    // ✅ Calculate total amount
  $(document).ready(function () {
    // Initialize your DataTable
    var table = $('#data-table').DataTable();

    function calculateTotalAmount() {
        let total = 0;

        // Loop through all rows in the DataTable (not just visible)
        table.rows().every(function () {
            let rowData = this.data();
            let amountText = rowData[9] || '0'; // Amount column (index 9)
            amountText = amountText.toString().replace(/[₹, ]/g, '');
            let amount = parseFloat(amountText);
            if (!isNaN(amount)) total += amount;
        });

        // Display total
        $('#totalAmountDisplay').html(
            '<h5><b>Total Amount: ₹ ' +
            total.toLocaleString(undefined, { minimumFractionDigits: 2 }) +
            '</b></h5>'
        );
    }

    // Run once when the table is ready
    calculateTotalAmount();

    // Recalculate whenever the table is redrawn (pagination, search, filter)
    table.on('draw', function () {
        calculateTotalAmount();
    });
});
 
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/offline_sales_history.blade.php ENDPATH**/ ?>