
<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header'); ?>

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">
    <style>
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        td.user-details {
            max-width: 250px;
            /* Adjust width as needed */
            white-space: normal !important;
            /* Allow line wrapping */
            word-wrap: break-word;
        }

        .user-details {
            max-width: 200px;
            /* Limit width */
            white-space: normal !important;
            /* Allow text to wrap */
            word-break: break-word;
            /* Break long text like email */
            font-size: 13px;
            /* Make it slightly smaller */
            line-height: 1.4;
            /* Reduce spacing */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">User Management</h3>
                <a href="<?php echo e(route('add_user')); ?>" class="btn btn-primary">Add User</a>
            </div>
        </div>


        <div class="row mb-3">
            <div class="col-md-3">
                <label>From Date</label>
                <input type="date" id="fromDate" class="form-control">
            </div>
            <div class="col-md-3">
                <label>To Date</label>
                <input type="date" id="toDate" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Membership</label>
                <?php
                    $memberships = DB::table('memberships')->pluck('title');
                ?>

                <select id="membershipFilter" class="form-control">
                    <option value="">All</option>
                    <?php $__currentLoopData = $memberships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($title); ?>"><?php echo e($title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button id="filterBtn" class="btn btn-primary me-2">Filter</button>
                <button id="resetBtn" class="btn btn-secondary">Reset</button>
                <button id="exportBtn" class="btn btn-success mb-3">Export</button>

            </div>
        </div>



        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                    

                        <div class="table-responsive">
                            <table id="data-table" class="table nowrap align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>DATE</th>
                                        <th>USER ID</th>
                                        <th>USER DETAILS</th>
                                        <th style="width: 80px; white-space: nowrap;">MEMBERSHIP</th>
                                        <th style="width: 80px; white-space: nowrap;">MEMBERSHIP NAME</th>
                                        <th style="width: 80px; white-space: nowrap;">CASH WALLET</th>
                                        <th style="width: 80px; white-space: nowrap;">SHOPP WALLET</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $currentAddress = \App\Models\Address::getCurrentAddress($user->id);
                                        ?>
                                        <?php
                                            $membership = DB::table('memberships')
                                                ->where('membership_id', $user->membership)
                                                ->first();
                                        ?>

                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($user->created_at->format('Y-m-d')); ?></td>
                                            <td><?php echo e($user->user_id); ?></td>

                                            <td class="user-details">
                                                <b>Name:</b> <?php echo e($user->name); ?><br>
                                                <b>Email:</b> <?php echo e($user->email); ?><br>
                                                <b>Phone:</b> <?php echo e($user->phone_number); ?>

                                            </td>


                                            <td style="white-space: nowrap;">
                                                <?php echo e($user->membership); ?>

                                            </td>
                                            <td style="white-space: nowrap;">
                                                <?php echo e($membership->title ?? 'No Membership'); ?>

                                            </td>


                                            <td style="white-space: nowrap;">
                                                <?php echo e($user->incomeWallet->cash_wallet ?? '0.00'); ?>

                                            </td>
                                            <td style="white-space: nowrap;">
                                                <?php echo e($user->incomeWallet->shopping_wallet ?? '0.00'); ?></td>

                                            <td>
                                                <a href="<?php echo e(route('view_orders', ['id' => $user->id])); ?>"
                                                    class="text-primary" title="View Orders">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('edit_user', ['id' => $user->id])); ?>"
                                                    class="text-success" title="Edit User">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->




    </div>
    <!-- end container fluid -->




<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
    
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>


    <script>
        $(document).ready(function() {
            let table = $('#data-table').DataTable();

            // Custom filter function
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                let fromDate = $('#fromDate').val();
                let toDate = $('#toDate').val();
                let membership = $('#membershipFilter').val();

                let date = data[1]; // DATE column
                let membershipTitle = data[5]; // MEMBERSHIP NAME column

                if (fromDate && new Date(date) < new Date(fromDate)) {
                    return false;
                }

                if (toDate && new Date(date) > new Date(toDate)) {
                    return false;
                }

                if (membership && membershipTitle.trim() !== membership.trim()) {
                    return false;
                }

                return true;
            });

            // Filter button
            $('#filterBtn').on('click', function() {
                table.draw();
            });

            // Reset button
            $('#resetBtn').on('click', function() {
                $('#fromDate').val('');
                $('#toDate').val('');
                $('#membershipFilter').val('');
                table.draw();
            });
        });
    </script>

<script>
document.getElementById("exportBtn").addEventListener("click", function () {
    let table = $('#data-table').DataTable(); // Get DataTables instance
    let rows = [];

    // Header row
    rows.push(["Name", "Phone Number"]);

    // Loop through ALL rows from DataTables
    table.rows().every(function () {
        let row = $(this.node());

        // Find name and phone from the HTML elements
        let name = row.find(".user-details").contents()
            .filter(function () {
                return this.nodeType === 3 && this.textContent.trim() !== "";
            })[0]?.textContent.trim();

        // OR more reliably: use specific <b> tags
        let nameValue = row.find(".user-details b:contains('Name:')")[0]?.nextSibling?.textContent.trim() || "";
        let phoneValue = row.find(".user-details b:contains('Phone:')")[0]?.nextSibling?.textContent.trim() || "";

        rows.push([nameValue, phoneValue]);
    });

    // Convert to CSV
    let csvContent = "data:text/csv;charset=utf-8," 
        + rows.map(e => e.map(v => `"${v}"`).join(",")).join("\n");

    // Trigger download
    let link = document.createElement("a");
    link.setAttribute("href", encodeURI(csvContent));
    link.setAttribute("download", "users.csv");
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/user_management.blade.php ENDPATH**/ ?>