
<?php $__env->startSection('title', 'Purchase Invoice'); ?>

<?php $__env->startSection('header'); ?>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/dataTables.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/responsive.bootstrap.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/datatable/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
   
   <style>
        table td,
        table th {
            vertical-align: middle;
            white-space: normal !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Purchase Invoice</h3>
                <div>
                    <a type="button" href="<?php echo e(route('create_invoice')); ?>" class="btn btn-primary feature-btn">
                        <i class="fa-solid fa-circle-plus me-2"></i>Create Invoice
                    </a>
                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">

                        <table id="data-table" class="table align-middle table-responsive" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Purchase Invoice Number</th>
                                    <th>Party Name</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $party = $purchase->purchaseParty;
                                        $dueIn = \Carbon\Carbon::parse($purchase->purchase_date)->diffInDays(now());
                                    ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($purchase->purchase_date)->format('d-m-Y')); ?></td>
                                        <td><?php echo e($purchase->invoice_number); ?></td>
                                        <td><?php echo e($party->customer_name ?? 'N/A'); ?></td>
                                        <td>₹<?php echo e(number_format($purchase->total_amount, 2)); ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-success" disabled>Paid</button>
                                        </td>
                                        <td>
                                            
                                                   <a href="<?php echo e(route('invoice_a4_purchase', ['orderId' => $purchase->id])); ?>"
                                                    target="_blank" class="btn btn-info btn-sm">View Invoice</a>
                                         
                                                <a href="<?php echo e(route('purchase.edit', ['id' => $purchase->id])); ?>"
                                                class="btn btn-warning btn-sm">Edit</a>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>

                    </div>
                </div>
            </div>
        </div>

</div><?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.bootstrap5.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/buttons.html5.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/buttons.print.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/jszip.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/pdfmake.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets/js/datatable/vfs_fonts.js')); ?>"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#data-table').DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],

            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/purchase_invoice.blade.php ENDPATH**/ ?>