
<?php $__env->startSection('title', 'GSTR-1 (Sales)'); ?>
<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/dataTables.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/responsive.bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/datatable/buttons.dataTables.min.css')); ?>">
    <!-- Page CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/formILY.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">GSTR-2 (Purchase)</h3>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12 d-flex justify-content-end">
                <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
            </div>
            <div class="row mt-3">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="fromDate">From Date:</label>
                        <input type="date" class="form-control" id="fromDate">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="toDate">To Date:</label>
                        <input type="date" class="form-control" id="toDate">
                    </div>
                </div>
                <div class="col-md-3 d-flex align-items-end justify-content-end">
                    <button class="btn btn-primary mr-2" id="filterBtn">Filter</button>
                    <button class="btn btn-secondary" id="resetBtn">Reset</button>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12">
                    <div id="totalAmountDisplay" class="total-amount-display">
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card datatable-card">
                        <div class="card-body">
                            <table id="salesTable" class="table table-bordered">
                                <thead>
                                    <tr class="table-light text-center">
                                        <th>S.N</th>
                                        <th>GSTIN</th>
                                        <th>Customer Name</th>
                                        <th>Invoice No</th>
                                        <th>Invoice Date</th>
                                        <th>Invoice Value</th>
                                        <th>Total Tax %</th>
                                        <th>Taxable Value</th>
                                        <th>SGST</th>
                                        <th>CGST</th>
                                        <th>Total Tax</th>
                                    </tr>
                                </thead>
                                <tbody>
                                 
                                    <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $party = $purchase->purchaseParty;
        $gstin = $party->gstin ?? 'N/A';
        $customerName = $party->customer_name ?? 'N/A';
        $totalCgst = 0;
        $totalSgst = 0;
        $totalGstPercent = 0;
        foreach ($purchase->items as $item) {
            $totalSgst += $item->sgst * $item->quantity;
            $totalCgst += $item->cgst * $item->quantity;
            $totalGstPercent += $item->gst_percentage ?? 0;
        }
        $totalTax = $totalCgst + $totalSgst;
        $invoiceTotal = $purchase->total_amount ?? 0;
       
        $taxableValue = $invoiceTotal - $totalTax;
    ?>
    <tr class="text-center">
        <td><?php echo e($loop->iteration); ?></td>
        <td><?php echo e($gstin); ?></td>
        <td><?php echo e($customerName); ?></td>
        <td><?php echo e($purchase->invoice_number); ?></td>
        <td><?php echo e(\Carbon\Carbon::parse($purchase->purchase_date)->format('d-m-Y')); ?></td>
        <td>₹<?php echo e(number_format($taxableValue, 2)); ?></td> 

        <td><?php echo e(number_format(count($purchase->items) > 0 ? $totalGstPercent / count($purchase->items) : 0, 2)); ?>%</td>
        <td>₹<?php echo e(number_format($invoiceTotal, 2)); ?></td>
        
        <td>₹<?php echo e(number_format($totalSgst, 2)); ?></td>
        <td>₹<?php echo e(number_format($totalCgst, 2)); ?></td>
        <td>₹<?php echo e(number_format($totalTax, 2)); ?></td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <!-- Bootstrap Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTable JS -->
    <script src="<?php echo e(asset('/assets/js/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/datatable/vfs_fonts.js')); ?>"></script>
    <script>
$(document).ready(function () {

    var table = $('#salesTable').DataTable({
        responsive: true,
        dom: 'Bfrtip', // important
        buttons: [
            { extend: 'excel', className: 'btn btn-success' } // excel button enabled
        ]
    });

    // 🔥 Click Excel button manually
    $('.excel-btn').on('click', function () {
        table.button(0).trigger();
    });

});
</script>

    <script>
$(document).ready(function () {
    // Initialize DataTable on your purchase table
    var table = $('table').DataTable({
        responsive: true,
        dom: 'frtip',
        pageLength: 10
    });
    // Add export buttons
    new $.fn.dataTable.Buttons(table, {
        buttons: [
            { extend: 'excel', className: 'buttons-excel' },
            { extend: 'pdf', className: 'buttons-pdf' },
            { extend: 'print', className: 'buttons-print' }
        ]
    });
    table.buttons(0, null).container().appendTo('#salesTable_wrapper .col-md-6:eq(0)').hide();
    // --- JSON Download ---
    $('#downloadJsonBtn').on('click', function () {
        var data = table.rows({ search: 'applied' }).data().toArray();
        var blob = new Blob([JSON.stringify(data)], { type: "application/json" });
        var link = document.createElement('a');
        link.href = window.URL.createObjectURL(blob);
        link.download = "purchases.json";
        link.click();
    });
    // Excel/PDF Triggers
    $('#downloadExcelBtn').on('click', function () {
        table.button('.buttons-excel').trigger();
    });
    $('#printPdfBtn').on('click', function () {
        table.button('.buttons-pdf').trigger();
    });
    // --- Date Filter ---
    $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
        let fromDate = $('#fromDate').val();
        let toDate = $('#toDate').val();
        let dateText = data[4]; // Invoice Date column index (dd-mm-yyyy)
        if (!dateText) return false;
        let parts = dateText.split("-");
        let rowDate = new Date(parts[2], parts[1] - 1, parts[0]);
        if (fromDate) fromDate = new Date(fromDate);
        if (toDate) toDate = new Date(toDate);
        if ((!fromDate || rowDate >= fromDate) && (!toDate || rowDate <= toDate)) {
            return true;
        }
        return false;
    });
    // Filter Button
    $('#filterBtn').click(function () {
        table.draw();
    });
    // Reset Button
    $('#resetBtn').click(function () {
        $('#fromDate').val('');
        $('#toDate').val('');
        table.draw();
    });
    // --- Function to Calculate Total Invoice Value ---
    function updateTotalAmount() {
        let totalAmount = 0;
        // Loop through all filtered rows (all pages, not just current)
        table.rows({ search: 'applied' }).every(function () {
            let data = this.data();
            let invoiceValueText = data[5]; // Invoice Value column
            if (invoiceValueText) {
                let rawValue = invoiceValueText.replace('₹', '').replace(/,/g, '').trim();
                let value = parseFloat(rawValue);
                if (!isNaN(value)) totalAmount += value;
            }
        });
        // Update the display
        $('#totalAmountDisplay').html(
            '<h5><strong>Total Invoice Value:</strong> ₹' +
            totalAmount.toLocaleString('en-IN', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            }) +
            '</h5>'
        );
    }
    // Update total on every draw (pagination, search, filter, etc.)
    table.on('draw.dt', function () {
        updateTotalAmount();
    });
    // Initial calculation on load
    updateTotalAmount();
});
</script>
<script>
$(document).ready(function () {
    var table = $('#salesTable').DataTable({
        responsive: true,
        dom: 'frtip',
        pageLength: 10
    });
    new $.fn.dataTable.Buttons(table, {
        buttons: [
            { extend: 'excel', className: 'buttons-excel' }
        ]
    });
    table.buttons().container().appendTo('#salesTable_wrapper .col-md-6:eq(0)').hide();
    // 🔥 Custom Button Exports Excel
    $('.excel-btn').on('click', function () {
        table.button('.buttons-excel').trigger();
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/gstr2.blade.php ENDPATH**/ ?>