
<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header'); ?>
    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">
    <style>
        #totalAmountDisplay {
            font-size: 20px !important;
            font-weight: 600 !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Store Sales History</h3>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-md-12 d-flex justify-content-end">
            <button class="btn btn-success excel-btn mb-3">Export to Excel</button>
        </div>
        <div class="row mt-3">
            
        </div>
        <div class="row mt-4">
            
        </div>
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>ORDER ID</th>
                                    <th>NAME</th>
                                    <th>USER ID</th>
                                    <th>PHONE No</th>
                                    <th>DATE</th>
                                    <th>MEMBERSHIP</th>
                                    <th>PAYMENT MODE</th>
                                    <th>REMARK</th>
                                    <th>AMOUNT</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($offlineSales->isEmpty()): ?>
                                    <tr>
                                        <td colspan="11" class="text-center">No offline sales records found.</td>
                                    </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $offlineSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($sale->order_id); ?></td>
                                            <td><?php echo e($sale->user->name ?? 'N/A'); ?></td>
                                            <td><?php echo e($sale->user_id); ?></td>
                                            <td>
                                                <?php
                                                    $phone = preg_replace('/\D/', '', $sale->user->phone_number ?? '');
                                                ?>
                                                <?php echo e($phone); ?>

                                            </td>
                                            <td><?php echo e($sale->created_at->format('Y-m-d')); ?></td>
                                            <td><?php echo e($sale->user->membership ?? 'N/A'); ?></td>
                                            <td><?php echo e($sale->payment_mode); ?></td>
                                            <td><?php echo e($sale->status); ?></td>
                                            <td><?php echo e($sale->amount_payable); ?></td>
                                            <td>
                                                <a href="<?php echo e(url('employee/invoice_a4/' . $sale->order_id)); ?>" target="_blank"
                                                    class="btn btn-info btn-sm">View Invoice</a>
                                                <a href="<?php echo e(route('employeeedit_invoice', ['id' => $sale->order_id])); ?>"
                                                    class="btn btn-warning btn-sm">Edit</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>
<!-- DataTables JS -->
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>
<!-- Moment JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
            let fromDate = $('#fromDate').val();
            let toDate = $('#toDate').val();
            let date = data[5];
            if (!fromDate && !toDate) return true;
            let momentDate = moment(date, 'YYYY-MM-DD');
            let fromMoment = fromDate ? moment(fromDate) : null;
            let toMoment = toDate ? moment(toDate) : null;
            if (fromMoment && !toMoment && momentDate.isSameOrAfter(fromMoment)) return true;
            if (!fromMoment && toMoment && momentDate.isSameOrBefore(toMoment)) return true;
            if (fromMoment && toMoment && momentDate.isBetween(fromMoment.clone().subtract(1, 'days'), toMoment.clone().add(1, 'days'))) return true;
            return false;
        });
        let table = $('#data-table').DataTable({
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excelHtml5',
                text: 'Export to Excel',
                filename: 'offline_sales',
                title: null,
                className: 'd-none',
                exportOptions: { columns: ':visible' }
            }],
            order: [[5, 'desc']],
            responsive: true
        });
        function calculateTotalAmount() {
            let total = 0;
            table.rows({ search: 'applied' }).every(function () {
                let row = this.node();
                let amount = parseFloat($(row).find('td').eq(9).text().replace(/,/g, ''));
                if (!isNaN(amount)) total += amount;
            });
            $('#totalAmountDisplay').text('Total Amount: ' + total.toFixed(2));
        }
        table.on('draw', function () {
            calculateTotalAmount();
        });
        calculateTotalAmount();
        // Phone Number Search
        $('#phoneSearch').on('keyup', function () {
            let val = this.value.replace(/\D/g, ''); // Remove non-digits
            console.log('Searching for phone number:', val);
            table.column(4).search(val).draw();
        });
        $('#filterBtn').on('click', function () {
            table.draw();
        });
        $('#resetBtn').on('click', function () {
            $('#fromDate').val('');
            $('#toDate').val('');
            $('#phoneSearch').val('');
            table.search('').columns().search('').draw();
        });
        $('.excel-btn').on('click', function () {
            table.button('.buttons-excel').trigger();
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('employee.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/employee/offline_sales_history.blade.php ENDPATH**/ ?>