
<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header'); ?>

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">
<style>
    table td, table th {
    vertical-align: top;
    white-space: normal !important;
    word-wrap: break-word;
}

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Daily Task History</h3>

            </div>
        </div>



        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        

<table id="data-table" class="table align-middle" style="width:100%">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Date</th>
            <th>Video Link</th>
            <th>Note</th>
            <th>Time</th>
            <th>Cover Image</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $datatables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($data->date); ?></td>

                <td style="word-break: break-all; max-width: 200px;">
                    <?php echo e($data->video_link); ?>

                </td>

                <td style="white-space: normal; max-width: 250px;">
                    <?php echo e($data->note); ?>

                </td>

                <td><?php echo e($data->time); ?></td>

                <td>
                    <?php if(!empty($data->cover_image)): ?>
                        <img src="<?php echo e(asset($data->cover_image)); ?>" class="preview-td-img" alt="preview image" style="max-width: 100px; height: auto;">
                    <?php else: ?>
                        <span>null</span>
                    <?php endif; ?>
                </td>

                <td>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModalcc"
                        class="btn transparent-btn text-danger text-decoration-underline"
                        data-user-id="<?php echo e($data->id); ?>" onclick="setDeleteId(this)">
                        Delete
                    </button>

                    <a href="<?php echo e(route('edit_daily_task', ['id' => $data->id])); ?>"
                        class="btn transparent-btn text-primary text-decoration-underline">
                        Edit
                    </a>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>


                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->



        <!-- Delete Modal for Each Notification -->
        <div class="modal fade" id="DeleteModalcc" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-body">
                        <div class="text-center">

                            <img class="mb-3" src="<?php echo e(asset('/assets')); ?>/images/icons/delete-icon.svg"
                                alt="Delete Icon">
                            <p class="my-4">Are You Sure?</p>
                            <p class="text-muted my-2">Are you sure you want to delete this notification?</p>
                        </div>
                        <form action="<?php echo e(route('video_delete')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="delete_id" name="delete_id">
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button type="button" data-bs-dismiss="modal"
                                    class="btn btn-light cancel-btn me-3">Cancel</button>
                                <button type="submit" class="btn btn-primary submit-btn"><i
                                        class="fa-regular fa-circle-check me-2"></i>Submit</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>


    </div>
    <!-- end container fluid -->




<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>


    <script>
        function setDeleteId(button) {
            var userId = button.getAttribute("data-user-id");
            document.getElementById("delete_id").value = userId; // Set ID correctly
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/daily_task_history.blade.php ENDPATH**/ ?>