<!DOCTYPE html>
<html lang="en" x-data="purchaseInvoice({
    initialPurchase: <?php echo e(Js::from($myPurchase)); ?>

})" @keydown.window="handleGlobalKeys($event)">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Edit Purchase Invoice #<?php echo e($myPurchase->invoice_number); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .purchase-search-results {
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
            position: absolute;
            width: calc(100% - 2rem);
            /* Adjust based on padding/margin of parent */
            background-color: white;
            border: 1px solid #dee2e6;
            border-top: none;
            left: 1rem;
            /* Adjust to align with input */
            right: 1rem;
            /* Adjust to align with input */
        }

        .table-scroll-container {
            max-height: calc(100vh - 450px);
            /* Adjust based on header/footer height */
            overflow-y: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            background-color: #f8f9fa;
            z-index: 10;
        }

        .supplier-details-compact p {
            margin-bottom: 0;
            line-height: 1.2;
        }
    </style>
</head>

<body>

    <div class="container-fluid bg-light border-bottom py-2 px-3 d-flex justify-content-between align-items-center">
        <button class="btn btn-outline-secondary btn-sm" @click="exitPurchaseInvoice">
            <i class="bi bi-arrow-left"></i> <strong>Exit Purchase Invoice</strong> [ESC]
        </button>
        <h6 class="m-0">Edit Purchase Invoice #<?php echo e($myPurchase->invoice_number); ?></h6>
        <div class="d-flex gap-2">
            <button class="btn btn-outline-secondary btn-sm" @click="showHeldInvoicesModal">
                <strong>Held Invoices</strong> [F8]
            </button>
            <button class="btn btn-outline-secondary btn-sm" @click="openSettings">
                <strong>Settings</strong> [CTRL+S]
            </button>
        </div>
    </div>

    <div class="container-fluid p-3">
        <div class="d-flex flex-wrap align-items-center gap-3 px-2 py-2 bg-light border rounded">
            <div class="card-header bg-primary text-white py-2 px-3 rounded-top">
                <h6 class="mb-0">Supplier Details</h6>
            </div>
            <div class="flex-grow-1">
                <input type="text" class="form-control" x-model.debounce.500ms="currentInvoice().supplierIdentifier"
                    @input.debounce.500ms="fetchSupplierDetails()" placeholder="Type supplier name/ID and wait...">
            </div>
            <template x-if="currentInvoice().supplierDetails">
                <div class="d-flex flex-wrap align-items-center gap-3 supplier-details-compact">
                    <div>
                        <strong x-text="currentInvoice().supplierDetails.name"></strong>
                        <small class="text-muted">(ID: <span
                                x-text="currentInvoice().supplierDetails.id"></span>)</small>
                    </div>
                    <div>
                        <strong x-text="currentInvoice().supplierDetails.customer_name"></strong>
                    </div>
                    <div class="text-muted small">
                        <i class="bi bi-telephone"></i>
                        <span x-text="currentInvoice().supplierDetails.phone_number"></span>
                    </div>
                    <div class="text-muted small">
                        <i class="bi bi-geo-alt"></i>
                        <span x-text="currentInvoice().supplierDetails.address"></span>
                    </div>
                </div>
            </template>

            <div class="text-muted small fst-italic"
                x-show="currentInvoice().supplierIdentifier && !currentInvoice().supplierDetails && !currentInvoice().supplierDetailsLoading">
                No supplier found.
            </div>
            <div class="text-info small fst-italic" x-show="currentInvoice().supplierDetailsLoading">
                Searching...
            </div>
        </div>


        <ul class="nav nav-tabs mb-1">
            <template x-for="invoice in invoices" :key="invoice.id">
                <li class="nav-item">
                    <a href="#" class="nav-link" :class="{ active: invoice.id === activeInvoiceId }"
                        @click.prevent="activateInvoice(invoice.id)">
                        <span x-text="invoice.name"></span>
                        <i class="bi bi-x-lg ms-2" x-show="invoices.length > 1"
                            @click.stop="closeInvoice(invoice.id)"></i>
                    </a>
                </li>
            </template>
            <li class="nav-item">
                <a href="#" class="nav-link" @click.prevent="addNewInvoice"><i class="bi bi-plus"></i> New Invoice
                    [CTRL+B]</a>
            </li>
        </ul>

        <div class="row">
            <div class="col-md-8 border-end position-relative">
                <div class="d-flex gap-2 mb-3">
                    <button class="btn btn-outline-secondary btn-sm" @click="openPurchasePriceChangeModal">Change
                        Purchase Price
                        [CTRL+P]</button>
                    <button class="btn btn-outline-secondary btn-sm" @click="openQuantityChangeModal">Change QTY
                        [CTRL+Q]</button>
                    <button class="btn btn-outline-secondary btn-sm" @click="deleteSelectedItem()">Delete Item
                        [DEL]</button>
                </div>
                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input x-ref="searchInput" class="form-control" type="text" placeholder="Search item/code"
                        x-model.debounce.300ms="currentInvoice().searchQuery" @input.debounce.300ms="searchProducts"
                        @keydown.enter.prevent="handleSearchEnter" @keydown.arrow-down.prevent="selectNextResult"
                        @keydown.arrow-up.prevent="selectPrevResult" @keydown.escape.stop="clearSearchResults">
                    <span class="input-group-text">[F1]</span>
                </div>
                <ul class="list-group purchase-search-results" x-show="currentInvoice().searchResults.length">
                    <template x-for="(prod, idx) in currentInvoice().searchResults" :key="prod.item_identifier">
                        <li class="list-group-item list-group-item-action"
                            :class="{ active: idx === currentInvoice().selectedSearchResultIndex }"
                            @click="addItemToInvoice(prod)"
                            @mouseover="currentInvoice().selectedSearchResultIndex = idx">
                            <span x-text="prod.name"></span> - <small x-text="prod.item_code"></small> (P.Price: ₹
                            <span x-text="Number(prod.purchase_price || 0).toFixed(2)"></span> | Stock: <span
                                x-text="prod.stock"></span>)
                        </li>
                    </template>
                </ul>

                <div class="table-scroll-container">
                    <table class="table table-bordered text-center">


                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Item</th>
                                <th>Code</th>
                                <th>MRP</th>
                                <th>P.Price</th>
                                <th>S.Price</th>
                                <th>QTY</th>
                                <th>GST</th>
                                <th>Amount</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-if="!currentInvoice().invoiceItems.length">
                                <tr>
                                    <td colspan="10" class="py-5 text-muted"><i class="bi bi-box-seam fs-1"></i>
                                        <p>Add items to the purchase invoice...</p>
                                    </td>
                                </tr>
                            </template>
                            <template x-for="(item, idx) in currentInvoice().invoiceItems" :key="idx">
                                <tr :class="{ 'table-primary': currentInvoice().selectedItemIndex === idx }"
                                    @click="selectItem(idx)">
                                    <td x-text="idx+1"></td>
                                    <td x-text="item.title"></td>
                                    
                                     <td><span x-text="item.item_code"></span>
                                        <small class="text-muted">(Stock:<span x-text="item.stock"></span>)</small>
                                    </td>
                                    <td x-text="(Number(item.mrp) || 0).toFixed(2)"></td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm text-center"
                                            style="width:100px;margin:auto;" x-model.number="item.purchase_price"
                                            @change="calculateInvoiceTotals()" min="0" step="1">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm text-center"
                                            style="width:100px;margin:auto;" x-model.number="item.sell_price"
                                            @change="calculateInvoiceTotals()" min="0" step="1">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control form-control-sm text-center"
                                            style="width:80px;margin:auto;" x-model.number="item.quantity"
                                            @change="calculateInvoiceTotals()" min="1">
                                    </td>
                                    
                                    
                                     <td>
                                        <span
                                            x-text="item.gst_percentage % 1 === 0 ? parseInt(item.gst_percentage) + '%' : parseFloat(item.gst_percentage).toFixed(2) + '%'"></span>
                                    </td>
                                    <td x-text="((Number(item.purchase_price) || 0) * item.quantity).toFixed(2)"></td>
                                    <td>
                                        <button type="button" class="btn btn-danger btn-sm"
                                            @click.stop="removeItem(idx)">
                                            <i class="bi bi-x-lg"></i>
                                        </button>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="col-md-4">
                <div class="d-flex gap-2 mb-2">
                    <button class="btn btn-outline-secondary btn-sm flex-fill" @click="openDiscountModal">Add Discount
                        [F2]</button>
                    <button class="btn btn-outline-secondary btn-sm flex-fill" @click="openAdditionalChargeModal">Add
                        Charge [F3]</button>
                </div>

                <div class="card p-3 mb-2">
                    <h6>Invoice Summary</h6>
                    <div class="d-flex justify-content-between">
                        <span>GST Total</span>
                        <span>₹ <span x-text="currentInvoice().gstTotal.toFixed(2)"></span></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Sub Total (Excl. GST)</span>
                        <span>₹ <span x-text="currentInvoice().subTotalExcludingGST.toFixed(2)"></span></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Sub Total (Incl. GST)</span>
                        <span>₹ <span x-text="currentInvoice().subTotalIncludingGST.toFixed(2)"></span></span>
                    </div>

                    <template x-if="currentInvoice().discountAmount > 0">
                        <div class="d-flex justify-content-between">
                            <span>Discount</span>
                            <span>₹ <span x-text="currentInvoice().discountAmount.toFixed(2)"></span></span>
                        </div>
                    </template>

                    <template x-if="currentInvoice().additionalCharge > 0">
                        <div class="d-flex justify-content-between">
                            <span>Charge</span>
                            <span>₹ <span x-text="currentInvoice().additionalCharge.toFixed(2)"></span></span>
                        </div>
                    </template>
                    <hr>
                    <div class="d-flex justify-content-between fw-bold text-success">
                        <span>Grand Total</span>
                        <span>₹ <span x-text="currentInvoice().totalAmount.toFixed(2)"></span></span>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <button class="btn btn-primary flex-fill" @click="saveInvoiceAndPrint">Save & Print [F6]</button>
                    <button class="btn btn-outline-secondary flex-fill" @click="saveHeldInvoice">Hold Invoice
                        [F7]</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="purchasePriceChangeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Change Purchase Price</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body"><input type="number" class="form-control"
                        x-model.number="tempPurchasePrice" step="0.01"></div>
                <div class="modal-footer"><button class="btn btn-primary"
                        @click="confirmChangePurchasePrice">Apply</button><button class="btn btn-outline-secondary"
                        data-bs-dismiss="modal">Cancel</button></div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="qtyChangeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Change Quantity</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body"><input type="number" class="form-control" x-model.number="tempQuantity" min="1">
                </div>
                <div class="modal-footer"><button class="btn btn-primary"
                        @click="confirmChangeQuantity">Apply</button><button class="btn btn-outline-secondary"
                        data-bs-dismiss="modal">Cancel</button></div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="discountModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Discount</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="discountAmount" class="form-label">Discount Amount (₹)</label>
                        <input type="number" class="form-control" id="discountAmount" x-model.number="currentInvoice().discountAmount" step="0.01">
                    </div>
                    <div>
                        <label for="discountNote" class="form-label">Discount Note</label>
                        <textarea class="form-control" id="discountNote" x-model="currentInvoice().discountNote"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-dismiss="modal" @click="calculateInvoiceTotals">Apply</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="additionalChargeModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Additional Charge</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="additionalChargeAmount" class="form-label">Charge Amount (₹)</label>
                        <input type="number" class="form-control" id="additionalChargeAmount" x-model.number="currentInvoice().additionalCharge" step="0.01">
                    </div>
                    <div>
                        <label for="additionalChargeNote" class="form-label">Charge Note</label>
                        <textarea class="form-control" id="additionalChargeNote" x-model="currentInvoice().additionalChargeNote"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-dismiss="modal" @click="calculateInvoiceTotals">Apply</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="printSettingsModal" tabindex="-1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Print Settings</h5><button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="printType" id="printA4" value="a4" x-model="currentInvoice().printType">
                        <label class="form-check-label" for="printA4">A4</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="printType" id="printThermal" value="thermal" x-model="currentInvoice().printType">
                        <label class="form-check-label" for="printThermal">Thermal</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('purchaseInvoice', (initialData = {}) => ({
                invoices: [],
                activeInvoiceId: null,
                heldInvoices: [], // Storage for held invoices
                nextInvoiceId: 1,

                init() {
                    const purchaseData = initialData.initialPurchase;
                    if (purchaseData) {
                        this.loadPurchaseForEdit(purchaseData);
                    } else {
                        this.invoices.push(this.newInvoice());
                        this.activeInvoiceId = this.invoices[0].id;
                    }
                },

                // This new function handles loading the data from the server
                loadPurchaseForEdit(purchase) {
                    const mappedItems = purchase.items.map(item => ({
                        id: item.id, // The ID of the MyPurchaseItem record
                        product_id: item.product_id, // The ID of the Product record
                        title: item.product.title,
                        item_code: item.product.item_code,
                        stock: Number(item.product.stock),
                        mrp: item.product.mrp,
                        purchase_price: Number(item.purchase_price),
                        sell_price: Number(item.sell_price),
                        quantity: Number(item.quantity),
                        gst_percentage: Number(item.gst_percentage),
                        gst_price: Number(item.gst_price),
                        gst_amount_per_unit: (Number(item.purchase_price) * (Number(item.gst_percentage) / 100)),
                        original_quantity: Number(item.quantity) // Store the original quantity for stock adjustment
                    }));

                    const newInvoice = {
                        id: 1, // Start with a single invoice for editing
                        isEditMode: true,
                        invoiceIdOnServer: purchase.id,
                        name: `Invoice #${purchase.invoice_number}`,
                        supplierIdentifier: purchase.purchase_party.customer_name,
                        supplierDetails: purchase.purchase_party,
                        productPurchaseId: purchase.product_purchase_id,
                        invoiceItems: mappedItems,
                        searchQuery: '',
                        searchResults: [],
                        selectedSearchResultIndex: -1,
                        selectedItemIndex: null,

                        discountAmount: Number(purchase.discount_amount),
                        discountNote: purchase.discount_note,
                        additionalCharge: Number(purchase.additional_charge),
                        additionalChargeNote: purchase.additional_charge_note,

                        subTotalExcludingGST: 0,
                        gstTotal: 0,
                        subTotalIncludingGST: 0,
                        totalAmount: 0,
                        printType: purchase.print_type || 'a4', // Default to a4 if not set

                        tempPurchasePrice: 0,
                        tempQuantity: 0,
                    };
                    
                    this.invoices = [newInvoice];
                    this.activeInvoiceId = newInvoice.id;
                    this.calculateInvoiceTotals();
                },

                newInvoice(isHeld = false) {
                    const invoiceName = isHeld ? `Held-${this.nextInvoiceId}` : `Invoice ${this.nextInvoiceId}`;
                    const newInvoice = {
                        id: this.nextInvoiceId++,
                        name: invoiceName,
                        isEditMode: false,
                        invoiceIdOnServer: null,
                        supplierIdentifier: '',
                        supplierDetails: null,
                        productPurchaseId: null,
                        invoiceItems: [],
                        searchQuery: '',
                        searchResults: [],
                        selectedSearchResultIndex: -1,
                        selectedItemIndex: null,
                        discountAmount: 0,
                        discountNote: '',
                        additionalCharge: 0,
                        additionalChargeNote: '',
                        subTotalExcludingGST: 0,
                        gstTotal: 0,
                        subTotalIncludingGST: 0,
                        totalAmount: 0,
                        printType: 'a4',
                        tempPurchasePrice: 0,
                        tempQuantity: 0,
                    };
                    return newInvoice;
                },

                currentInvoice() {
                    return this.invoices.find(inv => inv.id === this.activeInvoiceId) || this.invoices[0];
                },

                activateInvoice(id) {
                    this.activeInvoiceId = id;
                },

                addNewInvoice() {
                    const newInvoice = this.newInvoice();
                    this.invoices.push(newInvoice);
                    this.activateInvoice(newInvoice.id);
                },

                closeInvoice(id) {
                    if (this.invoices.length > 1) {
                        this.invoices = this.invoices.filter(inv => inv.id !== id);
                        this.activeInvoiceId = this.invoices[this.invoices.length - 1].id;
                    }
                },

                selectItem(index) {
                    this.currentInvoice().selectedItemIndex = index;
                },

                deleteSelectedItem() {
                    const current = this.currentInvoice();
                    if (current.selectedItemIndex !== null && current.invoiceItems[current.selectedItemIndex]) {
                        current.invoiceItems.splice(current.selectedItemIndex, 1);
                        current.selectedItemIndex = null;
                        this.calculateInvoiceTotals();
                    }
                },

                calculateInvoiceTotals() {
                    const current = this.currentInvoice();
                    let subTotalExclGst = 0;
                    let gstTotal = 0;

                    current.invoiceItems.forEach(item => {
                        const amountExclGst = (Number(item.purchase_price) || 0) * (Number(item.quantity) || 0);
                        const gstAmount = amountExclGst * (item.gst_percentage / 100);

                        subTotalExclGst += amountExclGst;
                        gstTotal += gstAmount;
                    });
                    
                    current.subTotalExcludingGST = subTotalExclGst -  gstTotal;
                    current.gstTotal = gstTotal;
                    current.subTotalIncludingGST = subTotalExclGst;
                    
                    let grandTotal = current.subTotalIncludingGST - (Number(current.discountAmount) || 0) + (Number(current.additionalCharge) || 0);
                    current.totalAmount = grandTotal;
                },


           

                    async searchProducts() {
                const current = this.currentInvoice();
                if (!current.searchQuery) {
                    current.searchResults = [];
                    current.selectedSearchResultIndex = -1;
                    return;
                }
                try {
                    const response = await fetch(
                        `<?php echo e(route('products_search')); ?>?query=${current.searchQuery}`);
                    if (!response.ok) {
                        const errorData = await response.json().catch(() => ({
                            message: 'Server error or invalid JSON response'
                        }));
                        console.error('Error searching products (HTTP):', response.status,
                            errorData.message || 'Unknown error');
                        current.searchResults = [];
                        return;
                    }

                    const data = await response.json();
                    current.searchResults = data;
                    current.selectedSearchResultIndex = data.length > 0 ? 0 : -1;
                } catch (error) {
                    console.error('Error searching products:', error);
                    current.searchResults = [];
                }
            },



                addItemToInvoice(product) {
                    const current = this.currentInvoice();
                    const existingItem = current.invoiceItems.find(item => item.product_id === product.id);
                    if (existingItem) {
                        existingItem.quantity++;
                    } else {
                        current.invoiceItems.push({
                            id: null, // New item won't have an ID yet
                            product_id: product.id,
                            title: product.name,
                            item_code: product.item_code,
                            stock: Number(product.stock),
                            mrp: Number(product.mrp),
                            purchase_price: Number(product.purchase_price),
                            sell_price: Number(product.sell_price),
                            quantity: 1,
                            gst_percentage: Number(product.gst_rate),
                            gst_price: (Number(product.purchase_price) * (Number(product.gst_rate) / 100)),
                            gst_amount_per_unit: (Number(product.purchase_price) * (Number(product.gst_rate) / 100)),
                            original_quantity: 0
                        });
                    }
                    current.searchQuery = '';
                    current.searchResults = [];
                    this.calculateInvoiceTotals();
                },

              


                handleSearchEnter() {
                    const current = this.currentInvoice();
                    if (current.selectedSearchResultIndex !== -1 && current.searchResults.length > 0) {
                        this.addItemToInvoice(current.searchResults[current.selectedSearchResultIndex]);
                        this.calculateInvoiceTotals();
                    }
                },
                selectNextResult() {
                    const current = this.currentInvoice();
                    if (current.selectedSearchResultIndex < current.searchResults.length - 1) {
                        current.selectedSearchResultIndex++;
                    }
                },

                selectPrevResult() {
                    const current = this.currentInvoice();
                    if (current.selectedSearchResultIndex > 0) {
                        current.selectedSearchResultIndex--;
                    }
                },
                clearSearchResults() {
                    this.currentInvoice().searchResults = [];
                    this.currentInvoice().selectedSearchResultIndex = -1;
                },

                // New logic for supplier search
                async fetchSupplierDetails() {
                    const current = this.currentInvoice();
                    current.supplierDetailsLoading = true;
                    try {
                        const response = await fetch(`/admin/purchase/search-suppliers?query=${current.supplierIdentifier}`);
                        if (response.ok) {
                            const data = await response.json();
                            current.supplierDetails = data;
                            current.productPurchaseId = data.id;
                        } else {
                            current.supplierDetails = null;
                            current.productPurchaseId = null;
                        }
                    } catch (error) {
                        console.error('Error fetching supplier details:', error);
                        current.supplierDetails = null;
                        current.productPurchaseId = null;
                    } finally {
                        current.supplierDetailsLoading = false;
                    }
                },
                
                // Modal handlers
                openPurchasePriceChangeModal() {
                    const current = this.currentInvoice();
                    if (current.selectedItemIndex !== null) {
                        const item = current.invoiceItems[current.selectedItemIndex];
                        current.tempPurchasePrice = item.purchase_price;
                        new bootstrap.Modal(document.getElementById('purchasePriceChangeModal')).show();
                    }
                },
                confirmChangePurchasePrice() {
                    const current = this.currentInvoice();
                    if (current.selectedItemIndex !== null) {
                        current.invoiceItems[current.selectedItemIndex].purchase_price = current.tempPurchasePrice;
                        this.calculateInvoiceTotals();
                    }
                    bootstrap.Modal.getInstance(document.getElementById('purchasePriceChangeModal')).hide();
                },
                openQuantityChangeModal() {
                    const current = this.currentInvoice();
                    if (current.selectedItemIndex !== null) {
                        const item = current.invoiceItems[current.selectedItemIndex];
                        current.tempQuantity = item.quantity;
                        new bootstrap.Modal(document.getElementById('qtyChangeModal')).show();
                    }
                },
                confirmChangeQuantity() {
                    const current = this.currentInvoice();
                    if (current.selectedItemIndex !== null) {
                        current.invoiceItems[current.selectedItemIndex].quantity = current.tempQuantity;
                        this.calculateInvoiceTotals();
                    }
                    bootstrap.Modal.getInstance(document.getElementById('qtyChangeModal')).hide();
                },
                openDiscountModal() {
                    const current = this.currentInvoice();
                    new bootstrap.Modal(document.getElementById('discountModal')).show();
                },
                openAdditionalChargeModal() {
                    const current = this.currentInvoice();
                    new bootstrap.Modal(document.getElementById('additionalChargeModal')).show();
                },
                openSettings() {
                    new bootstrap.Modal(document.getElementById('printSettingsModal')).show();
                },

                // Submit function to handle both new and update
                // async saveInvoiceAndPrint() {
                //     const current = this.currentInvoice();
                //     if (!current.productPurchaseId) {
                //         alert('Please select a supplier first.');
                //         return;
                //     }
                //     if (current.invoiceItems.length === 0) {
                //         alert('Please add at least one item.');
                //         return;
                //     }
                    
                //     const data = {
                //         product_purchase_id: current.productPurchaseId,
                //         invoice_items: current.invoiceItems,
                //         discount_amount: current.discountAmount,
                //         discount_note: current.discountNote,
                //         additional_charge: current.additionalCharge,
                //         additional_charge_note: current.additionalChargeNote,
                //         gst_total: current.gstTotal,
                //         sub_total_excluding_gst: current.subTotalExcludingGST,
                //         sub_total_including_gst: current.subTotalIncludingGST,
                //         total_amount: current.totalAmount,
                //         print_type: current.printType
                //     };

                //     let url = '/admin/purchase/store';
                //     let method = 'POST';
                //     if (current.isEditMode) {
                //         url = `/admin/purchase/update/${current.invoiceIdOnServer}`; // Use the purchase ID
                //         method = 'PUT';
                //     }

                //     try {
                //         const response = await fetch(url, {
                //             method: method,
                //             headers: {
                //                 'Content-Type': 'application/json',
                //                 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                //             },
                //             body: JSON.stringify(data)
                //         });

                //         const result = await response.json();

                //         if (response.ok) {
                //             alert(result.message);
                //             if (result.print_url) {
                //                 window.open(result.print_url, '_blank');
                //             }
                //             window.location.href = '/admin/purchase-parties'; // Redirect to the list view
                //         } else {
                //             alert('Error: ' + result.message + (result.errors ? `\n${JSON.stringify(result.errors)}` : ''));
                //         }
                //     } catch (error) {
                //         console.error('Submission failed:', error);
                //         alert('An unexpected error occurred. Please check the console for details.');
                //     }
                // },
                


                // Submit function to handle both new and update
async saveInvoiceAndPrint() {
    const current = this.currentInvoice();
    if (!current.productPurchaseId) {
        alert('Please select a supplier first.');
        return;
    }
    if (current.invoiceItems.length === 0) {
        alert('Please add at least one item.');
        return;
    }
    
    const data = {
        // ... (data payload is correct)
        product_purchase_id: current.productPurchaseId,
        invoice_items: current.invoiceItems,
        discount_amount: current.discountAmount,
        discount_note: current.discountNote,
        additional_charge: current.additionalCharge,
        additional_charge_note: current.additionalChargeNote,
        gst_total: current.gstTotal,
        sub_total_excluding_gst: current.subTotalExcludingGST,
        sub_total_including_gst: current.subTotalIncludingGST,
        total_amount: current.totalAmount,
        print_type: current.printType
    };

    let url = '/admin/purchase/store';
    let method = 'POST';
    if (current.isEditMode) {
        // This URL correctly points to the 'update' route with the dynamic ID
        url = `/admin/purchase/update/${current.invoiceIdOnServer}`;
        method = 'POST';
    }

    try {
        const response = await fetch(url, {
            method: method,
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        const result = await response.json();

        if (response.ok) {
            alert(result.message);
            if (result.print_url) {
                window.open(result.print_url, '_blank');
            }
            window.location.href = '/admin/purchase-parties';
        } else {
            alert('Error: ' + result.message + (result.errors ? `\n${JSON.stringify(result.errors)}` : ''));
        }
    } catch (error) {
        console.error('Submission failed:', error);
        alert('An unexpected error occurred. Please check the console for details.');
    }
},

                saveHeldInvoice() {
                    const current = this.currentInvoice();
                    if (current.invoiceItems.length > 0) {
                        current.name = `Held #${this.heldInvoices.length + 1}`;
                        this.heldInvoices.push(current);
                        this.closeInvoice(current.id);
                    }
                },
                showHeldInvoicesModal() {
                    alert('This feature is not yet implemented.');
                },

                // Global keyboard shortcuts
                handleGlobalKeys(event) {
                    const current = this.currentInvoice();
                    if (event.key === 'Escape') {
                        this.exitPurchaseInvoice();
                    } else if (event.key === 'F1') {
                        event.preventDefault();
                        this.$refs.searchInput.focus();
                    } else if (event.key === 'F2') {
                        event.preventDefault();
                        this.openDiscountModal();
                    } else if (event.key === 'F3') {
                        event.preventDefault();
                        this.openAdditionalChargeModal();
                    } else if (event.key === 'F6') {
                        event.preventDefault();
                        this.saveInvoiceAndPrint();
                    } else if (event.key === 'F7') {
                        event.preventDefault();
                        this.saveHeldInvoice();
                    } else if (event.key === 'F8') {
                        event.preventDefault();
                        this.showHeldInvoicesModal();
                    } else if (event.key === 'Delete' && current.selectedItemIndex !== null) {
                        this.deleteSelectedItem();
                    } else if (event.ctrlKey && event.key === 'q') {
                        event.preventDefault();
                        this.openQuantityChangeModal();
                    } else if (event.ctrlKey && event.key === 'p') {
                        event.preventDefault();
                        this.openPurchasePriceChangeModal();
                    }
                },
                
                exitPurchaseInvoice() {
                    if (confirm('Are you sure you want to exit? Any unsaved changes will be lost.')) {
                        window.location.href = '/admin/purchase-parties';
                    }
                }
            }));
        });
    </script>
</body>

</html><?php /**PATH /var/www/adbazzar.com/resources/views/admin/purchase_edit.blade.php ENDPATH**/ ?>