
<?php $__env->startSection('title', 'Branch Admins'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid page-wrapper category-container">
    <div class="d-flex align-items-center justify-content-between">
        <h3 class="page-top-heading">Branch Details</h3>
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addModal">
            + Add Branch Admin
        </button>
    </div>
    <div class="row mt-5">
        <div class="col-lg-12">
            <div class="mb-3">
                <h6 class="table-heading">History</h6>
            </div>
            <div class="card datatable-card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th>User ID</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Logo</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($admin->name); ?></td>
                                        <td><?php echo e($admin->user_id); ?></td>
                                        <td><?php echo e($admin->email); ?></td>
                                        <td><?php echo e($admin->phone_number); ?></td>
                                        <td><?php echo e($admin->building_name); ?></td>
                                        <td>
                                            <?php if($admin->logo): ?>
                                                <img src="<?php echo e(asset($admin->logo)); ?>" alt="Logo" width="50">
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-primary editBtn"
                                                data-id="<?php echo e($admin->id); ?>"
                                                data-name="<?php echo e($admin->name); ?>"
                                                data-userid="<?php echo e($admin->user_id); ?>"
                                                data-email="<?php echo e($admin->email); ?>"
                                                data-phone="<?php echo e($admin->phone_number); ?>"
                                                data-building="<?php echo e($admin->building_name); ?>"
                                                data-logo="<?php echo e(asset($admin->logo)); ?>"
                                                data-passwordhint="<?php echo e($admin->password_hint); ?>">
                                                Edit
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center">No branch admins found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="addForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Add Branch Admin</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3"><label>Name</label><input type="text" class="form-control" name="name" required></div>
                    <div class="mb-3"><label>User ID</label><input type="text" class="form-control" name="user_id" required></div>
                    <div class="mb-3"><label>Email</label><input type="email" class="form-control" name="email" required></div>
                    <div class="mb-3 position-relative">
                        <label>Password</label>
                        <input type="password" class="form-control" name="password" id="add_password" required>
                        <i class="fa fa-eye position-absolute end-0 top-50 translate-middle-y me-3" id="toggleAddPassword"
                           style="cursor:pointer;"></i>
                    </div>
                    <div class="mb-3"><label>Phone</label><input type="text" class="form-control" name="phone_number" required></div>
                    <div class="mb-3"><label>Address</label><input type="text" class="form-control" name="building_name"></div>
                    <div class="mb-3"><label>Logo</label><input type="file" class="form-control" name="logo"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="edit_id" name="id">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Branch Admin</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3"><label>Name</label><input type="text" class="form-control" id="edit_name" name="name" required></div>
                    <div class="mb-3"><label>User ID</label><input type="text" class="form-control" id="edit_userId" name="user_id" readonly></div>
                    <div class="mb-3"><label>Email</label><input type="email" class="form-control" id="edit_email" name="email" required></div>
                   <div class="mb-3 position-relative">
    <label>New Password (Leave blank to keep current)</label>
    <input type="password" class="form-control" name="password" id="edit_password">
    <i class="fa fa-eye position-absolute end-0 top-50 translate-middle-y me-3" id="toggleEditPassword"
       style="cursor:pointer;"></i>
</div>
                    <div class="mb-3"><label>Phone</label><input type="text" class="form-control" id="edit_phone" name="phone_number" required></div>
                    <div class="mb-3"><label>Address</label><input type="text" class="form-control" id="edit_building_name" name="building_name"></div>
                    <div class="mb-3">
                        <label>Logo</label>
                        <input type="file" class="form-control" name="logo">
                        <div class="mt-2">
                            <img id="edit_logo_preview" src="" alt="Current Logo" width="100" style="display: none;">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(function() {
    $('#toggleAddPassword').click(function() {
        const input = $('#add_password');
        const type = input.attr('type') === 'password' ? 'text' : 'password';
        input.attr('type', type);
        $(this).toggleClass('fa-eye fa-eye-slash');
    });
    $('#toggleEditPassword').click(function() {
        const input = $('#edit_password');
        const type = input.attr('type') === 'password' ? 'text' : 'password';
        input.attr('type', type);
        $(this).toggleClass('fa-eye fa-eye-slash');
    });
    $(document).on('click', '.editBtn', function() {
        $('#edit_id').val($(this).data('id'));
        $('#edit_name').val($(this).data('name'));
        $('#edit_userId').val($(this).data('userid'));
        $('#edit_email').val($(this).data('email'));
        $('#edit_phone').val($(this).data('phone'));
        $('#edit_building_name').val($(this).data('building'));
        let passwordHint = $(this).data('passwordhint') || '';
        $('#edit_password').val(passwordHint).attr('data-hint', 'true');
        let logo = $(this).data('logo');
        if (logo) {
            $('#edit_logo_preview').attr('src', logo).show();
        } else {
            $('#edit_logo_preview').hide();
        }
        $('#editModal').modal('show');
    });
    $(document).on('focus', '#edit_password', function() {
        if ($(this).attr('data-hint') === 'true') {
            $(this).val('').removeAttr('data-hint');
        }
    });
    $('#addForm').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);
        $.ajax({
            url: "<?php echo e(route('branch-admin.store')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(res) {
                if (res.success) {
                    alert(res.message);
                    location.reload();
                } else {
                    alert("Something went wrong!");
                }
            },
            error: function(err) {
                console.log(err);
                alert("Error saving!");
            }
        });
    });
    $('#editForm').submit(function(e) {
        e.preventDefault();
        let id = $('#edit_id').val();
        let formData = new FormData(this);
        const passwordField = $('#edit_password');
        if (passwordField.attr('data-hint') === 'true') {
            formData.delete('password');
        }
        $.ajax({
            url: "<?php echo e(route('branch-admin.update', ':id')); ?>".replace(':id', id),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(res) {
                if (res.success) {
                    alert(res.message);
                    location.reload();
                } else {
                    alert("Update failed!");
                }
            },
            error: function(err) {
                console.log(err.responseJSON);
                alert(err.responseJSON?.message || "Error updating!");
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/edit_branch.blade.php ENDPATH**/ ?>