<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GetCartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'               => $this->id,
            'user_id'          => $this->user_id,
            'product_id'       => $this->product_id,
            'variant_id'       => $this->variant_id,
            'title'            => $this->product->title,
            'image'            => url($this->product->image),
            'category_name'    => $this->product->category_name,
            'subcategory_name' => $this->product->subcategory_name,
            'quantity'         => $this->quantity,
            'price'            => $this->price,
        ];
    }
}
