<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
        'id'               => $this->id,
        'category_id'      => $this->category_id,
        'category_name'    => $this->category ? $this->category->category_name : null,
        'subcategory_name' => $this->subcategory ? $this->subcategory->subcategory_name : null,
        'title'            => $this->title,
        'description'      => $this->description,
        'image'            => url($this->image),
        'brand'            => $this->brand,
        'package'          => $this->package,
        'is_wishlist'      => $this->is_wishlist,
        'variations'       => ProductVarientResources::collection($this->variants),
        ];
    }
    }

