<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubCatByPrdctResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
      
        return [
            'id'             => $this->id,
            'category_id'    => $this->category_id,
            'subcategory_id' => $this->subcategory_id,
            'image'          => url($this->image),
            'brand'          => $this->brand,
            'title'          => $this->title,
            'description'    => $this->description,
            'package'        => $this->package,
            'is_wishlist'    => $this->wishlist->isNotEmpty(),
            'variations'    => ProductVarientResources::collection($this->whenLoaded('variants')),
        ];
      
    }
}
