<!-- cancelled_orders.blade.php -->
@extends('admin.layouts')
@section('title', 'Cancelled Orders')

@section('content')
    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Cancelled Orders</h3>
            </div>
        </div>

        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER DETAILS</th>
                                    <th>PRODUCT DETAILS</th>
                                    <th>AMOUNT</th>
                                    <th>ADDRESS</th>
                                    <th>INSTRUCTION</th>
                                    <th>STATUS</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cancelled_orders as $order)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ \Carbon\Carbon::parse($order->order_date)->format('d-m-Y') }}</td>
                                        <td class="custom-td">{{ $order->order_random_id }}</td>
                                        <td>
                                            <div>{{ $order->user_name }}</div>
                                            <div>{{ $order->user->phone_number }}</div>
                                            <div>{{ $order->user->email }}</div>
                                        </td>
                                        <td> <a href="{{ route('view_cancel_orders', ['order_random_id' => $order->order_random_id]) }}" type="button" class="btn btn-primary btn-sm">
                                            <i class="fa-regular fa-eye me-2"></i>View
                                        </a></td>
                                        <td><span>{{ $order->amount }}</span></td>
                                        <td class="custom-td">{{ $order->delivery_address }}</td>
                                        <td class="custom-td">{{ $order->instruction }}</td>
                                        <td>
                                            <!-- Status column with a red button -->
                                            <button type="button" class="btn btn-danger btn-sm">Cancelled</button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->
    </div>
@endsection
