@extends('admin.layouts')
@section('title', 'Processing Orders')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">

@endsection
@section('content')



<div class="container-fluid page-wrapper">

   <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Shipped Orders</h3>
        </div>
    </div>

       <!-- Table Row -->
       <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER DETAILS</th>
                                    <th>PRODUCT DETAILS</th>
                                    <th>AMOUNT</th>
                                    <th>ADDRESS</th>
                                    <th>INSTRUCTION</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recent_orders as $recent_order)
                                    <tr>

                                        <td>{{ $loop->iteration }}</td>
                                       
                                        <td>{{ \Carbon\Carbon::parse($recent_order->order_date)->format('d-m-Y') }}</td>
                                        <td class="custom-td">{{ $recent_order->order_random_id}}</td>
                                        <td>
                                            <div>{{ $recent_order->user_name }}</div>
                                                <div>{{ $recent_order->user->phone_number }}</div>
                                                <div>{{ $recent_order->user->email}}</div>
                                        </td>
                                       
                                        <td> <a href="{{route('view_processing_orders', ['order_random_id' => $recent_order->order_random_id])}}" type="button" class="btn btn-primary btn-sm">
                                            <i class="fa-regular fa-eye me-2"></i>View
                                        </a></td>
                                        <td><span>{{ $recent_order->amount }}</span></td>
                                        <td class="custom-td">{{ $recent_order->delivery_address }}</td>
                                        <td class="custom-td">{{ $recent_order->instruction }}</td>
                                      
                                        <td>
                                            <span class="badge warning-badge">Processing</span>
                                        </td>
                                        <td>
                                            <button type="button" data-bs-toggle="modal" data-bs-target="#DeliveryConfirmationModal{{ $recent_order->id }}" class="btn btn-primary">
                                                <i class="fa-regular fa-circle-check me-1"></i>
                                                Confirm Delivery
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
        </table>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->

      <!-- Delivery Confirmation Modal Starts -->
@foreach($recent_orders as $recent_order)
<div class="modal fade zoom-in" id="DeliveryConfirmationModal{{ $recent_order->id }}" tabindex="-1" aria-labelledby="DeliveryConfirmationModalLabel{{ $recent_order->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="p-3">
                            <div class="text-center">
                                <img class="mb-3" style="height: 75px;" src="{{ asset('/assets/images/gif/accept.png') }}">
                                <p class="my-4 are-you-sure">Are You Sure</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to confirm delivery for this order?</p>
                            </div>
                            <form action="{{ route('confirm_delivery') }}" method="POST">
                                @csrf
                                <input type="hidden" name="order_id" value="{{ $recent_order->id }}">
                                <input type="hidden" name="status" value="delivered">
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button type="button" data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <button type="submit" class="btn btn-primary yes-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i>Yes, Confirm!
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endforeach
<!-- Delivery Confirmation Modal Ends -->


    
</div>
<!-- end container fluid -->




@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>



@endsection


