
@extends('admin.layouts')
@section('title', 'Cancelled Order Details')

@section('content')
    <div class="container-fluid page-wrapper">
        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">Cancelled Order Details</h3>
            </div>
        </div>

        <!-- Order Details -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                     
                      
                       
                        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER DETAILS</th>
                                    <th>PRODUCT DETAILS</th>
                                    <th>AMOUNT</th>
                                    <th>ADDRESS</th>
                                    <th>INSTRUCTION</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cancelled_order as $cancelled_orders)
                                    <tr>

                                        <td>{{ $loop->iteration }}</td>
                                    
                                        <td>{{ \Carbon\Carbon::parse($cancelled_orders->order_date)->format('d-m-Y') }}</td>
                                        <td class="custom-td">{{ $cancelled_orders->order_random_id}}</td>
                                        <td>
                                            <div>{{ $cancelled_orders->user_name }}</div>
                                                <div>{{ $cancelled_orders->user->phone_number }}</div>
                                                <div>{{ $cancelled_orders->user->email}}</div>
                                        </td>
                                        <td>
                                            <p>Product Name:{{ $cancelled_orders->product_details_name ?? 'N/A' }}</p>
                                            <p>Category:{{ $cancelled_orders->category_name ?? 'N/A' }} </p>
                                            <p>SubCategory:{{ $cancelled_orders->subcategory_name ?? 'N/A' }}</p>
                                        </td>
                                      
                                      
                                        <td><span>{{ $cancelled_orders->amount }}</span></td>
                                        <td class="custom-td">{{ $cancelled_orders->delivery_address }}</td>
                                        <td class="custom-td">{{ $cancelled_orders->instruction }}</td>
                                    </td>
                                    </tr>
                                @endforeach
                            </tbody>


                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
