<?php

use App\Http\Controllers\API\CategoryController;
use App\Http\Controllers\API\ForgetPasswordController;
use App\Http\Controllers\API\LoginController;
use App\Http\Controllers\API\ProductController;
use App\Http\Controllers\API\RegisterController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\WishlistController;
use App\Http\Controllers\API\CartController;
use App\Http\Controllers\Subscription\SubscriptionController;
use App\Http\Controllers\Video\VideoController;
use Illuminate\Support\Facades\Route;


Route::get('banner', [UserController::class, 'banner']);

Route::middleware('api.key')->group(function () {
  //Registration
  Route::post('registration_post', [RegisterController::class, 'registration_post']);

  //login
  Route::post('login_post', [LoginController::class, 'login_post']);


  //forgetpassword
  Route::post('forgetpassword', [ForgetPasswordController::class, 'forgetpassword']);
  Route::post('create_password', [ForgetPasswordController::class, 'create_password']);
  //category
  Route::get('category', [UserController::class, 'category']);
  //banner
  // Route::get('banner', [UserController::class, 'banner']);
  //products
  Route::get('products', [UserController::class, 'products']);

  Route::middleware('auth:sanctum')->group(function () {

    //Referral Link
    Route::get('referral_link', [LoginController::class, 'referral_link']);

    //Memberships
    Route::get('membership_list', [SubscriptionController::class, 'membership_list']);
    Route::post('add_subscription', [SubscriptionController::class, 'add_subscription']);
    Route::get('bank_details', [SubscriptionController::class, 'bank_details']);
    Route::get('income_wallet', [SubscriptionController::class, 'income_wallet']);

    //Videos
    Route::get('daily_task', [VideoController::class, 'daily_task']);
    Route::get('daily_videos', [VideoController::class, 'daily_videos']);
    Route::get('single_video/{video_id}', [VideoController::class, 'single_video']);
    Route::post('video_form', [VideoController::class, 'video_form']);


    Route::post('reset_password', [LoginController::class, 'reset_password']);
    //delivery_fee
    Route::get('delivery_fee', [UserController::class, 'delivery_fee']);
    Route::get('delivery_fee_town/{town}', [CategoryController::class, 'delivery_fee_town']);
    Route::get('delivery_fee_area/{area}', [CategoryController::class, 'delivery_fee_area']);
    //category
    Route::get('category/{id}', [UserController::class, 'category_id']);
    Route::get('category_product/{id}', [CategoryController::class, 'category_product']);
    //products
    Route::get('accepted_orders', [CategoryController::class, 'accepted_orders']);
    Route::get('accepted_orders/{id}', [CategoryController::class, 'acceptedorders']);
    //order_details
    Route::get('order_details/{user_id}', [CategoryController::class, 'order_details']);
    //checkout
    Route::post('checkout', [CartController::class, 'checkout']);
    Route::get('getCheckoutDetails/{orderId}', [CartController::class, 'getCheckoutDetails']);

    //cart
    Route::post('cart_add', [CartController::class, 'cart_add']);
    Route::get('cart', [CartController::class, 'cart']);
    Route::post('cart_update', action: [CartController::class, 'cart_update']);
    Route::post('cart_delete', [CartController::class, 'cart_delete']);
    //product/id
    Route::get('products/{id}', [UserController::class, 'products_id']);
    //sucategory
    Route::get('subcategory/{categoryId}', [CategoryController::class, 'subcategory']);
    //notification
    Route::post('order_place', [ProductController::class, 'order_place']);
    Route::get('notification', [UserController::class, 'notification']);
    //user_details
    Route::get('user_details', [UserController::class, 'user_details']);
    //delivered_orders
    Route::get('delivered_orders', [CategoryController::class, 'delivered_orders']);
    Route::get('delivered_orders/{id}', [CategoryController::class, 'delivered_orderss']);
    //shipped_orders
    Route::get('shipped_orders', [CategoryController::class, 'shipped_orders']);
    Route::get('shipped_orders/{id}', [CategoryController::class, 'shipped_orderss']);
    //profileupdate
    Route::post('profile_update', [LoginController::class, 'profile_update']);
    //packing instruction
    Route::post('packing_instruction', [CategoryController::class, 'packing_instruction']);
    Route::post('checkout_packing_instruction', [CategoryController::class, 'checkout_packing_instruction']);
    //order_details
    Route::get('order_details/{user_id}', [CategoryController::class, 'order_details']);
    Route::get('orderdetails/{order_random_id}', [ProductController::class, 'orderdetails']);
    //address
    Route::post('address', [CartController::class, 'address']);
    Route::post('address_update/{id}', [CartController::class, 'address_update']);
    Route::get('addresses', [CartController::class, 'addresses']);
    Route::get('addresses_delete/{id}', [CartController::class, 'addresses_delete']);
    Route::get('show_address/{id}', [CartController::class, 'show_address']);
    Route::post('address_current/{id}', [CartController::class, 'address_current']);
    //wishlist
    Route::post('wishlist', [WishlistController::class, 'wishlist']);
    Route::post('wishlist_update', [WishlistController::class, 'wishlist_update']);
    Route::get('wishlist_delete/{product_id}', [WishlistController::class, 'wishlist_delete']);
    Route::get('wishlist_display', [WishlistController::class, 'wishlist_display']);
    // searchProduct
    Route::post('searchProduct', [WishlistController::class, 'searchProduct']);
    Route::get('getProductsBySubcategory/{subcategoryId}', [ProductController::class, 'getProductsBySubcategory']);
    Route::get('getProductByCategory/{categoryId}', [ProductController::class, 'getProductByCategory']);
    //logout
    Route::post('logout', [LoginController::class, 'logout']);
  });
});
