<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('header'); ?>

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="container-fluid page-wrapper category-container">

   <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">User Management</h3>
        </div>
    </div>

       <!-- Table Row -->
       <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>USER ID</th>
                                <th>NAME</th>
                                <th>EMAIL</th>
                                <th>PHONE NUMBER</th>
                                <th>ADDRESS</th>
                                <th>ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $currentAddress = \App\Models\Address::getCurrentAddress($user->id);
                                ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($user->user_id); ?></td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->phone_number); ?></td>
                                    <td>
                                        <?php if($currentAddress): ?>
                                            <?php echo e($currentAddress->house_no); ?>, <?php echo e($currentAddress->road_name); ?>, <?php echo e($currentAddress->landmark); ?>,
                                            <?php echo e($currentAddress->district); ?>, <?php echo e($currentAddress->state); ?> - <?php echo e($currentAddress->pin); ?>

                                        <?php else: ?>
                                            No current address set
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('view_orders', ['id' => $user->id])); ?>" type="button" class="btn btn-primary rounded-pill">
                                            <i class="fa-regular fa-eye me-2"></i>View Orders
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->


    
    
</div>
<!-- end container fluid -->




<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>



<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/user_management.blade.php ENDPATH**/ ?>